/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.connection.impl;

import java.util.Queue;
import org.apache.commons.logging.Log;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.exoplatform.services.xmpp.util.HistoryUtils;
import org.jivesoftware.smack.packet.Message;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class HistoryJob
implements Job {
    private static Log log = ExoLogger.getLogger((String)"job.ChatRecordsJob");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            RootContainer container = RootContainer.getInstance();
            container = container.getPortalContainer(jdatamap.getString("portalName"));
            int logBatchSize = Integer.parseInt(jdatamap.getString("logBatchSize"));
            HistoryImpl historyImpl = (HistoryImpl)container.getComponentInstanceOfType(HistoryImpl.class);
            Queue<Message> logQueue = historyImpl.getLogQueue();
            for (int index = 0; index <= logBatchSize && !logQueue.isEmpty(); ++index) {
                boolean success;
                Message message = logQueue.poll();
                if (message == null || (success = historyImpl.addHistoricalMessage(HistoryUtils.messageToHistoricalMessage(message), provider))) continue;
                logQueue.add(message);
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString());
        }
        finally {
            provider.close();
        }
    }
}

