/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.Connector;
import org.exoplatform.services.rest.MultivaluedMetadata;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.servlet.RequestFactory;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

public class MessengerServlet
extends HttpServlet
implements Connector {
    private static final long serialVersionUID = -5976447080959500615L;
    private static final Log LOGGER = ExoLogger.getLogger((String)"MessangerServlet");
    private int connectionTimeout;
    private int timeChekEvent;

    public void init() throws ServletException {
        String timeOut = this.getInitParameter("connection-timeout");
        String timeChekEventStr = this.getInitParameter("time-check-event");
        if (timeOut != null) {
            this.connectionTimeout = Integer.parseInt(timeOut);
        } else {
            LOGGER.info((Object)"Connection timeout is not set, default 60000 ms");
            this.connectionTimeout = 60000;
        }
        if (timeChekEventStr != null) {
            this.timeChekEvent = Integer.parseInt(timeChekEventStr);
        } else {
            LOGGER.info((Object)"Timeout for cheking event is not set, default 3000 ms");
            this.timeChekEvent = 3000;
        }
    }

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        HttpSession httpSession;
        httpRequest.setCharacterEncoding("UTF-8");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ConversationRegistry conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        ConversationState state = null;
        String userId = httpRequest.getRemoteUser();
        if (userId != null && (state = conversationRegistry.getState((Object)(httpSession = httpRequest.getSession()).getId())) != null && !userId.equals(state.getIdentity().getUserId())) {
            conversationRegistry.unregister((Object)httpSession.getId());
        }
        LOGGER.debug((Object)("Current Container: " + container));
        ResourceDispatcher dispatcher = (ResourceDispatcher)container.getComponentInstanceOfType(ResourceDispatcher.class);
        LOGGER.debug((Object)("ResourceDispatcher: " + dispatcher));
        if (dispatcher == null) {
            throw new ServletException("ResourceDispatcher is null.");
        }
        try {
            ServletOutputStream out = httpResponse.getOutputStream();
            Response response = dispatcher.dispatch(RequestFactory.createRequest((HttpServletRequest)httpRequest));
            httpResponse.setStatus(response.getStatus());
            this.tuneResponse(httpResponse, response.getResponseHeaders());
            response.writeEntity((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"dispatch method error!");
            LOGGER.debug((Object)e);
            httpResponse.sendError(500, "This request can't be serve by service.\nCheck request parameters and try again.");
        }
    }

    private void tuneResponse(HttpServletResponse httpResponse, MultivaluedMetadata responseHeaders) {
        if (responseHeaders != null) {
            HashMap headers = responseHeaders.getAll();
            Set keys = headers.keySet();
            for (String key : keys) {
                httpResponse.setHeader(key, (String)headers.get(key));
            }
        }
    }
}

