/**
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.xmpp.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.Connector;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestHandler;
//import org.exoplatform.services.rest.MultivaluedMetadata;
//import org.exoplatform.services.rest.ResourceDispatcher;
//import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.RequestDispatcher;
import org.exoplatform.services.rest.impl.header.HeaderHelper;
import org.exoplatform.services.rest.servlet.ServletContainerRequest;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;
//import org.exoplatform.services.rest.servlet.RequestFactory;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;

/**
 * Created by The eXo Platform SAS.
 * 
 * @author <a href="mailto:vitaly.parfonov@gmail.com">Vitaly Parfonov</a>
 * @version $Id: $
 */

@Deprecated
public class MessengerServlet extends HttpServlet implements Connector {

  /**
   * Generated by eclipse.
   */
  private static final long serialVersionUID = -5976447080959500615L;

  /**
   * 
   */
  private static final Log  LOGGER           = LogFactory.getLog("MessangerServlet");

  /**
   * 
   */
  private int               connectionTimeout;

  /**
   * 
   */
  private int               timeChekEvent;
  
  /**
   * See {@link ServletConfig}.
   */
  private ServletConfig     config;

  /**
   * See {@link ServletContext}.
   */
  private ServletContext    context;

  @Override
  public void init(ServletConfig config) throws ServletException {
	this.config = config;
	this.context = config.getServletContext();
	try {
	    final String timeOut = this.getInitParameter("connection-timeout");
	    final String timeChekEventStr = this.getInitParameter("time-check-event");
	    if (timeOut != null)
	      connectionTimeout = Integer.parseInt(timeOut);
	    else {
	      LOGGER.info("Connection timeout is not set, default 60000 ms");
	      connectionTimeout = 60 * 1000;
	    }
	    if (timeChekEventStr != null)
	      timeChekEvent = Integer.parseInt(timeChekEventStr);
	    else {
	      LOGGER.info("Timeout for cheking event is not set, default 3000 ms");
	      timeChekEvent = 3 * 1000;
	    }
	} catch(Exception e){
		LOGGER.error("Can not get init parameters");
	}
  }

  @Override
  public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException,
                                                                                       ServletException {
    httpRequest.setCharacterEncoding("UTF-8");
    ExoContainer container = ExoContainerContext.getCurrentContainer();
    ConversationRegistry conversationRegistry =
        (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
    ConversationState state = null;
    String userId = httpRequest.getRemoteUser();
    if (userId != null){
    	HttpSession httpSession = httpRequest.getSession();
        StateKey stateKey = new HttpSessionStateKey(httpSession);
        state = conversationRegistry.getState(stateKey);
        if(state != null){
        	if(!userId.equals(state.getIdentity().getUserId())){
        		conversationRegistry.unregister(stateKey);
        	}
        }
    }
    
    LOGGER.debug("Current Container: " + container);
    /*RequestDispatcher dispatcher = (RequestDispatcher) container.getComponentInstanceOfType(RequestDispatcher.class);
    LOGGER.debug("ResourceDispatcher: " + dispatcher);
    if (dispatcher == null) {
      throw new ServletException("ResourceDispatcher is null.");
    }*/
    RequestHandler requestHandler = (RequestHandler) container.getComponentInstanceOfType(RequestHandler.class);

    EnvironmentContext env = new EnvironmentContext();
    env.put(HttpServletRequest.class, httpRequest);
    env.put(HttpServletResponse.class, httpResponse);
    env.put(ServletConfig.class, config);
    env.put(ServletContext.class, context);
    
    try {
        EnvironmentContext.setCurrent(env);
        ServletContainerRequest request = new ServletContainerRequest(httpRequest);
        ContainerResponse response = new ContainerResponse(new ServletContainerResponseWriter(httpResponse));
        requestHandler.handleRequest(request, response);
    } catch (Exception e) {
      throw new ServletException(e);
    } finally {
      EnvironmentContext.setCurrent(null);
    }
    
    /*try {
      
       * boolean waitingResponse; try { waitingResponse = new
       * Boolean(httpRequest.getParameter("waiting-response")); } catch
       * (Exception e) { waitingResponse = false; } if (waitingResponse) { //
       * long connection OutputStream out = httpResponse.getOutputStream(); long
       * start = System.currentTimeMillis(); long timeOut = start +
       * connectionTimeout; while (true) { Response response =
       * dispatcher.dispatch(RequestFactory .createRequest(httpRequest)); if
       * (response.getStatus() != HTTPStatus.NOT_MODIFIED) {
       * httpResponse.setStatus(response.getStatus());
       * tuneResponse(httpResponse, response.getResponseHeaders());
       * response.writeEntity(out); out.flush(); out.close(); break; } if
       * (System.currentTimeMillis() > timeOut) { httpResponse.setStatus(200);
       * // NO_CONETNT LOGGER.debug("Timeout " + System.currentTimeMillis());
       * break; } Thread.sleep(timeChekEvent); } } else { // simple connection
       
      OutputStream out = httpResponse.getOutputStream();
      //TODO need to check with new code
      Response response = dispatcher.dispatch(RequestFactory.createRequest(httpRequest));
      httpResponse.setStatus(response.getStatus());
      tuneResponse(httpResponse, response.);
      response.writeEntity(out);
      out.flush();
      out.close();
      // }
    } catch (Exception e) {
      LOGGER.error("dispatch method error!");
      LOGGER.debug(e);
      httpResponse.sendError(500, "This request can't be serve by service.\n"
          + "Check request parameters and try again.");
    }*/
  }

  /**
   * See {@link ContainerResponseWriter}.
   */
  class ServletContainerResponseWriter implements ContainerResponseWriter {

    /**
     * See {@link HttpServletResponse}.
     */
    private HttpServletResponse servletResponse;

    /**
     * @param response HttpServletResponse
     */
    ServletContainerResponseWriter(HttpServletResponse response) {
      this.servletResponse = response;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
      Object entity = response.getEntity();
      if (entity != null) {
        OutputStream out = servletResponse.getOutputStream();
        entityWriter.writeTo(entity,
                             entity.getClass(),
                             response.getEntityType(),
                             null,
                             response.getContentType(),
                             response.getHttpHeaders(),
                             out);
        out.flush();
      }
    }

    /**
     * {@inheritDoc}
     */
    public void writeHeaders(GenericContainerResponse response) throws IOException {
      if (servletResponse.isCommitted())
        return;

      servletResponse.setStatus(response.getStatus());

      if (response.getHttpHeaders() != null) {
        // content-type and content-length should be preset in headers
        for (Map.Entry<String, List<Object>> e : response.getHttpHeaders().entrySet()) {
          String name = e.getKey();
          for (Object o : e.getValue()) {
            String value = null;
            if (o != null && (value = HeaderHelper.getHeaderAsString(o)) != null)
              servletResponse.addHeader(name, value);
          }
        }
      }
    }
  }
  
  /**
   * Tune HTTP response.
   * 
   * @param httpResponse HTTP response.
   * @param responseHeaders HTTP response headers.
   */
  /*private void tuneResponse(HttpServletResponse httpResponse, MultivaluedMetadata responseHeaders) {
    if (responseHeaders != null) {
      HashMap<String, String> headers = responseHeaders.getAll();
      Set<String> keys = headers.keySet();
      Iterator<String> ikeys = keys.iterator();
      while (ikeys.hasNext()) {
        String key = ikeys.next();
        httpResponse.setHeader(key, headers.get(key));
      }
    }
  }*/

}
