/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.userinfo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.xmpp.userinfo.UserInfo;
import org.exoplatform.services.xmpp.userinfo.UserInfoService;

public class OrganizationUserInfoServiceImpl
implements UserInfoService {
    private final Log log = LogFactory.getLog(OrganizationUserInfoServiceImpl.class);
    private static OrganizationService organizationService;

    protected void start() {
        PortalContainer manager = PortalContainer.getInstance();
        ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)manager);
    }

    protected void stop() {
        PortalContainer manager = PortalContainer.getInstance();
        ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)manager);
    }

    public OrganizationUserInfoServiceImpl(OrganizationService service) {
        organizationService = service;
    }

    public OrganizationService getOrganizationService() {
        return organizationService;
    }

    public UserInfo getUserInfo(String userID) {
        try {
            this.start();
            User user = organizationService.getUserHandler().findUserByName(userID);
            this.stop();
            UserInfo userInfo = new UserInfo();
            userInfo.setUserName(user.getUserName());
            userInfo.setFirstName(user.getFirstName());
            userInfo.setLastName(user.getLastName());
            userInfo.setEMail(user.getEmail());
            userInfo.setOrganization(user.getOrganizationId());
            return userInfo;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String providePassword(String userID) {
        block3: {
            try {
                ConversationState curentState = ConversationState.getCurrent();
                String username = curentState.getIdentity().getUserId();
                if (userID != null && userID.equals(username)) {
                    return (String)curentState.getIdentity().getSubject().getPrivateCredentials().iterator().next();
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        return null;
    }
}

