/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.rest.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Path;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.Filter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;

@Path(value="/xmpp/{x:.*}")
@Filter
public class RESTXMPPServiceFilter
implements RequestFilter {
    private final Log log = ExoLogger.getLogger((String)RESTXMPPServiceFilter.class.getName());

    public void doFilter(GenericContainerRequest request) {
        block3: {
            try {
                HttpSession httpSession;
                HttpSessionStateKey stateKey;
                EnvironmentContext env = EnvironmentContext.getCurrent();
                HttpServletRequest httpRequest = (HttpServletRequest)env.get(HttpServletRequest.class);
                httpRequest.setCharacterEncoding("UTF-8");
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                ConversationRegistry conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
                ConversationState state = null;
                String userId = httpRequest.getRemoteUser();
                if (userId != null && (state = conversationRegistry.getState((StateKey)(stateKey = new HttpSessionStateKey(httpSession = httpRequest.getSession())))) != null && !userId.equals(state.getIdentity().getUserId())) {
                    conversationRegistry.unregister((StateKey)stateKey);
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Message: " + e.getMessage() + ". Cause: " + e.getCause()));
            }
        }
    }
}

