/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chatbar.webui;

import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.chatbar.Utils;
import org.exoplatform.chatbar.webui.UIConfigForm;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UIChatBarPortlet
extends UIPortletApplication {
    private String windowId;
    protected static final String VIEWMODE_TEMP = "app:/templates/chatbar/webui/UIChatBarPortlet.gtmpl";
    protected static final String EDITMODE_TEMP = "app:/templates/chatbar/webui/UIChatBarEdit.gtmpl";
    private String templatePath_ = "app:/templates/chatbar/webui/UIChatBarPortlet.gtmpl";
    private String status_ = null;

    public UIChatBarPortlet() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = context.getRequest();
        this.windowId = prequest.getWindowID();
    }

    public String getId() {
        return this.windowId;
    }

    public String getRemoteUser() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public String getUserToken() {
        try {
            return this.getContinuationService().getUserToken(this.getRemoteUser());
        }
        catch (Exception e) {
            System.out.println("\n\n can not get UserToken");
            return "";
        }
    }

    protected ContinuationService getContinuationService() {
        ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    protected String getRestContextName() {
        String restBaseUri = Util.getPortalRequestContext().getRequestContextPath() + "/" + PortalContainer.getInstance().getRestContextName();
        if (restBaseUri.startsWith("/")) {
            restBaseUri = restBaseUri.substring(1, restBaseUri.length());
        }
        return restBaseUri;
    }

    protected String getCometdContextName() {
        String cometdContextName = "cometd";
        try {
            EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
            return bayeux == null ? "cometd" : bayeux.getCometdContextName();
        }
        catch (Exception exception) {
            return cometdContextName;
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        try {
            PortletRequestContext portletReqContext = (PortletRequestContext)context;
            if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
                this.templatePath_ = VIEWMODE_TEMP;
            } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
                UIConfigForm uiForm = (UIConfigForm)this.getChild(UIConfigForm.class);
                if (uiForm == null) {
                    uiForm = (UIConfigForm)this.addChild(UIConfigForm.class, null, null);
                }
                uiForm.reset();
                uiForm.init();
                this.templatePath_ = EDITMODE_TEMP;
            }
            super.processRender(app, context);
        }
        catch (Exception e) {
            log.error((Object)"Cannot display the content of the chatbar", (Throwable)e);
        }
    }

    public String getTemplate() {
        return this.templatePath_;
    }

    public void setTemplate(String temp) {
        this.templatePath_ = temp;
    }

    protected boolean isShowEmailLink() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(UIConfigForm.MAIL_APP, null));
    }

    protected boolean isShowCalendarLink() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(UIConfigForm.CAL_APP, null));
    }

    protected boolean isShowContactLink() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(UIConfigForm.CON_APP, null));
    }

    protected String getEmailLink() {
        String path = this.getPortletPreferences().getValue(UIConfigForm.MAIL_URL, null);
        if (Utils.isUri((String)path)) {
            return path;
        }
        return Utils.getServerBaseUrl() + path;
    }

    protected String getCalendarLink() {
        String path = this.getPortletPreferences().getValue(UIConfigForm.CAL_URL, null);
        if (Utils.isUri((String)path)) {
            return path;
        }
        return Utils.getServerBaseUrl() + path;
    }

    protected String getContactLink() {
        String path = this.getPortletPreferences().getValue(UIConfigForm.CON_URL, null);
        if (Utils.isUri((String)path)) {
            return path;
        }
        return Utils.getServerBaseUrl() + path;
    }

    private PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pcontext.getRequest().getPreferences();
    }

    protected void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }

    public String getStatus() {
        return this.status_;
    }

    public void setStatus(String status) {
        this.status_ = status;
    }
}

