/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chatbar.webui;

import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.chatbar.webui.UIConfigForm;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UIChatBarPortlet
extends UIPortletApplication {
    private Log log = ExoLogger.getLogger(this.getClass());
    private String windowId;
    protected static final String VIEWMODE_TEMP = "app:/templates/chatbar/webui/UIChatBarPortlet.gtmpl";
    protected static final String EDITMODE_TEMP = "app:/templates/chatbar/webui/UIChatBarEdit.gtmpl";
    private static final String BASE_URL_VALUE = "/portal/intranet/";
    private static final String BASE_URL_KEY = "cs.chatbar.shortcut.baseUrl";
    private String templatePath_ = "app:/templates/chatbar/webui/UIChatBarPortlet.gtmpl";
    private String status_ = null;

    public UIChatBarPortlet() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = context.getRequest();
        this.windowId = prequest.getWindowID();
    }

    public String getId() {
        return this.windowId;
    }

    public String getRemoteUser() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public String getUserToken() {
        try {
            return this.getContinuationService().getUserToken(this.getRemoteUser());
        }
        catch (Exception e) {
            this.log.info((Object)"\n\n can not get UserToken");
            return "";
        }
    }

    protected ContinuationService getContinuationService() {
        ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    protected String getRestContextName() {
        String restBaseUri = Util.getPortalRequestContext().getRequestContextPath() + "/" + PortalContainer.getInstance().getRestContextName();
        if (restBaseUri.startsWith("/")) {
            restBaseUri = restBaseUri.substring(1, restBaseUri.length());
        }
        return restBaseUri;
    }

    protected String getCometdContextName() {
        String cometdContextName = "cometd";
        try {
            EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
            return bayeux == null ? "cometd" : bayeux.getCometdContextName();
        }
        catch (Exception exception) {
            return cometdContextName;
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        try {
            PortletRequestContext portletReqContext = (PortletRequestContext)context;
            if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
                this.templatePath_ = VIEWMODE_TEMP;
            } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
                UIConfigForm uiForm = (UIConfigForm)this.getChild(UIConfigForm.class);
                if (uiForm == null) {
                    uiForm = (UIConfigForm)this.addChild(UIConfigForm.class, null, null);
                }
                uiForm.reset();
                uiForm.init();
                this.templatePath_ = EDITMODE_TEMP;
            }
            super.processRender(app, context);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot display the content of the chatbar", (Throwable)e);
        }
    }

    public String getTemplate() {
        return this.templatePath_;
    }

    public void setTemplate(String temp) {
        this.templatePath_ = temp;
    }

    protected boolean isShowEmailLink() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(UIConfigForm.MAIL_APP, null));
    }

    protected boolean isShowCalendarLink() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(UIConfigForm.CAL_APP, null));
    }

    protected boolean isShowContactLink() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(UIConfigForm.CON_APP, null));
    }

    protected String getEmailLink() {
        String path = this.getPortletPreferences().getValue(UIConfigForm.MAIL_URL, null);
        return this.getShortcutBaseUrl() + path;
    }

    private String getShortcutBaseUrl() {
        String sUrl = null;
        try {
            sUrl = System.getProperties().getProperty(BASE_URL_KEY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtils.isNotBlank((String)sUrl)) {
            sUrl = BASE_URL_VALUE;
        }
        return sUrl;
    }

    protected String getCalendarLink() {
        String path = this.getPortletPreferences().getValue(UIConfigForm.CAL_URL, null);
        return this.getShortcutBaseUrl() + path;
    }

    protected String getContactLink() {
        String path = this.getPortletPreferences().getValue(UIConfigForm.CON_URL, null);
        return this.getShortcutBaseUrl() + path;
    }

    private PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pcontext.getRequest().getPreferences();
    }

    public String getStatus() {
        return this.status_;
    }

    public void setStatus(String status) {
        this.status_ = status;
    }
}

