/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String SPLIT = "::".intern();
    public static final String SEMI_COLON = ";".intern();
    public static final String COMMA = ",".intern();
    public static final String contactTempId = "ContacttempId";
    public static int limitExport = 150;

    public static String formatDate(String format, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format((Object)date);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static List<String> parseEmails(String emails) throws Exception {
        ArrayList<String> emailList = new ArrayList<String>();
        if (Utils.isEmpty(emails)) {
            return emailList;
        }
        for (String email : emails.replaceAll(SEMI_COLON, COMMA).split(COMMA)) {
            if (!Utils.isValidEmailAddresses(email = InternetAddress.parse((String)email)[0].getAddress())) continue;
            emailList.add(email);
        }
        return emailList;
    }

    public static boolean isValidEmailAddresses(String email) {
        if (Utils.isEmpty(email)) {
            return false;
        }
        String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
        return email.trim().matches(emailRegex);
    }
}

