/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactImportExport;
import org.exoplatform.contact.service.ContactPageList;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.GroupContactData;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Tag;
import org.exoplatform.contact.service.impl.JCRDataStorage;
import org.exoplatform.contact.service.impl.VCardImportExport;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactServiceImpl
implements ContactService {
    private static final String VCARD = "x-vcard".intern();
    private JCRDataStorage storage_;
    private Map<String, ContactImportExport> contactImportExport_ = new HashMap<String, ContactImportExport>();

    public ContactServiceImpl(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator);
        this.contactImportExport_.put(VCARD, new VCardImportExport(this.storage_));
    }

    @Override
    public List<Contact> getPersonalContacts(String username) throws Exception {
        return this.storage_.findAllContactsByOwner(username);
    }

    @Override
    public Map<String, String> searchEmails(String username, ContactFilter filter) throws Exception {
        return this.storage_.findEmailsByFilter(username, filter);
    }

    @Override
    public ContactPageList getPersonalContactsByAddressBook(String ownerId, String addressBookId) throws Exception {
        return this.storage_.findPersonalContactsByAddressBook(ownerId, addressBookId);
    }

    @Override
    public ContactPageList getPersonalContactsByFilter(String username, ContactFilter filter) throws Exception {
        return this.storage_.findContactsByFilter(username, filter, JCRDataStorage.PERSONAL);
    }

    @Override
    public ContactPageList getSharedContactsByFilter(String username, ContactFilter filter) throws Exception {
        return this.storage_.findContactsByFilter(username, filter, JCRDataStorage.SHARED);
    }

    @Override
    public ContactPageList getPublicContactsByFilter(String username, ContactFilter filter) throws Exception {
        return this.storage_.findContactsByFilter(username, filter, JCRDataStorage.PUBLIC);
    }

    @Override
    public List<String> getEmailsByAddressBook(String username, String addressBookId) throws Exception {
        return this.storage_.findEmailsInPersonalAddressBook(username, addressBookId);
    }

    @Override
    public Contact getContact(String username, String contactId) throws Exception {
        return this.storage_.loadPersonalContact(username, contactId);
    }

    @Override
    public void saveContact(String username, Contact contact, boolean isNew) throws Exception {
        this.storage_.saveContact(username, contact, isNew);
    }

    @Override
    public List<Contact> removeContacts(String username, List<String> contactIds) throws Exception {
        return this.storage_.removeContacts(username, contactIds);
    }

    @Override
    public void moveContacts(SessionProvider sysProvider, String username, List<Contact> contacts, String addressType) throws Exception {
        this.moveContacts(username, contacts, addressType);
    }

    @Override
    public void moveContacts(String username, List<Contact> contacts, String addressType) throws Exception {
        this.storage_.moveContacts(username, contacts, addressType);
    }

    @Override
    public void addUserContactInAddressBook(String userId, String addressBookId) throws Exception {
        this.storage_.addUserContactInAddressBook(userId, addressBookId);
    }

    @Override
    public List<AddressBook> getGroups(SessionProvider sProvider, String username) throws Exception {
        return this.getGroups(username);
    }

    @Override
    public List<AddressBook> getGroups(String username) throws Exception {
        return this.storage_.findPersonalAddressBooksByOwner(username);
    }

    @Override
    public AddressBook getPersonalAddressBook(String username, String addressBookId) throws Exception {
        return this.storage_.loadPersonalAddressBook(username, addressBookId);
    }

    @Override
    public void saveAddressBook(String username, AddressBook group, boolean isNew) throws Exception {
        this.storage_.savePersonalOrSharedAddressBook(username, group, isNew);
    }

    @Override
    public AddressBook removeAddressBook(String username, String addressBookId) throws Exception {
        this.storage_.clearAddressBook(username, addressBookId);
        AddressBook removed = this.storage_.removePersonalAddressBook(username, addressBookId);
        return removed;
    }

    @Override
    public void removeUserShareContact(SessionProvider sProvider, String username, String contactId, String removedUser) throws Exception {
        this.removeUserShareContact(username, contactId, removedUser);
    }

    @Override
    public void removeUserShareContact(String username, String contactId, String removedUser) throws Exception {
        this.storage_.removeUserShareContact(username, contactId, removedUser);
    }

    @Override
    public void shareContact(SessionProvider sProvider, String username, String[] contactIds, List<String> receiveUsers) throws Exception {
        this.shareContact(username, contactIds, receiveUsers);
    }

    @Override
    public void shareContact(String username, String[] contactIds, List<String> receiveUsers) throws Exception {
        this.storage_.shareContact(username, contactIds, receiveUsers);
    }

    @Override
    public DataPageList getSharedContacts(String username) throws Exception {
        return this.storage_.getSharedContacts(username);
    }

    @Override
    public void shareAddressBook(String username, String addressBookId, List<String> receiverUsers) throws Exception {
        this.storage_.shareAddressBook(username, addressBookId, receiverUsers);
    }

    @Override
    public void unshareAddressBook(String owner, String addressBookId, String unsharedUser) throws Exception {
        this.storage_.unshareAddressBook(owner, addressBookId, unsharedUser);
    }

    @Override
    public List<SharedAddressBook> getSharedAddressBooks(String username) throws Exception {
        return this.storage_.findSharedAddressBooksByUser(username);
    }

    @Override
    public ContactPageList getSharedContactsByAddressBook(SessionProvider sProvider, String username, SharedAddressBook addressBook) throws Exception {
        return this.getSharedContactsByAddressBook(username, addressBook);
    }

    @Override
    public ContactPageList getSharedContactsByAddressBook(String username, SharedAddressBook addressBook) throws Exception {
        return this.storage_.getSharedContactsByAddressBook(username, addressBook);
    }

    @Override
    public void removeSharedContact(SessionProvider sProvider, String username, String addressBookId, String contactId) throws Exception {
        this.removeSharedContact(username, addressBookId, contactId);
    }

    @Override
    public void removeSharedContact(String username, String addressBookId, String contactId) throws Exception {
        this.storage_.removeSharedContact(username, addressBookId, contactId);
    }

    @Override
    public void saveContactToSharedAddressBook(String username, String addressBookId, Contact contact, boolean isNew) throws Exception {
        this.storage_.saveContactToSharedAddressBook(username, addressBookId, contact, isNew);
    }

    @Override
    public Contact getSharedContactAddressBook(String username, String contactId) throws Exception {
        return this.storage_.getSharedContactAddressBook(username, contactId);
    }

    @Override
    public void saveSharedContact(String username, Contact contact) throws Exception {
        this.storage_.saveSharedContact(username, contact);
    }

    @Override
    public Contact getSharedContact(SessionProvider sProvider, String username, String contactId) throws Exception {
        return this.getSharedContact(username, contactId);
    }

    @Override
    public Contact getSharedContact(String username, String contactId) throws Exception {
        return this.storage_.getSharedContact(username, contactId);
    }

    @Override
    public Contact getPublicContact(String contactId) throws Exception {
        return this.storage_.loadPublicContactByUser(contactId);
    }

    public List<GroupContactData> getPublicContacts(SessionProvider sProvider, String[] groupIds) throws Exception {
        return this.storage_.getPublicContacts(sProvider, groupIds);
    }

    @Override
    public Tag getTag(SessionProvider sProvider, String username, String tagName) throws Exception {
        return this.getTag(username, tagName);
    }

    @Override
    public Tag getTag(String username, String tagName) throws Exception {
        return this.storage_.getTag(username, tagName);
    }

    @Override
    public List<Tag> getTags(SessionProvider sProvider, String username) throws Exception {
        return this.getTags(username);
    }

    @Override
    public List<Tag> getTags(String username) throws Exception {
        return this.storage_.getTags(username);
    }

    @Override
    public DataPageList getContactPageListByTag(SessionProvider sProvider, String username, String tagName) throws Exception {
        return this.getContactPageListByTag(username, tagName);
    }

    @Override
    public DataPageList getContactPageListByTag(String username, String tagName) throws Exception {
        return this.storage_.getContactPageListByTag(username, tagName);
    }

    @Override
    public void addTag(SessionProvider sProvider, String username, List<String> contactIds, List<Tag> tags) throws Exception {
        this.addTag(username, contactIds, tags);
    }

    @Override
    public void addTag(String username, List<String> contactIds, List<Tag> tags) throws Exception {
        this.storage_.addTag(username, contactIds, tags);
    }

    public void addTag(SessionProvider sProvider, String username, List<String> contactIds, String tagId) throws Exception {
        this.addTag(username, contactIds, tagId);
    }

    @Override
    public void addTag(String username, List<String> contactIds, String tagId) throws Exception {
        this.storage_.addTag(username, contactIds, tagId);
    }

    @Override
    public Tag removeTag(SessionProvider sProvider, String username, String tagName) throws Exception {
        return this.removeTag(username, tagName);
    }

    @Override
    public Tag removeTag(String username, String tagName) throws Exception {
        return this.storage_.removeTag(username, tagName);
    }

    @Override
    public void updateTag(SessionProvider sProvider, String username, Tag tag) throws Exception {
        this.updateTag(username, tag);
    }

    @Override
    public void updateTag(String username, Tag tag) throws Exception {
        this.storage_.updateTag(username, tag);
    }

    @Override
    public void removeContactTag(SessionProvider sProvider, String username, List<String> contactIds, List<String> tags) throws Exception {
        this.removeContactTag(username, contactIds, tags);
    }

    @Override
    public void removeContactTag(String username, List<String> contactIds, List<String> tags) throws Exception {
        this.storage_.removeContactTag(username, contactIds, tags);
    }

    @Override
    public ContactPageList getPublicContactsByAddressBook(SessionProvider sProvider, String groupId) throws Exception {
        return this.getPublicContactsByAddressBook(groupId);
    }

    @Override
    public ContactPageList getPublicContactsByAddressBook(String groupId) throws Exception {
        return this.storage_.getPublicContactsByAddressBook(groupId);
    }

    @Override
    public void pasteAddressBook(SessionProvider sProvider, String username, String srcAddress, String srcType, String destAddress, String destType) throws Exception {
        this.pasteAddressBook(username, srcAddress, srcType, destAddress, destType);
    }

    @Override
    public void pasteAddressBook(String username, String srcAddress, String srcType, String destAddress, String destType) throws Exception {
        this.storage_.pasteAddressBook(username, srcAddress, srcType, destAddress, destType);
    }

    @Override
    public List<Contact> pasteContacts(SessionProvider sProvider, String username, String destAddress, String destType, Map<String, String> contactsMap) throws Exception {
        return this.pasteContacts(username, destAddress, destType, contactsMap);
    }

    @Override
    public List<Contact> pasteContacts(String username, String destAddress, String destType, Map<String, String> contactsMap) throws Exception {
        return this.storage_.pasteContacts(username, destAddress, destType, contactsMap);
    }

    @Override
    public ContactImportExport getContactImportExports(String type) {
        return this.contactImportExport_.get(type);
    }

    @Override
    public String[] getImportExportType() throws Exception {
        return this.contactImportExport_.keySet().toArray(new String[0]);
    }

    @Override
    public DataPageList searchContact(SessionProvider sProvider, String username, ContactFilter filter) throws Exception {
        return this.searchContact(username, filter);
    }

    @Override
    public DataPageList searchContact(String username, ContactFilter filter) throws Exception {
        return this.storage_.searchContact(username, filter);
    }

    @Override
    public AddressBook getSharedAddressBook(String username, String addressBookId) throws Exception {
        return this.storage_.getSharedAddressBookById(username, addressBookId);
    }

    @Override
    public List<String> getAllEmailBySharedGroup(String username, String addressBookId) throws Exception {
        return this.storage_.getAllEmailBySharedGroup(username, addressBookId);
    }

    @Override
    public List<String> getAllEmailByPublicGroup(String username, String groupId) throws Exception {
        return this.storage_.findEmailsInPublicAddressBook(username, groupId);
    }

    @Override
    public void registerNewUser(User user, boolean isNew) throws Exception {
        this.storage_.registerNewUser(user, isNew);
    }

    @Override
    public ContactPageList getContactPageListByGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        return this.getPersonalContactsByAddressBook(username, groupId);
    }

    @Override
    public void saveGroup(SessionProvider sProvider, String username, AddressBook group, boolean isNew) throws Exception {
        this.saveAddressBook(username, group, isNew);
    }

    @Override
    public AddressBook getGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        return this.getPersonalAddressBook(username, groupId);
    }

    @Override
    public AddressBook removeGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        return this.removeAddressBook(username, groupId);
    }

    @Override
    public AddressBook getSharedGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        return this.getSharedAddressBook(username, groupId);
    }

    @Override
    public List<SharedAddressBook> getSharedAddressBooks(SessionProvider sProvider, String username) throws Exception {
        return this.getSharedAddressBooks(username);
    }

    @Override
    public void removeUserShareAddressBook(SessionProvider sProvider, String username, String addressBookId, String removedUser) throws Exception {
        this.unshareAddressBook(username, addressBookId, removedUser);
    }

    @Override
    public void saveContact(SessionProvider sProvider, String username, Contact contact, boolean isNew) throws Exception {
        this.storage_.saveContact(username, contact, isNew);
    }

    @Override
    public List<Contact> getAllContacts(SessionProvider sProvider, String username) throws Exception {
        return this.getPersonalContacts(username);
    }

    @Override
    public List<String> getAllEmailAddressByGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        return this.getEmailsByAddressBook(username, groupId);
    }

    @Override
    public void addGroupToPersonalContact(String userId, String groupId) throws Exception {
        this.addUserContactInAddressBook(userId, groupId);
    }

    @Override
    public Contact getPersonalContact(String userId) throws Exception {
        return this.getPublicContact(userId);
    }

    @Override
    public Map<String, String> searchEmails(SessionProvider sessionProvider, String username, ContactFilter filter) throws Exception {
        return this.searchEmails(username, filter);
    }

    @Override
    public ContactPageList getContactPageListByGroup(SessionProvider sProvider, String username, ContactFilter filter, String type) throws Exception {
        return this.storage_.findContactsByFilter(username, filter, type);
    }

    @Override
    public List<Contact> removeContacts(SessionProvider sProvider, String username, List<String> contactIds) throws Exception {
        return this.removeContacts(username, contactIds);
    }

    @Override
    public void saveAddress(String username, String emailAddress) throws Exception {
        this.storage_.saveAddress(username, emailAddress);
    }
}

