/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.basicimpl.GenericExtension;
import net.wimpi.pim.contact.basicimpl.SimpleExtension;
import net.wimpi.pim.contact.io.ContactMarshaller;
import net.wimpi.pim.contact.io.ContactUnmarshaller;
import net.wimpi.pim.contact.io.vcard.GenericExtensionItemHandler;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.io.vcard.ItemHandlerManager;
import net.wimpi.pim.contact.model.Address;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.EmailAddress;
import net.wimpi.pim.contact.model.Extension;
import net.wimpi.pim.contact.model.Extensions;
import net.wimpi.pim.contact.model.Image;
import net.wimpi.pim.contact.model.Organization;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.contact.model.PhoneNumber;
import net.wimpi.pim.factory.ContactIOFactory;
import net.wimpi.pim.factory.ContactModelFactory;
import net.wimpi.pim.util.versitio.versitException;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactAttachment;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactImportExport;
import org.exoplatform.contact.service.ContactPageList;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardImportExport
implements ContactImportExport {
    private static String eXoGender = "EXO-GENDER";
    private static String eXoExoId = "EXO-EXOID";
    private static String eXoAolId = "EXO-AOLID";
    private static String eXoGoogleId = "EXO-GOOGLEID";
    private static String eXoIcqId = "EXO-ICQID";
    private static String eXoIcrId = "EXO-ICRID";
    private static String eXoSkypeId = "EXO-SKYPEID";
    private static String eXoMsnId = "EXO-MSNID";
    private static String eXoYahooId = "EXO-YAHOOID";
    private static int maxLength = 150;
    private static String ENCODING = "UTF-8";
    private DataStorage storage_;

    public VCardImportExport(DataStorage storage) throws Exception {
        this.storage_ = storage;
    }

    @Override
    public OutputStream exportContact(String username, String[] addressBookIds) throws Exception {
        ContactFilter filter;
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        ArrayList<String> privateAddress = new ArrayList<String>();
        ArrayList<String> publicAddress = new ArrayList<String>();
        for (String address : addressBookIds) {
            Node contactGroupHome = this.storage_.getPersonalAddressBooksHome(username);
            Node publicContactGroupHome = this.storage_.getPublicContactsHome();
            try {
                if (contactGroupHome.hasNode(address)) {
                    privateAddress.add(address);
                    continue;
                }
                if (publicContactGroupHome.hasNode(address)) {
                    publicAddress.add(address);
                    continue;
                }
                String[] array = address.split(DataStorage.HYPHEN);
                if (array.length != 2) continue;
                ContactPageList pageList = this.storage_.getSharedContactsByAddressBook(username, new SharedAddressBook(null, array[0], array[1]));
                if (pageList.getAvailable() + (long)contactList.size() > (long)Utils.limitExport) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                contactList.addAll(pageList.getAll());
            }
            catch (RepositoryException re) {
                publicAddress.add(address);
            }
        }
        if (privateAddress.size() > 0) {
            filter = new ContactFilter();
            filter.setCategories(privateAddress.toArray(new String[0]));
            ContactPageList pageList = this.storage_.findContactsByFilter(username, filter, DataStorage.PERSONAL);
            if (pageList.getAvailable() + (long)contactList.size() >= (long)Utils.limitExport) {
                throw new ArrayIndexOutOfBoundsException();
            }
            contactList.addAll(pageList.getAll());
        }
        if (publicAddress.size() > 0) {
            filter = new ContactFilter();
            filter.setCategories(publicAddress.toArray(new String[0]));
            ContactPageList pageList = this.storage_.findContactsByFilter(username, filter, DataStorage.PUBLIC);
            if (pageList.getAvailable() + (long)contactList.size() >= (long)Utils.limitExport) {
                throw new ArrayIndexOutOfBoundsException();
            }
            contactList.addAll(pageList.getAll());
        }
        if (contactList.size() > 0) {
            return this.exportContact(username, contactList);
        }
        return null;
    }

    @Override
    public OutputStream exportContact(String username, List<Contact> contacts) throws Exception {
        ContactIOFactory ciof = Pim.getContactIOFactory();
        ContactModelFactory cmf = Pim.getContactModelFactory();
        ContactMarshaller marshaller = ciof.createContactMarshaller();
        marshaller.setEncoding(ENCODING);
        net.wimpi.pim.contact.model.Contact[] pimContacts = new net.wimpi.pim.contact.model.Contact[contacts.size()];
        int i = 0;
        for (Contact contact : contacts) {
            InputStream is;
            pimContacts[i] = cmf.createContact();
            PersonalIdentity pid = cmf.createPersonalIdentity();
            pid.setFormattedName(this.nullToEmptyString(contact.getFullName()));
            pid.setFirstname(this.nullToEmptyString(contact.getFirstName()).replaceAll(";", "_"));
            pid.setLastname(this.nullToEmptyString(contact.getLastName()).replaceAll(";", "_"));
            String firstName = contact.getFirstName();
            if (firstName != null && !firstName.equals("")) {
                StringTokenizer tokens = new StringTokenizer(firstName, ",", false);
                while (tokens.hasMoreTokens()) {
                    pid.addAdditionalName(tokens.nextToken().trim().replaceAll(";", "_"));
                }
            } else {
                pid.addAdditionalName("");
            }
            String nickName = contact.getNickName();
            if (nickName != null && !nickName.equals("")) {
                StringTokenizer tokens = new StringTokenizer(nickName, ",", false);
                while (tokens.hasMoreTokens()) {
                    pid.addNickname(tokens.nextToken().trim());
                }
            } else {
                pid.addNickname("");
            }
            pid.setBirthDate(contact.getBirthday());
            Image photo = cmf.createImage();
            ContactAttachment attachment = contact.getAttachment();
            if (attachment != null && (is = attachment.getInputStream()) != null) {
                byte[] data = new byte[is.available()];
                is.read(data);
                photo.setContentType(attachment.getMimeType());
                photo.setData(data);
                pid.setPhoto(photo);
            }
            pimContacts[i].setPersonalIdentity(pid);
            Address addr = cmf.createAddress();
            addr.setHome(true);
            addr.setStreet(contact.getHomeAddress());
            addr.setCity(contact.getHomeCity());
            addr.setPostalCode(contact.getHomePostalCode());
            addr.setRegion(contact.getHomeState_province());
            addr.setCountry(contact.getHomeCountry());
            pimContacts[i].addAddress(addr);
            addr = cmf.createAddress();
            addr.setWork(true);
            addr.setStreet(contact.getWorkAddress());
            addr.setCity(contact.getWorkCity());
            addr.setPostalCode(contact.getWorkPostalCode());
            addr.setRegion(contact.getWorkStateProvince());
            addr.setCountry(contact.getWorkCountry());
            pimContacts[i].addAddress(addr);
            Communications comm = cmf.createCommunications();
            pimContacts[i].setCommunications(comm);
            String strEmail = Utils.listToString(contact.getEmailAddresses());
            if (strEmail != null) {
                StringTokenizer tokens = new StringTokenizer(strEmail, ";", false);
                while (tokens.hasMoreTokens()) {
                    EmailAddress email = cmf.createEmailAddress();
                    email.setAddress(tokens.nextToken().trim());
                    comm.addEmailAddress(email);
                }
            }
            this.addPhoneNumber(cmf, comm, contact.getMobilePhone(), false, false, true);
            this.addPhoneNumber(cmf, comm, contact.getHomePhone1(), true, false, false);
            this.addPhoneNumber(cmf, comm, contact.getHomePhone2(), true, false, false);
            this.addPhoneNumber(cmf, comm, contact.getWorkPhone1(), false, false, false);
            this.addPhoneNumber(cmf, comm, contact.getWorkPhone2(), false, false, false);
            this.addPhoneNumber(cmf, comm, contact.getHomeFax(), true, true, false);
            this.addPhoneNumber(cmf, comm, contact.getWorkFax(), false, true, false);
            OrganizationalIdentity orgid = cmf.createOrganizationalIdentity();
            orgid.setTitle(this.nullToEmptyString(contact.getJobTitle()));
            Organization org = cmf.createOrganization();
            org.setURL(contact.getWebPage());
            orgid.setOrganization(org);
            pimContacts[i].setOrganizationalIdentity(orgid);
            Extensions extensions = cmf.createExtensions();
            String gender = contact.getGender();
            if (gender == null || gender.equalsIgnoreCase("gender")) {
                gender = "";
            }
            this.addExtension(extensions, eXoGender, gender);
            this.addExtension(extensions, eXoExoId, this.nullToEmptyString(contact.getExoId()));
            this.addExtension(extensions, eXoAolId, this.nullToEmptyString(contact.getAolId()));
            this.addExtension(extensions, eXoGoogleId, this.nullToEmptyString(contact.getGoogleId()));
            this.addExtension(extensions, eXoIcqId, this.nullToEmptyString(contact.getIcqId()));
            this.addExtension(extensions, eXoIcrId, this.nullToEmptyString(contact.getIcrId()));
            this.addExtension(extensions, eXoSkypeId, this.nullToEmptyString(contact.getSkypeId()));
            this.addExtension(extensions, eXoMsnId, this.nullToEmptyString(contact.getMsnId()));
            this.addExtension(extensions, eXoYahooId, this.nullToEmptyString(contact.getYahooId()));
            pimContacts[i].setExtensions(extensions);
            pimContacts[i].setURL(contact.getPersonalSite());
            pimContacts[i].setNote(contact.getNote());
            pimContacts[i].setCurrentRevisionDate(contact.getLastUpdated());
            ++i;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        marshaller.marshallContacts((OutputStream)out, pimContacts);
        return out;
    }

    @Override
    public void importContact(String username, InputStream input, String groupId) throws Exception {
        ContactIOFactory ciof = Pim.getContactIOFactory();
        ContactUnmarshaller unmarshaller = ciof.createContactUnmarshaller();
        this.addExtensionHandler(eXoGender);
        this.addExtensionHandler(eXoExoId);
        this.addExtensionHandler(eXoAolId);
        this.addExtensionHandler(eXoGoogleId);
        this.addExtensionHandler(eXoIcqId);
        this.addExtensionHandler(eXoIcrId);
        this.addExtensionHandler(eXoSkypeId);
        this.addExtensionHandler(eXoMsnId);
        this.addExtensionHandler(eXoYahooId);
        unmarshaller.setStrict(false);
        unmarshaller.setEncoding(ENCODING);
        net.wimpi.pim.contact.model.Contact[] pimContacts = unmarshaller.unmarshallContacts(input);
        if (pimContacts == null || pimContacts.length == 0) {
            throw new Exception();
        }
        if (pimContacts.length > Utils.limitExport) {
            throw new IndexOutOfBoundsException();
        }
        Reminder re = new Reminder();
        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
        re.setSummary("Importing..");
        re.setDescription("Imported");
        re.setReminderOwner(username);
        re.setReminderType(Reminder.TYPE_POPUP);
        re.setFromDateTime(new Date());
        for (int index = 0; index < pimContacts.length; ++index) {
            Date revisionDate;
            Extensions extensions;
            OrganizationalIdentity orgid;
            InputStream is;
            int indexComma;
            Contact contact = new Contact();
            PersonalIdentity identity = pimContacts[index].getPersonalIdentity();
            String additionName = null;
            try {
                additionName = identity.getAdditionalName(0);
            }
            catch (IndexOutOfBoundsException e) {
                additionName = "";
            }
            String fullName = this.nullToEmptyString(identity.getFormattedName());
            contact.setFullName(fullName);
            String lastName = identity.getLastname();
            String firstName = identity.getFirstname();
            if (fullName == null || fullName.length() == 0) {
                fullName = firstName + " " + lastName;
                contact.setFullName(fullName);
            }
            if ((indexComma = fullName.indexOf(";")) >= 0) {
                int indexSpace = fullName.indexOf(" ");
                firstName = fullName.substring(0, indexSpace).trim();
                contact.setFirstName(firstName);
                lastName = fullName.substring(indexSpace, fullName.length()).trim();
            } else if (firstName != null && firstName.length() > 0) {
                if (firstName.trim().equals(additionName.trim())) {
                    contact.setFirstName(firstName);
                } else {
                    contact.setFirstName(firstName + " " + additionName);
                }
            }
            contact.setLastName(lastName);
            int size = identity.getAdditionalNameCount();
            String nickName = "";
            size = identity.getNicknameCount();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    nickName = nickName + ", ";
                }
                nickName = identity.getNickname(i);
            }
            contact.setNickName(nickName);
            contact.setBirthday(identity.getBirthDate());
            ContactAttachment attachment = new ContactAttachment();
            Image photo = identity.getPhoto();
            if (photo != null && (is = photo.getInputStream()) != null) {
                attachment.setInputStream(is);
                String filename = lastName;
                if (filename == null || filename.equals("")) {
                    filename = firstName;
                }
                attachment.setFileName(filename + ".photo");
                attachment.setMimeType(photo.getContentType());
                contact.setAttachment(attachment);
            }
            if ((orgid = pimContacts[index].getOrganizationalIdentity()) != null) {
                contact.setJobTitle(orgid.getTitle());
            }
            Iterator iters = pimContacts[index].getAddresses();
            while (iters.hasNext()) {
                Address addr = (Address)iters.next();
                if (addr.isHome()) {
                    contact.setHomeAddress(addr.getStreet());
                    contact.setHomeCity(addr.getCity());
                    contact.setHomeState_province(addr.getRegion());
                    contact.setHomePostalCode(addr.getPostalCode());
                    contact.setHomeCountry(addr.getCountry());
                    continue;
                }
                if (!addr.isWork()) continue;
                contact.setWorkAddress(addr.getStreet());
                contact.setWorkCity(addr.getCity());
                contact.setWorkStateProvince(addr.getRegion());
                contact.setWorkPostalCode(addr.getPostalCode());
                contact.setWorkCountry(addr.getCountry());
            }
            String mobilePhone = null;
            String homePhone1 = null;
            String homePhone2 = null;
            String homeFax = null;
            String workPhone1 = null;
            String workPhone2 = null;
            String workFax = null;
            Communications communication = pimContacts[index].getCommunications();
            if (communication != null) {
                PhoneNumber phone;
                Iterator iters2 = communication.getPhoneNumbers();
                while (iters2.hasNext()) {
                    phone = (PhoneNumber)iters2.next();
                    if (phone.isHome() && phone.isFax()) {
                        homeFax = phone.getNumber();
                        continue;
                    }
                    if (phone.isHome() && phone.isVoice()) {
                        if (homePhone1 == null) {
                            homePhone1 = phone.getNumber();
                            continue;
                        }
                        if (homePhone2 != null) continue;
                        homePhone2 = phone.getNumber();
                        continue;
                    }
                    if (phone.isWork() && phone.isFax()) {
                        workFax = phone.getNumber();
                        continue;
                    }
                    if (phone.isWork() && phone.isVoice()) {
                        if (workPhone1 == null) {
                            workPhone1 = phone.getNumber();
                            continue;
                        }
                        if (workPhone2 != null) continue;
                        workPhone2 = phone.getNumber();
                        continue;
                    }
                    if (phone.isCellular()) {
                        mobilePhone = phone.getNumber();
                        continue;
                    }
                    if (!phone.isHome()) continue;
                    if (homePhone1 == null) {
                        homePhone1 = phone.getNumber();
                        continue;
                    }
                    if (homePhone2 != null) continue;
                    homePhone2 = phone.getNumber();
                }
                iters2 = communication.getPhoneNumbers();
                while (iters2.hasNext()) {
                    phone = (PhoneNumber)iters2.next();
                    if (phone.isHome() || phone.isWork() || phone.isCellular()) continue;
                    if (homePhone1 == null) {
                        homePhone1 = phone.getNumber();
                        continue;
                    }
                    if (homePhone2 == null) {
                        homePhone2 = phone.getNumber();
                        continue;
                    }
                    if (workPhone1 == null) {
                        workPhone1 = phone.getNumber();
                        continue;
                    }
                    if (workPhone2 != null) continue;
                    workPhone2 = phone.getNumber();
                }
                String emailAddress = "";
                Iterator iters3 = communication.getEmailAddresses();
                while (iters3.hasNext()) {
                    EmailAddress email = (EmailAddress)iters3.next();
                    if (!emailAddress.equals("")) {
                        emailAddress = emailAddress + "; ";
                    }
                    emailAddress = emailAddress + email.getAddress();
                }
                contact.setEmailAddress(emailAddress);
            }
            if (mobilePhone != null) {
                contact.setMobilePhone(mobilePhone);
            }
            if (homePhone1 != null) {
                contact.setHomePhone1(homePhone1);
                if (homePhone2 != null) {
                    contact.setHomePhone2(homePhone2);
                }
            }
            if (homeFax != null) {
                contact.setHomeFax(homeFax);
            }
            if (workPhone1 != null) {
                contact.setWorkPhone1(workPhone1);
                if (workPhone2 != null) {
                    contact.setWorkPhone2(workPhone2);
                }
            }
            if (workFax != null) {
                contact.setWorkFax(workFax);
            }
            contact.setPersonalSite(pimContacts[index].getURL());
            if (pimContacts[index].getOrganizationalIdentity() != null && pimContacts[index].getOrganizationalIdentity().getOrganization() != null) {
                contact.setWebPage(pimContacts[index].getOrganizationalIdentity().getOrganization().getURL());
            }
            if ((extensions = pimContacts[index].getExtensions()) != null) {
                SimpleExtension ext = (SimpleExtension)extensions.get(eXoGender);
                if (ext != null) {
                    contact.setGender(ext.getValue());
                }
                if ((ext = (SimpleExtension)extensions.get(eXoExoId)) != null) {
                    contact.setExoId(ext.getValue());
                }
                if ((ext = (SimpleExtension)extensions.get(eXoAolId)) != null) {
                    contact.setAolId(ext.getValue());
                }
                if ((ext = (SimpleExtension)extensions.get(eXoGoogleId)) != null) {
                    contact.setGoogleId(ext.getValue());
                }
                if ((ext = (SimpleExtension)extensions.get(eXoIcqId)) != null) {
                    contact.setIcqId(ext.getValue());
                }
                if ((ext = (SimpleExtension)extensions.get(eXoIcrId)) != null) {
                    contact.setIcrId(ext.getValue());
                }
                if ((ext = (SimpleExtension)extensions.get(eXoSkypeId)) != null) {
                    contact.setSkypeId(ext.getValue());
                }
                if ((ext = (SimpleExtension)extensions.get(eXoMsnId)) != null) {
                    contact.setMsnId(ext.getValue());
                }
                if ((ext = (SimpleExtension)extensions.get(eXoYahooId)) != null) {
                    contact.setYahooId(ext.getValue());
                }
            }
            if (pimContacts[index].getNote() != null) {
                contact.setNote(pimContacts[index].getNote().replaceAll("\\\\n", "\n"));
            }
            if ((revisionDate = pimContacts[index].getCurrentRevisionDate()) != null) {
                contact.setLastUpdated(revisionDate);
            }
            if (groupId.contains(DataStorage.HYPHEN)) {
                String newGroupId = groupId.replace(DataStorage.HYPHEN, "");
                contact.setAddressBookIds(new String[]{newGroupId});
                this.storage_.saveContactToSharedAddressBook(username, newGroupId, contact, true);
            } else {
                contact.setAddressBookIds(new String[]{groupId});
                this.storage_.saveContact(username, contact, true);
            }
            re.setSummary(String.valueOf(index + 1) + " contacts imported ...");
            JsonValue json = generatorImpl.createJsonObject((Object)re);
            ContinuationService continuation = this.getContinuationService();
            continuation.sendMessage(username, "/eXo/Application/Contact/messages", (Object)json, re.toString());
        }
    }

    protected ContinuationService getContinuationService() {
        ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    private void addPhoneNumber(ContactModelFactory cmf, Communications comm, String number, boolean isHome, boolean isFax, boolean isCellular) {
        if (number != null && !number.equals("")) {
            PhoneNumber phone = cmf.createPhoneNumber();
            phone.setNumber(number);
            if (isCellular) {
                phone.setCellular(true);
            } else {
                if (isHome) {
                    phone.setHome(true);
                } else {
                    phone.setWork(true);
                }
                if (isFax) {
                    phone.setFax(true);
                } else {
                    phone.setVoice(true);
                }
            }
            comm.addPhoneNumber(phone);
        }
    }

    private void addExtension(Extensions extensions, String eXoKey, String eXoValue) throws versitException {
        SimpleExtension ext = new SimpleExtension(eXoKey);
        ext.addValue(eXoValue);
        extensions.add((Extension)ext);
        if (!ItemHandlerManager.getReference().hasHandler(ext.getIdentifier())) {
            ItemHandlerManager.getReference().addExtensionHandler(ext.getIdentifier(), (ItemHandler)new GenericExtensionItemHandler((GenericExtension)ext));
        }
    }

    private void addExtensionHandler(String eXoKey) throws versitException {
        SimpleExtension ext = new SimpleExtension(eXoKey);
        if (!ItemHandlerManager.getReference().hasHandler(ext.getIdentifier())) {
            ItemHandlerManager.getReference().addExtensionHandler(ext.getIdentifier(), (ItemHandler)new GenericExtensionItemHandler((GenericExtension)ext));
        }
    }

    private String nullToEmptyString(String s) {
        if (s == null) {
            s = "";
        }
        return s;
    }
}

