/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactImportExport;
import org.exoplatform.contact.service.ContactPageList;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Tag;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.contact.service.impl.ContactEventListener;
import org.exoplatform.contact.service.impl.JCRDataStorage;
import org.exoplatform.contact.service.impl.VCardImportExport;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactServiceImpl
implements ContactService {
    private static final String VCARD = "x-vcard".intern();
    private DataStorage storage_;
    private Map<String, ContactImportExport> contactImportExport_ = new HashMap<String, ContactImportExport>();
    public boolean userCanSeeAllGroupAddressBooks = false;
    public List<String> nonPublicGroups = new ArrayList<String>();
    private static final String USERCANSEEALLGROUPADDRESSBOOKS = "UserCanSeeAllGroupAddressBooks".intern();
    private static final String NONPUBLICGROUPS = "NonPublicGroups".intern();
    private static final String TRUE = "true".intern();
    private List<ContactEventListener> listeners_ = new ArrayList<ContactEventListener>(3);

    public ContactServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService rservice, InitParams initParams) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator, rservice);
        this.contactImportExport_.put(VCARD, new VCardImportExport(this.storage_));
        if (initParams != null) {
            ArrayList values;
            if (initParams.getValuesParam(USERCANSEEALLGROUPADDRESSBOOKS) != null && TRUE.equalsIgnoreCase((values = initParams.getValuesParam(USERCANSEEALLGROUPADDRESSBOOKS).getValues()).get(0).toString())) {
                this.userCanSeeAllGroupAddressBooks = true;
            }
            if (initParams.getValuesParam(NONPUBLICGROUPS) != null) {
                values = initParams.getValuesParam(NONPUBLICGROUPS).getValues();
                for (Object object : values) {
                    this.nonPublicGroups.add(object.toString());
                }
            }
        }
    }

    private List<String> excludeWildCardMatchs(List<String> sourceList, List<String> wildCards) throws Exception {
        ArrayList<String> groupIds = new ArrayList<String>();
        if (sourceList != null && !sourceList.isEmpty()) {
            for (String object : sourceList) {
                groupIds.add(object);
            }
        }
        if (wildCards == null || wildCards.isEmpty() || sourceList == null || sourceList.isEmpty()) {
            return groupIds;
        }
        for (String wildCard : wildCards) {
            for (String s : sourceList) {
                if (!FilenameUtils.wildcardMatch((String)s, (String)wildCard, (IOCase)IOCase.INSENSITIVE)) continue;
                groupIds.remove(s);
            }
        }
        return groupIds;
    }

    @Override
    public List<String> getPublicAddressBookIdsOfUser(String user) throws Exception {
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        Object[] objGroupIds = organizationService.getGroupHandler().findGroupsOfUser(user).toArray();
        List<String> groupIds = new ArrayList<String>();
        for (Object object : objGroupIds) {
            groupIds.add(((Group)object).getId());
        }
        groupIds = this.excludeWildCardMatchs(groupIds, this.nonPublicGroups);
        return groupIds;
    }

    @Override
    public List<String> getAllsPublicAddressBookIds(String user) throws Exception {
        List<Object> publicGroupIds = new ArrayList();
        publicGroupIds = this.userCanSeeAllGroupAddressBooks ? this.storage_.getPublicAddresses(user) : this.getPublicAddressBookIdsOfUser(user);
        publicGroupIds = this.excludeWildCardMatchs(publicGroupIds, this.nonPublicGroups);
        return publicGroupIds;
    }

    @Override
    public List<Contact> getPersonalContacts(String username) throws Exception {
        return this.storage_.findAllContactsByOwner(username);
    }

    @Override
    public Map<String, String> searchEmails(String username, ContactFilter filter) throws Exception {
        return this.storage_.findEmailsByFilter(username, filter);
    }

    @Override
    public List<String> searchEmailsByFilter(String username, ContactFilter filter) throws Exception {
        return this.storage_.searchEmailsByFilter(username, filter);
    }

    @Override
    public ContactPageList getPersonalContactsByAddressBook(String ownerId, String addressBookId) throws Exception {
        return this.storage_.findPersonalContactsByAddressBook(ownerId, addressBookId);
    }

    @Override
    public ContactPageList getPersonalContactsByFilter(String username, ContactFilter filter) throws Exception {
        return this.storage_.findContactsByFilter(username, filter, DataStorage.PERSONAL);
    }

    @Override
    public ContactPageList getSharedContactsByFilter(String username, ContactFilter filter) throws Exception {
        return this.storage_.findContactsByFilter(username, filter, DataStorage.SHARED);
    }

    @Override
    public ContactPageList getPublicContactsByFilter(String username, ContactFilter filter) throws Exception {
        return this.storage_.findContactsByFilter(username, filter, DataStorage.PUBLIC);
    }

    @Override
    public List<String> getEmailsByAddressBook(String username, String addressBookId) throws Exception {
        return this.storage_.findEmailsInPersonalAddressBook(username, addressBookId);
    }

    @Override
    public Contact getContact(String username, String contactId) throws Exception {
        return this.storage_.loadPersonalContact(username, contactId);
    }

    @Override
    public void saveContact(String username, Contact contact, boolean isNew) throws Exception {
        this.storage_.saveContact(username, contact, isNew);
        for (ContactEventListener ce : this.listeners_) {
            if (isNew) {
                ce.saveContact(username, contact);
                continue;
            }
            ce.updateContact(username, contact);
        }
    }

    @Override
    public List<Contact> removeContacts(String username, List<String> contactIds) throws Exception {
        return this.storage_.removeContacts(username, contactIds);
    }

    @Override
    public void moveContacts(String username, List<Contact> contacts, String addressType) throws Exception {
        this.storage_.moveContacts(username, contacts, addressType);
    }

    @Override
    public void addUserContactInAddressBook(String userId, String addressBookId) throws Exception {
        this.storage_.addUserContactInAddressBook(userId, addressBookId);
    }

    @Override
    public List<AddressBook> getGroups(String username) throws Exception {
        return this.storage_.findPersonalAddressBooksByOwner(username);
    }

    @Override
    public List<String> getPublicAddresses(String username) throws Exception {
        return this.storage_.getPublicAddresses(username);
    }

    @Override
    public AddressBook getPersonalAddressBook(String username, String addressBookId) throws Exception {
        return this.storage_.loadPersonalAddressBook(username, addressBookId);
    }

    @Override
    public AddressBook getPublicAddressBook(String username, String addressBookId) throws Exception {
        return this.storage_.loadPublicAddressBook(username, addressBookId);
    }

    @Override
    public void saveAddressBook(String username, AddressBook group, boolean isNew) throws Exception {
        this.storage_.savePersonalOrSharedAddressBook(username, group, isNew);
    }

    @Override
    public AddressBook removeAddressBook(String username, String addressBookId) throws Exception {
        this.storage_.clearAddressBook(username, addressBookId);
        AddressBook removed = this.storage_.removePersonalAddressBook(username, addressBookId);
        return removed;
    }

    @Override
    public void removeUserShareContact(String username, String contactId, String removedUser) throws Exception {
        this.storage_.removeUserShareContact(username, contactId, removedUser);
    }

    @Override
    public void shareContact(String username, String[] contactIds, List<String> receiveUsers) throws Exception {
        this.storage_.shareContact(username, contactIds, receiveUsers);
    }

    @Override
    public DataPageList getSharedContacts(String username) throws Exception {
        return this.storage_.getSharedContacts(username);
    }

    @Override
    public void shareAddressBook(String username, String addressBookId, List<String> receiverUsers) throws Exception {
        this.storage_.shareAddressBook(username, addressBookId, receiverUsers);
    }

    @Override
    public void unshareAddressBook(String owner, String addressBookId, String unsharedUser) throws Exception {
        this.storage_.unshareAddressBook(owner, addressBookId, unsharedUser);
    }

    @Override
    public List<SharedAddressBook> getSharedAddressBooks(String username) throws Exception {
        return this.storage_.findSharedAddressBooksByUser(username);
    }

    @Override
    public ContactPageList getSharedContactsByAddressBook(String username, SharedAddressBook addressBook) throws Exception {
        return this.storage_.getSharedContactsByAddressBook(username, addressBook);
    }

    @Override
    public void removeSharedContact(String username, String addressBookId, String contactId) throws Exception {
        this.storage_.removeSharedContact(username, addressBookId, contactId);
    }

    @Override
    public void saveContactToSharedAddressBook(String username, String addressBookId, Contact contact, boolean isNew) throws Exception {
        this.storage_.saveContactToSharedAddressBook(username, addressBookId, contact, isNew);
        for (ContactEventListener ce : this.listeners_) {
            if (isNew) {
                ce.saveContact(username, contact);
                continue;
            }
            ce.updateContact(username, contact);
        }
    }

    @Override
    public Contact getSharedContactAddressBook(String username, String contactId) throws Exception {
        return this.storage_.getSharedContactAddressBook(username, contactId);
    }

    @Override
    public void saveSharedContact(String username, Contact contact) throws Exception {
        this.storage_.saveSharedContact(username, contact);
    }

    @Override
    public Contact getSharedContact(String username, String contactId) throws Exception {
        return this.storage_.getSharedContact(username, contactId);
    }

    @Override
    public Contact getPublicContact(String contactId) throws Exception {
        return this.storage_.loadPublicContactByUser(contactId);
    }

    @Override
    public List<Tag> getTags(String username) throws Exception {
        return this.storage_.getTags(username);
    }

    @Override
    public DataPageList getContactPageListByTag(String username, String tagName) throws Exception {
        return this.storage_.getContactPageListByTag(username, tagName);
    }

    @Override
    public void addTag(String username, List<String> contactIds, List<Tag> tags) throws Exception {
        this.storage_.addTag(username, contactIds, tags);
    }

    @Override
    public void addTag(String username, List<String> contactIds, String tagId) throws Exception {
        this.storage_.addTag(username, contactIds, tagId);
    }

    @Override
    public Tag removeTag(String username, String tagName) throws Exception {
        return this.storage_.removeTag(username, tagName);
    }

    @Override
    public void updateTag(String username, Tag tag) throws Exception {
        this.storage_.updateTag(username, tag);
    }

    @Override
    public void removeContactTag(String username, List<String> contactIds, List<String> tags) throws Exception {
        this.storage_.removeContactTag(username, contactIds, tags);
    }

    @Override
    public ContactPageList getPublicContactsByAddressBook(String groupId) throws Exception {
        return this.storage_.getPublicContactsByAddressBook(groupId);
    }

    @Override
    public void pasteAddressBook(String username, String srcAddress, String srcType, String destAddress, String destType) throws Exception {
        this.storage_.pasteAddressBook(username, srcAddress, srcType, destAddress, destType);
    }

    @Override
    public List<Contact> pasteContacts(String username, String destAddress, String destType, Map<String, String> contactsMap) throws Exception {
        return this.storage_.pasteContacts(username, destAddress, destType, contactsMap);
    }

    @Override
    public ContactImportExport getContactImportExports(String type) {
        return this.contactImportExport_.get(type);
    }

    @Override
    public String[] getImportExportType() throws Exception {
        return this.contactImportExport_.keySet().toArray(new String[0]);
    }

    @Override
    public DataPageList searchContact(String username, ContactFilter filter) throws Exception {
        return this.storage_.searchContact(username, filter);
    }

    @Override
    public AddressBook getSharedAddressBook(String username, String addressBookId) throws Exception {
        return this.storage_.getSharedAddressBookById(username, addressBookId);
    }

    @Override
    public List<String> getAllEmailBySharedGroup(String username, String addressBookId) throws Exception {
        return this.storage_.getAllEmailBySharedGroup(username, addressBookId);
    }

    @Override
    public List<String> getAllEmailByPublicGroup(String username, String groupId) throws Exception {
        return this.storage_.findEmailsInPublicAddressBook(username, groupId);
    }

    @Override
    public void registerNewUser(User user, boolean isNew) throws Exception {
        this.storage_.registerNewUser(user, isNew);
    }

    @Override
    public void updateProfile(UserProfile userProfile) throws Exception {
        Contact contact = this.storage_.loadPublicContactByUser(userProfile.getUserName());
        if (contact == null) {
            return;
        }
        contact.setNickName(userProfile.getAttribute("user.name.nickName"));
        try {
            Date date = new Date(userProfile.getAttribute("user.bdate"));
            contact.setBirthday(date);
        }
        catch (Exception e) {
            // empty catch block
        }
        contact.setGender(userProfile.getAttribute("user.gender"));
        StringBuilder builderNote = new StringBuilder();
        if (!Utils.isEmpty(userProfile.getAttribute("user.employer"))) {
            builderNote.append(userProfile.getAttribute("user.employer"));
        }
        if (!Utils.isEmpty(userProfile.getAttribute("user.department"))) {
            if (builderNote.length() == 0) {
                builderNote.append(userProfile.getAttribute("user.department"));
            } else {
                builderNote.append("\n" + userProfile.getAttribute("user.department"));
            }
        }
        if (!Utils.isEmpty(userProfile.getAttribute("user.language"))) {
            if (builderNote.length() == 0) {
                builderNote.append(userProfile.getAttribute("user.language"));
            } else {
                builderNote.append("\n" + userProfile.getAttribute("user.language"));
            }
        }
        contact.setNote(builderNote.toString());
        contact.setJobTitle(userProfile.getAttribute("user.jobtitle"));
        StringBuilder builderHomeAddress = new StringBuilder();
        if (!Utils.isEmpty(userProfile.getAttribute("user.home-info.postal.name"))) {
            builderHomeAddress.append(userProfile.getAttribute("user.home-info.postal.name"));
        }
        if (!Utils.isEmpty(userProfile.getAttribute("user.home-info.postal.street"))) {
            if (builderHomeAddress.length() == 0) {
                builderHomeAddress.append(userProfile.getAttribute("user.home-info.postal.street"));
            } else {
                builderHomeAddress.append(" " + userProfile.getAttribute("user.home-info.postal.street"));
            }
        }
        contact.setHomeAddress(builderHomeAddress.toString());
        contact.setWorkAddress(userProfile.getAttribute("user.business-info.postal.name"));
        contact.setWorkCity(userProfile.getAttribute("user.business-info.postal.city"));
        contact.setWorkStateProvince(userProfile.getAttribute("user.business-info.postal.stateprov"));
        contact.setWorkPostalCode(userProfile.getAttribute("user.business-info.postal.postalcode"));
        contact.setWorkCountry(userProfile.getAttribute("user.business-info.postal.country"));
        contact.setWorkPhone1(userProfile.getAttribute("user.business-info.telecom.telephone.number"));
        contact.setWorkPhone2(userProfile.getAttribute("user.business-info.telecom.mobile.number"));
        contact.setWebPage(userProfile.getAttribute("user.business-info.online.uri"));
        contact.setHomeCity(userProfile.getAttribute("user.home-info.postal.city"));
        contact.setHomeState_province(userProfile.getAttribute("user.home-info.postal.stateprov"));
        contact.setHomePostalCode(userProfile.getAttribute("user.home-info.postal.postalcode"));
        contact.setHomeCountry(userProfile.getAttribute("user.home-info.postal.country"));
        contact.setHomePhone1(userProfile.getAttribute("user.home-info.telecom.telephone.number"));
        contact.setHomePhone2(userProfile.getAttribute("user.home-info.telecom.mobile.number"));
        contact.setPersonalSite(userProfile.getAttribute("user.home-info.online.uri"));
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        String email = organizationService.getUserHandler().findUserByName(userProfile.getUserName()).getEmail();
        StringBuilder builderEmailAddress = new StringBuilder();
        if (!Utils.isEmpty(email)) {
            builderEmailAddress.append(email);
        }
        if (!Utils.isEmpty(userProfile.getAttribute("user.home-info.online.email"))) {
            if (builderEmailAddress.length() == 0) {
                builderEmailAddress.append(userProfile.getAttribute("user.home-info.online.email"));
            } else {
                builderEmailAddress.append("," + userProfile.getAttribute("user.home-info.online.email"));
            }
        }
        if (!Utils.isEmpty(userProfile.getAttribute("user.business-info.online.email"))) {
            if (builderEmailAddress.length() == 0) {
                builderEmailAddress.append(userProfile.getAttribute("user.business-info.online.email"));
            } else {
                builderEmailAddress.append("," + userProfile.getAttribute("user.business-info.online.email"));
            }
        }
        contact.setEmailAddress(builderEmailAddress.toString());
        GregorianCalendar cal = new GregorianCalendar();
        contact.setLastUpdated(cal.getTime());
        this.saveContact(userProfile.getUserName(), contact, false);
    }

    public void addGroupToPersonalContact(String userId, String groupId) throws Exception {
        this.addUserContactInAddressBook(userId, groupId);
    }

    @Override
    public void saveAddress(String username, String emailAddress) throws Exception {
        this.storage_.saveAddress(username, emailAddress);
    }

    @Override
    public Tag getTag(String username, String tagName) throws Exception {
        return this.storage_.getTag(username, tagName);
    }

    @Override
    public boolean haveEditPermissionOnContact(String username, Contact contact) throws Exception {
        return this.storage_.haveEditPermissionOnContact(username, contact);
    }

    @Override
    public void addListenerPlugin(ContactEventListener listener) throws Exception {
        this.listeners_.add(listener);
    }

    @Override
    public void savePublicAddressBook(AddressBook addressbook, boolean isNew) throws Exception {
        this.storage_.savePublicAddressBook(addressbook, isNew);
    }
}

