/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactAttachment;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.GroupImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ContactUtils {
    public static final String SCORE = " - ".intern();
    public static final String SHARED = " (Shared)".intern();
    private static String AKONG = "@";
    public static final String HTTP = "http://";
    public static String[] specialString = new String[]{"!", "#", "$", "%", "^", "&", ":", ">", "<", "~", "`", "]", "'", "/"};
    public static final String[] imageTypes = new String[]{".gif", ".jpg", ".jpeg", ".tiff", ".bmp", ".png", ".tif"};

    public static String encodeJCRText(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static String filterString(String text, boolean isEmail) {
        for (String str : specialString) {
            text = text.replaceAll(str, "");
        }
        if (!isEmail) {
            text = text.replaceAll(AKONG, "");
        }
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '?' || text.charAt(i) == '[' || text.charAt(i) == '(' || text.charAt(i) == '|' || text.charAt(i) == ')' || text.charAt(i) == '*' || text.charAt(i) == '\\' || text.charAt(i) == '+' || text.charAt(i) == '}' || text.charAt(i) == '{' || text.charAt(i) == '^' || text.charAt(i) == '$' || text.charAt(i) == '\"') {
                text = text.replace(text.charAt(i) + "", "");
                continue;
            }
            ++i;
        }
        return text;
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static ContactService getContactService() throws Exception {
        return (ContactService)PortalContainer.getComponent(ContactService.class);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static List<String> getUserGroups() throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        Object[] objGroupIds = organizationService.getGroupHandler().findGroupsOfUser(ContactUtils.getCurrentUser()).toArray();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Object object : objGroupIds) {
            groupIds.add(((GroupImpl)object).getId());
        }
        return groupIds;
    }

    public static String getImageSource(Contact contact, DownloadService dservice) throws Exception {
        ContactAttachment contactAttachment = contact.getAttachment();
        if (contactAttachment != null) {
            try {
                InputStream input = contactAttachment.getInputStream();
                byte[] imageBytes = null;
                if (input != null) {
                    imageBytes = new byte[input.available()];
                    input.read(imageBytes);
                    ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
                    InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
                    dresource.setDownloadName(contactAttachment.getFileName());
                    return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
                }
            }
            catch (PathNotFoundException ex) {
                return null;
            }
        }
        return null;
    }

    public static boolean isPublicGroup(String groupId) throws Exception {
        return ContactUtils.getUserGroups().contains(groupId);
    }

    public static String formatDate(String format, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format((Object)date);
    }

    public static List<Account> getAccounts() throws Exception {
        MailService mailSvr = (MailService)PortalContainer.getComponent(MailService.class);
        try {
            return mailSvr.getAccounts(SessionProviderFactory.createSessionProvider(), ContactUtils.getCurrentUser());
        }
        catch (RepositoryException e) {
            return null;
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }
}

