/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(template="app:/templates/contact/webui/popup/UIProfileInputSet.gtmpl")
public class UIProfileInputSet
extends UIFormInputWithActions {
    private static final String FIELD_FIRSTNAME_INPUT = "firstName";
    private static final String FIELD_LASTNAME_INPUT = "lastName";
    private static final String FIELD_NICKNAME_INPUT = "nickName";
    private static final String FIELD_GENDER_BOX = "gender";
    private static final String INFO_BIRTHDAY = "birthday";
    private static final String FIELD_DAY = "day";
    private static final String FIELD_MONTH = "month";
    private static final String FIELD_YEAR = "year";
    private static final String FIELD_JOBTITLE_INPUT = "jobTitle";
    private static final String FIELD_EMAIL_INPUT = "email";
    private static final String MALE = "male";
    private static final String FEMALE = "female";
    private String gender = "male";
    private byte[] imageBytes = null;
    private String fileName = null;
    private String imageMimeType = null;

    public UIProfileInputSet(String id) throws Exception {
        super(id);
        this.setComponentConfig(this.getClass(), null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_FIRSTNAME_INPUT, FIELD_FIRSTNAME_INPUT, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LASTNAME_INPUT, FIELD_LASTNAME_INPUT, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NICKNAME_INPUT, FIELD_NICKNAME_INPUT, null));
        ArrayList<SelectItemOption> genderOptions = new ArrayList<SelectItemOption>();
        genderOptions.add(new SelectItemOption(MALE, (Object)MALE));
        genderOptions.add(new SelectItemOption(FEMALE, (Object)FEMALE));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(FIELD_GENDER_BOX, FIELD_GENDER_BOX, genderOptions));
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(INFO_BIRTHDAY, INFO_BIRTHDAY, null));
        ArrayList<SelectItemOption> datesOptions = new ArrayList<SelectItemOption>();
        datesOptions.add(new SelectItemOption("- day -", (Object)FIELD_DAY));
        for (int i = 1; i < 32; ++i) {
            String date = i + "";
            datesOptions.add(new SelectItemOption(date, (Object)date));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_DAY, FIELD_DAY, datesOptions));
        ArrayList<SelectItemOption> monthOptions = new ArrayList<SelectItemOption>();
        monthOptions.add(new SelectItemOption("-month-", (Object)FIELD_MONTH));
        for (int i = 1; i < 13; ++i) {
            String month = i + "";
            monthOptions.add(new SelectItemOption(month, (Object)month));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_MONTH, FIELD_MONTH, monthOptions));
        String date = ContactUtils.formatDate((String)"dd/MM/yyyy", (Date)new Date());
        String strDate = date.substring(date.lastIndexOf("/") + 1, date.length());
        int thisYear = Integer.parseInt(strDate);
        ArrayList<SelectItemOption> yearOptions = new ArrayList<SelectItemOption>();
        yearOptions.add(new SelectItemOption("- year -", (Object)FIELD_YEAR));
        for (int i = thisYear; i >= 1900; --i) {
            String year = i + "";
            yearOptions.add(new SelectItemOption(year, (Object)year));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_YEAR, FIELD_YEAR, yearOptions));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_JOBTITLE_INPUT, FIELD_JOBTITLE_INPUT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_EMAIL_INPUT, FIELD_EMAIL_INPUT, null).addValidator(EmailAddressValidator.class, new Object[0]));
    }

    protected String getFieldFirstName() {
        return (String)this.getUIStringInput(FIELD_FIRSTNAME_INPUT).getValue();
    }

    protected void setFieldFirstName(String s) {
        this.getUIStringInput(FIELD_FIRSTNAME_INPUT).setValue((Object)s);
    }

    protected String getFieldLastName() {
        return (String)this.getUIStringInput(FIELD_LASTNAME_INPUT).getValue();
    }

    protected void setFieldLastName(String s) {
        this.getUIStringInput(FIELD_LASTNAME_INPUT).setValue((Object)s);
    }

    protected String getFieldNickName() {
        return (String)this.getUIStringInput(FIELD_NICKNAME_INPUT).getValue();
    }

    protected void setFieldNickName(String s) {
        this.getUIStringInput(FIELD_NICKNAME_INPUT).setValue((Object)s);
    }

    protected String getFieldGender() {
        String value = (String)((UIFormRadioBoxInput)this.getChild(UIFormRadioBoxInput.class)).getValue();
        if (!value.equals(FIELD_GENDER_BOX)) {
            return value;
        }
        return null;
    }

    protected void setFieldGender(String s) {
        this.gender = s;
    }

    protected Date getFieldBirthday() {
        int year = 0;
        int month = 0;
        int day = 0;
        boolean emptyYear = false;
        boolean emptyMonth = false;
        boolean emptyDay = false;
        try {
            day = Integer.parseInt((String)this.getUIFormSelectBox(FIELD_DAY).getValue());
        }
        catch (NumberFormatException e) {
            emptyDay = true;
        }
        try {
            month = Integer.parseInt((String)this.getUIFormSelectBox(FIELD_MONTH).getValue());
        }
        catch (NumberFormatException e) {
            emptyMonth = true;
        }
        try {
            year = Integer.parseInt((String)this.getUIFormSelectBox(FIELD_YEAR).getValue());
        }
        catch (NumberFormatException e) {
            emptyYear = true;
        }
        if (emptyDay && emptyMonth && emptyYear) {
            return null;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setLenient(false);
        cal.set(5, day);
        cal.set(2, month - 1);
        cal.set(1, year);
        return cal.getTime();
    }

    protected void setFieldBirthday(Date date) throws Exception {
        if (date != null) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(date);
            this.getUIFormSelectBox(FIELD_MONTH).setValue(String.valueOf(cal.get(2) + 1));
            this.getUIFormSelectBox(FIELD_DAY).setValue(String.valueOf(cal.get(5)));
            this.getUIFormSelectBox(FIELD_YEAR).setValue(String.valueOf(cal.get(1)));
        }
    }

    protected String getFieldJobName() {
        return (String)this.getUIStringInput(FIELD_JOBTITLE_INPUT).getValue();
    }

    protected void setFieldJobName(String s) {
        this.getUIStringInput(FIELD_JOBTITLE_INPUT).setValue((Object)s);
    }

    protected UIForm getParentFrom() {
        return (UIForm)this.getParent();
    }

    protected String getFieldEmail() {
        return (String)this.getUIStringInput(FIELD_EMAIL_INPUT).getValue();
    }

    protected void setFieldEmail(String s) {
        this.getUIStringInput(FIELD_EMAIL_INPUT).setValue((Object)s);
    }

    protected void setImage(InputStream input) throws Exception {
        if (input != null) {
            this.imageBytes = new byte[input.available()];
            input.read(this.imageBytes);
        } else {
            this.imageBytes = null;
        }
    }

    protected byte[] getImage() {
        return this.imageBytes;
    }

    protected String getMimeType() {
        return this.imageMimeType;
    }

    protected void setMimeType(String mimeType) {
        this.imageMimeType = mimeType;
    }

    protected void setFileName(String name) {
        this.fileName = name;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getImageSource() throws Exception {
        if (this.imageBytes == null || this.imageBytes.length == 0) {
            return null;
        }
        ByteArrayInputStream byteImage = new ByteArrayInputStream(this.imageBytes);
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
        dresource.setDownloadName(this.fileName);
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }
}

