/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.webui.popup.UICategoryForm;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICategoryForm
extends UIForm
implements UIPopupComponent {
    private boolean isNew_ = true;
    private String groupId_;
    public static final String FIELD_CATEGORYNAME_INPUT = "categoryName";
    public static final String FIELD_DESCRIPTION_INPUT = "description";
    public String editedAddName = null;

    public UICategoryForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_CATEGORYNAME_INPUT, FIELD_CATEGORYNAME_INPUT, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{1, 40}));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DESCRIPTION_INPUT, FIELD_DESCRIPTION_INPUT, null));
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public boolean isNew() {
        return this.isNew_;
    }

    public void setNew(boolean isNew) {
        this.isNew_ = isNew;
    }

    public void setValues(String groupId, boolean isShared) throws Exception {
        ContactService contactService = ContactUtils.getContactService();
        String username = ContactUtils.getCurrentUser();
        AddressBook contactGroup = isShared ? contactService.getSharedAddressBook(username, groupId) : contactService.getPersonalAddressBook(username, groupId);
        if (contactGroup != null) {
            this.groupId_ = groupId;
            this.getUIStringInput(FIELD_CATEGORYNAME_INPUT).setValue((Object)contactGroup.getName());
            this.getUIFormTextAreaInput(FIELD_DESCRIPTION_INPUT).setValue((Object)contactGroup.getDescription());
            this.editedAddName = contactGroup.getName();
        }
    }

    static /* synthetic */ boolean access$000(UICategoryForm x0) {
        return x0.isNew_;
    }

    static /* synthetic */ String access$100(UICategoryForm x0) {
        return x0.groupId_;
    }
}

