/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.contact.service.impl.NewUserListener;
import org.exoplatform.contact.webui.UIAddressBooks;
import org.exoplatform.contact.webui.UIContacts;
import org.exoplatform.contact.webui.UIWorkingContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/contact/webui/UIAddressBooks.gtmpl", events={@EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={CopyAddressActionListener.class}), @EventConfig(listeners={PasteContactsActionListener.class}), @EventConfig(listeners={AddAddressActionListener.class}), @EventConfig(listeners={ImportAddressActionListener.class}), @EventConfig(listeners={ExportAddressActionListener.class}), @EventConfig(listeners={EditGroupActionListener.class}), @EventConfig(listeners={PermissionsActionListener.class}), @EventConfig(listeners={ShareGroupActionListener.class}), @EventConfig(listeners={DeleteGroupActionListener.class}, confirm="UIAddressBooks.msg.confirm-delete"), @EventConfig(listeners={DeleteSharedGroupActionListener.class}, confirm="UIAddressBooks.msg.confirm-discard"), @EventConfig(listeners={SelectGroupActionListener.class}), @EventConfig(listeners={SelectPublicGroupActionListener.class}), @EventConfig(listeners={SelectSharedContactActionListener.class}), @EventConfig(listeners={SelectSharedGroupActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={SendEmailActionListener.class})})
public class UIAddressBooks
extends UIComponent {
    private String selectedGroup = null;
    private Map<String, String> privateAddressBookMap_ = new LinkedHashMap();
    private Map<String, SharedAddressBook> sharedAddressBookMap_ = new LinkedHashMap();
    private Map<String, String> copyContacts = new LinkedHashMap();
    private String copyAddress = null;

    private boolean hasSharedContacts() throws Exception {
        return ContactUtils.getContactService().getSharedContacts(ContactUtils.getCurrentUser()).getAvailable() > 0L;
    }

    public List<AddressBook> getGroups() throws Exception {
        List groupList = ContactUtils.getContactService().getGroups(ContactUtils.getCurrentUser());
        this.privateAddressBookMap_.clear();
        for (AddressBook group : groupList) {
            ResourceBundle res;
            WebuiRequestContext context;
            String groupName = group.getName();
            if (group.getId().equals(NewUserListener.DEFAULTGROUP + ContactUtils.getCurrentUser()) && groupName.equals(NewUserListener.DEFAULTGROUPNAME) && group.getDescription().equals(NewUserListener.DEFAULTGROUPDES)) {
                context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                res = context.getApplicationResourceBundle();
                try {
                    groupName = res.getString("UIAddressBooks.label.defaultAddName");
                    String des = res.getString("UIAddressBooks.label.defaultAddDes");
                    group.setName(groupName);
                    group.setDescription(des);
                    ContactUtils.getContactService().saveAddressBook(ContactUtils.getCurrentUser(), group, false);
                }
                catch (MissingResourceException e) {
                    e.printStackTrace();
                }
            } else if (group.getId().equals(NewUserListener.ADDRESSESGROUP + ContactUtils.getCurrentUser()) && groupName.equals(NewUserListener.ADDRESSESGROUPNAME)) {
                context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                res = context.getApplicationResourceBundle();
                try {
                    groupName = res.getString("UIAddressBooks.label.collectedAddresses");
                    group.setName(groupName);
                    ContactUtils.getContactService().saveAddressBook(ContactUtils.getCurrentUser(), group, false);
                }
                catch (MissingResourceException e) {
                    e.printStackTrace();
                }
            }
            this.privateAddressBookMap_.put(group.getId(), groupName);
        }
        return groupList;
    }

    public List<String> getGroupsOfUser() throws Exception {
        return ContactUtils.getContactService().getPublicAddressBookIdsOfUser(ContactUtils.getCurrentUser());
    }

    public List<String> getPublicContactGroups() throws Exception {
        List publicAddressBookIds = ContactUtils.getContactService().getAllsPublicAddressBookIds(ContactUtils.getCurrentUser());
        return publicAddressBookIds;
    }

    public boolean isSelectSharedContacts() {
        return ((UIContacts)((UIWorkingContainer)this.getAncestorOfType(UIWorkingContainer.class)).findFirstComponentOfType(UIContacts.class)).isSelectSharedContacts();
    }

    public Map<String, SharedAddressBook> getSharedGroups() throws Exception {
        this.sharedAddressBookMap_.clear();
        List addressList = ContactUtils.getContactService().getSharedAddressBooks(ContactUtils.getCurrentUser());
        for (SharedAddressBook address : addressList) {
            this.sharedAddressBookMap_.put(address.getId(), address);
        }
        return this.sharedAddressBookMap_;
    }

    public boolean havePermission(String groupId) throws Exception {
        String currentUser = ContactUtils.getCurrentUser();
        AddressBook sharedGroup = ContactUtils.getContactService().getSharedAddressBook(currentUser, groupId);
        if (sharedGroup == null) {
            return false;
        }
        if (sharedGroup.getEditPermissionUsers() != null && Arrays.asList(sharedGroup.getEditPermissionUsers()).contains(currentUser + DataStorage.HYPHEN)) {
            return true;
        }
        String[] editPerGroups = sharedGroup.getEditPermissionGroups();
        if (editPerGroups != null) {
            for (String editPer : editPerGroups) {
                if (!ContactUtils.getUserGroups().contains(editPer)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean havePermissionsPublicAddress(String groupId) throws Exception {
        AddressBook addressBook = ContactUtils.getContactService().getPublicAddressBook(ContactUtils.getCurrentUser(), groupId);
        if (addressBook == null) {
            return false;
        }
        if (addressBook.getEditPermissionUsers() != null && Arrays.asList(addressBook.getEditPermissionUsers()).contains(ContactUtils.getCurrentUser())) {
            return true;
        }
        String[] editPerGroups = addressBook.getEditPermissionGroups();
        if (editPerGroups != null) {
            for (String editPer : editPerGroups) {
                if (!ContactUtils.getUserGroups().contains(editPer.split(Utils.COLON)[0])) continue;
                String editGroup = editPer.split(Utils.COLON)[0];
                String editMembership = null;
                if (editPer.contains(Utils.COLON)) {
                    editMembership = editPer.split(Utils.COLON)[1];
                }
                if (editMembership.contains(Utils.MEMBERSHIP)) {
                    editMembership = editMembership.replace(Utils.MEMBERSHIP, "");
                }
                if (editMembership.contains("*")) {
                    return true;
                }
                OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
                if (organizationService.getMembershipHandler().findMembershipByUserGroupAndType(ContactUtils.getCurrentUser(), editGroup, editMembership) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void setSelectedGroup(String groupId) {
        this.selectedGroup = groupId;
    }

    public String getSelectedGroup() {
        return this.selectedGroup;
    }

    public Map<String, String> getPrivateGroupMap() {
        return this.privateAddressBookMap_;
    }

    public boolean canPaste() {
        return !ContactUtils.isEmpty((String)this.copyAddress) || this.copyContacts.size() > 0;
    }

    public void setCopyAddress(String add) {
        this.copyAddress = add;
    }

    public boolean isDefault(String groupId) throws Exception {
        return groupId.contains(NewUserListener.DEFAULTGROUP) || groupId.contains(NewUserListener.ADDRESSESGROUP);
    }

    public void setCopyContacts(Map<String, String> contacts) {
        this.copyContacts = contacts;
    }

    public Map<String, String> getCopyContacts() {
        return this.copyContacts;
    }

    static /* synthetic */ String access$002(UIAddressBooks x0, String x1) {
        x0.copyAddress = x1;
        return x0.copyAddress;
    }

    static /* synthetic */ Map access$100(UIAddressBooks x0) {
        return x0.copyContacts;
    }

    static /* synthetic */ Map access$200(UIAddressBooks x0) {
        return x0.privateAddressBookMap_;
    }

    static /* synthetic */ String access$000(UIAddressBooks x0) {
        return x0.copyAddress;
    }

    static /* synthetic */ Map access$300(UIAddressBooks x0) {
        return x0.sharedAddressBookMap_;
    }

    static /* synthetic */ String access$400(UIAddressBooks x0) {
        return x0.selectedGroup;
    }

    static /* synthetic */ String access$402(UIAddressBooks x0, String x1) {
        x0.selectedGroup = x1;
        return x0.selectedGroup;
    }
}

