/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.webui.popup.UIAddEditPermission;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.contact.webui.popup.UISharedForm;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIAddEditPermission.msg.confirm-delete")})
public class UIAddEditPermission
extends UIContainer
implements UIPopupComponent {
    public static String[] BEAN_FIELD = new String[]{"viewPermission", "editPermission"};
    private static String[] ACTION = new String[]{"Edit", "Delete"};
    private String groupId_;
    private String contactId_;
    private boolean isSharedGroup;

    public UIAddEditPermission() throws Exception {
        this.setName("UIAddEditPermission");
        UIGrid permissionList = (UIGrid)this.addChild(UIGrid.class, null, "PermissionList");
        permissionList.configure("viewPermission", BEAN_FIELD, ACTION);
        permissionList.getUIPageIterator().setId("PermissionListIterator");
        this.addChild(UISharedForm.class, null, null);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void initGroup(AddressBook group) throws Exception {
        UISharedForm shareForm = (UISharedForm)this.getChild(UISharedForm.class);
        shareForm.setGroup(group);
        shareForm.init();
        this.updateGroupGrid(group);
        this.groupId_ = group.getId();
        this.isSharedGroup = true;
    }

    public void initContact(Contact contact) throws Exception {
        UISharedForm shareForm = (UISharedForm)this.getChild(UISharedForm.class);
        shareForm.setContact(contact);
        shareForm.init();
        this.updateContactGrid(contact);
        this.contactId_ = contact.getId();
        this.isSharedGroup = false;
    }

    public void updateContactGrid(Contact contact) throws Exception {
        ArrayList<data> dataRow = new ArrayList<data>();
        if (contact.getViewPermissionUsers() != null) {
            for (String username : contact.getViewPermissionUsers()) {
                dataRow.add(new data(this, username, contact.getEditPermissionUsers() != null && Arrays.asList(contact.getEditPermissionUsers()).contains(username)));
            }
        }
        if (contact.getViewPermissionGroups() != null) {
            for (String username : contact.getViewPermissionGroups()) {
                dataRow.add(new data(this, username, contact.getEditPermissionGroups() != null && Arrays.asList(contact.getEditPermissionGroups()).contains(username)));
            }
        }
        UIGrid permissionList = (UIGrid)this.getChild(UIGrid.class);
        int currentPage = 1;
        try {
            currentPage = permissionList.getUIPageIterator().getPageList().getCurrentPage();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(data.class, dataRow), 10);
        permissionList.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > 1) {
            permissionList.getUIPageIterator().setCurrentPage(currentPage);
        }
        ((UISharedForm)this.getChild(UISharedForm.class)).setContact(contact);
    }

    public void updateGroupGrid(AddressBook group) throws Exception {
        ArrayList<data> dataRow = new ArrayList<data>();
        if (group.getViewPermissionUsers() != null) {
            for (String username : group.getViewPermissionUsers()) {
                dataRow.add(new data(this, username, group.getEditPermissionUsers() != null && Arrays.asList(group.getEditPermissionUsers()).contains(username)));
            }
        }
        if (group.getViewPermissionGroups() != null) {
            for (String groupId : group.getViewPermissionGroups()) {
                dataRow.add(new data(this, groupId, group.getEditPermissionGroups() != null && Arrays.asList(group.getEditPermissionGroups()).contains(groupId)));
            }
        }
        UIGrid permissionList = (UIGrid)this.getChild(UIGrid.class);
        int currentPage = 1;
        try {
            currentPage = permissionList.getUIPageIterator().getPageList().getCurrentPage();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(data.class, dataRow), 10);
        permissionList.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > 1 && currentPage <= permissionList.getUIPageIterator().getAvailablePage()) {
            permissionList.getUIPageIterator().setCurrentPage(currentPage);
        }
        ((UISharedForm)this.getChild(UISharedForm.class)).setGroup(group);
    }

    static /* synthetic */ boolean access$000(UIAddEditPermission x0) {
        return x0.isSharedGroup;
    }

    static /* synthetic */ String access$100(UIAddEditPermission x0) {
        return x0.groupId_;
    }

    static /* synthetic */ String access$200(UIAddEditPermission x0) {
        return x0.contactId_;
    }
}

