/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;

public class PermissionData {
    private static final Log log = ExoLogger.getExoLogger(PermissionData.class);
    String viewPermission = null;
    String editPermission = null;

    public String getViewPermission() {
        return this.viewPermission;
    }

    public String getEditPermission() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            if (this.editPermission != null && this.editPermission.equalsIgnoreCase("true")) {
                return res.getString("UIAddEditPermission.label.true");
            }
            return res.getString("UIAddEditPermission.label.false");
        }
        catch (MissingResourceException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"MissingResourceException in method getEditPermission", (Throwable)e);
            }
            return this.editPermission;
        }
    }

    public PermissionData(String username, boolean canEdit) throws Exception {
        this.viewPermission = username.replaceFirst(DataStorage.HYPHEN, "");
        String edit = String.valueOf(canEdit);
        this.editPermission = edit.replaceFirst(DataStorage.HYPHEN, "");
    }
}

