/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.webui.popup.UIExportAddressBookForm;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/contact/webui/popup/UIExportAddressBookForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIExportAddressBookForm
extends UIForm
implements UIPopupComponent {
    private UIPageIterator uiPageIterator_;
    private Map<String, String> privateGroupMap_ = new LinkedHashMap();
    private Map<String, String> publicGroupMap_ = new LinkedHashMap();
    private Map<String, SharedAddressBook> sharedGroupMap_ = new LinkedHashMap();
    private Map<String, String> checkedAddress = new LinkedHashMap();

    public String getLabel(String id) throws Exception {
        try {
            return super.getLabel(id);
        }
        catch (MissingResourceException mre) {
            return id;
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Map<String, String> getContactGroups() throws Exception {
        return this.privateGroupMap_;
    }

    public void setContactGroups(Map<String, String> contactGroups) {
        this.privateGroupMap_ = contactGroups;
    }

    public Map<String, SharedAddressBook> getSharedContactGroups() {
        return this.sharedGroupMap_;
    }

    public void setSharedContactGroups(Map<String, SharedAddressBook> contactGroups) {
        this.sharedGroupMap_ = contactGroups;
    }

    public Map<String, String> getPublicContactGroup() {
        return this.publicGroupMap_;
    }

    public void setPublicContactGroup(Map<String, String> groups) {
        this.publicGroupMap_ = groups;
    }

    public void updateList() throws Exception {
        this.getChildren().clear();
        this.uiPageIterator_ = new UIPageIterator();
        this.uiPageIterator_.setId("UIAddressPage");
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (String type : ContactUtils.getContactService().getImportExportType()) {
            options.add(new SelectItemOption(type, (Object)type));
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ContactUtils.NAME, ContactUtils.NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(ContactUtils.TYPE, ContactUtils.TYPE, options));
        ArrayList<String> listGroup = new ArrayList<String>();
        for (String group : this.privateGroupMap_.keySet()) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(group, (String)this.privateGroupMap_.get(group), (Object)false));
            listGroup.add(group);
        }
        for (String group : this.sharedGroupMap_.keySet()) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(group, ((SharedAddressBook)this.sharedGroupMap_.get(group)).getName(), (Object)false));
            listGroup.add(group);
        }
        for (String group : this.publicGroupMap_.keySet()) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(group, group, (Object)false));
            listGroup.add(group);
        }
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(String.class, listGroup), 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
    }

    public List<String> getCheckedGroups() throws Exception {
        ArrayList<String> addresList = new ArrayList<String>();
        for (String add : this.checkedAddress.keySet()) {
            if (this.sharedGroupMap_.containsKey(add)) {
                addresList.add(add + DataStorage.HYPHEN + ((SharedAddressBook)this.sharedGroupMap_.get(add)).getSharedUserId());
                continue;
            }
            addresList.add(add);
        }
        return addresList;
    }

    public List<String> getAddress() throws Exception {
        return new ArrayList<String>(this.uiPageIterator_.getCurrentPageData());
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public long getAvailablePage() {
        return this.uiPageIterator_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageIterator_.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiPageIterator_.setCurrentPage(page);
        for (String add : this.getAddress()) {
            if (!this.checkedAddress.containsKey(add)) continue;
            UIFormCheckBoxInput uiCheckBox = (UIFormCheckBoxInput)this.getChildById(add);
            uiCheckBox.setChecked(true);
        }
    }

    static /* synthetic */ UIPageIterator access$000(UIExportAddressBookForm x0) {
        return x0.uiPageIterator_;
    }

    static /* synthetic */ Map access$100(UIExportAddressBookForm x0) {
        return x0.checkedAddress;
    }
}

