/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.JCRPageList;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.contact.service.impl.NewUserListener;
import org.exoplatform.contact.webui.UIAddressBooks;
import org.exoplatform.contact.webui.UIContactPortlet;
import org.exoplatform.contact.webui.UIContacts;
import org.exoplatform.contact.webui.UISearchForm;
import org.exoplatform.contact.webui.UIWorkingContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/contact/webui/UIAddressBooks.gtmpl", events={@EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={CopyAddressActionListener.class}), @EventConfig(listeners={PasteContactsActionListener.class}), @EventConfig(listeners={AddAddressActionListener.class}), @EventConfig(listeners={ImportAddressActionListener.class}), @EventConfig(listeners={ExportAddressActionListener.class}), @EventConfig(listeners={EditGroupActionListener.class}), @EventConfig(listeners={PermissionsActionListener.class}), @EventConfig(listeners={ShareGroupActionListener.class}), @EventConfig(listeners={DeleteGroupActionListener.class}, confirm="UIAddressBooks.msg.confirm-delete"), @EventConfig(listeners={DeleteSharedGroupActionListener.class}, confirm="UIAddressBooks.msg.confirm-discard"), @EventConfig(listeners={SelectGroupActionListener.class}), @EventConfig(listeners={SelectPublicGroupActionListener.class}), @EventConfig(listeners={SelectSharedContactActionListener.class}), @EventConfig(listeners={SelectSharedGroupActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={SendEmailActionListener.class})})
public class UIAddressBooks
extends UIComponent {
    private static final Log log = ExoLogger.getExoLogger(UIAddressBooks.class);
    private String selectedGroup = null;
    private Map<String, String> privateAddressBookMap_ = new LinkedHashMap();
    private Map<String, SharedAddressBook> sharedAddressBookMap_ = new LinkedHashMap();
    private Map<String, String> copyContacts = new LinkedHashMap();
    private String copyAddress = null;

    protected boolean hasSharedContacts() throws Exception {
        return ContactUtils.getContactService().getSharedContacts(ContactUtils.getCurrentUser()).getAvailable() > 0L;
    }

    public List<AddressBook> getGroups() throws Exception {
        List groupList = ContactUtils.getContactService().getGroups(ContactUtils.getCurrentUser());
        this.privateAddressBookMap_.clear();
        for (AddressBook group : groupList) {
            String groupName;
            block8: {
                ResourceBundle res;
                WebuiRequestContext context;
                groupName = group.getName();
                if (group.getId().equals(NewUserListener.DEFAULTGROUP + ContactUtils.getCurrentUser()) && groupName.equals(NewUserListener.DEFAULTGROUPNAME) && group.getDescription().equals(NewUserListener.DEFAULTGROUPDES)) {
                    context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                    res = context.getApplicationResourceBundle();
                    try {
                        groupName = res.getString("UIAddressBooks.label.defaultAddName");
                        String des = res.getString("UIAddressBooks.label.defaultAddDes");
                        group.setName(groupName);
                        group.setDescription(des);
                        ContactUtils.getContactService().saveAddressBook(ContactUtils.getCurrentUser(), group, false);
                    }
                    catch (MissingResourceException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"MissingResourceException in method getGroups", (Throwable)e);
                        }
                        break block8;
                    }
                }
                if (group.getId().equals(NewUserListener.ADDRESSESGROUP + ContactUtils.getCurrentUser()) && groupName.equals(NewUserListener.ADDRESSESGROUPNAME)) {
                    context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                    res = context.getApplicationResourceBundle();
                    try {
                        groupName = res.getString("UIAddressBooks.label.collectedAddresses");
                        group.setName(groupName);
                        ContactUtils.getContactService().saveAddressBook(ContactUtils.getCurrentUser(), group, false);
                    }
                    catch (MissingResourceException e) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug((Object)"MissingResourceException in method getGroups", (Throwable)e);
                    }
                }
            }
            this.privateAddressBookMap_.put(group.getId(), groupName);
        }
        return groupList;
    }

    public List<String> getGroupsOfUser() throws Exception {
        return ContactUtils.getContactService().getPublicAddressBookIdsOfUser(null);
    }

    public List<String> getPublicContactGroups() throws Exception {
        List publicAddressBookIds = ContactUtils.getContactService().getAllsPublicAddressBookIds(null);
        return publicAddressBookIds;
    }

    public boolean isSelectSharedContacts() {
        return ((UIContacts)((UIWorkingContainer)this.getAncestorOfType(UIWorkingContainer.class)).findFirstComponentOfType(UIContacts.class)).isSelectSharedContacts();
    }

    public Map<String, SharedAddressBook> getSharedGroups() throws Exception {
        this.sharedAddressBookMap_.clear();
        List addressList = ContactUtils.getContactService().getSharedAddressBooks(ContactUtils.getCurrentUser());
        for (SharedAddressBook address : addressList) {
            this.sharedAddressBookMap_.put(address.getId(), address);
        }
        return this.sharedAddressBookMap_;
    }

    public boolean havePermission(String groupId) throws Exception {
        String currentUser = ContactUtils.getCurrentUser();
        AddressBook sharedGroup = ContactUtils.getContactService().getSharedAddressBook(currentUser, groupId);
        if (sharedGroup == null) {
            return false;
        }
        if (sharedGroup.getEditPermissionUsers() != null && Arrays.asList(sharedGroup.getEditPermissionUsers()).contains(currentUser + DataStorage.HYPHEN)) {
            return true;
        }
        String[] editPerGroups = sharedGroup.getEditPermissionGroups();
        if (editPerGroups != null) {
            for (String editPer : editPerGroups) {
                if (!ContactUtils.getUserGroups().contains(editPer)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean havePermissionsPublicAddress(String groupId) throws Exception {
        AddressBook addressBook = ContactUtils.getContactService().getPublicAddressBook(ContactUtils.getCurrentUser(), groupId);
        if (addressBook == null) {
            return false;
        }
        if (addressBook.getEditPermissionUsers() != null && Arrays.asList(addressBook.getEditPermissionUsers()).contains(ContactUtils.getCurrentUser())) {
            return true;
        }
        String[] editPerGroups = addressBook.getEditPermissionGroups();
        if (editPerGroups != null) {
            for (String editPer : editPerGroups) {
                if (!ContactUtils.getUserGroups().contains(editPer.split(Utils.COLON)[0])) continue;
                String editGroup = editPer.split(Utils.COLON)[0];
                String editMembership = null;
                if (editPer.contains(Utils.COLON)) {
                    editMembership = editPer.split(Utils.COLON)[1];
                }
                if (editMembership.contains(Utils.MEMBERSHIP)) {
                    editMembership = editMembership.replace(Utils.MEMBERSHIP, "");
                }
                if (editMembership.contains("*")) {
                    return true;
                }
                Identity identity = ConversationState.getCurrent().getIdentity();
                if (!identity.isMemberOf(editGroup, editMembership)) continue;
                return true;
            }
        }
        return false;
    }

    public void setSelectedGroup(String groupId) {
        this.selectedGroup = groupId;
    }

    public String getSelectedGroup() {
        return this.selectedGroup;
    }

    public Map<String, String> getPrivateGroupMap() {
        return this.privateAddressBookMap_;
    }

    public boolean canPaste() {
        return !ContactUtils.isEmpty((String)this.copyAddress) || this.copyContacts.size() > 0;
    }

    public void setCopyAddress(String add) {
        this.copyAddress = add;
    }

    public boolean isDefault(String groupId) throws Exception {
        return groupId.contains(NewUserListener.DEFAULTGROUP) || groupId.contains(NewUserListener.ADDRESSESGROUP);
    }

    public void setCopyContacts(Map<String, String> contacts) {
        this.copyContacts = contacts;
    }

    public Map<String, String> getCopyContacts() {
        return this.copyContacts;
    }

    private void updateAfterDeleteAddress(UIAddressBooks uiAddressBook, Event<?> event, List<Contact> removedContacts) throws Exception {
        String groupId = event.getRequestContext().getRequestParameter("objectId");
        UIWorkingContainer workingContainer = (UIWorkingContainer)uiAddressBook.getAncestorOfType(UIWorkingContainer.class);
        ((UIContactPortlet)workingContainer.getAncestorOfType(UIContactPortlet.class)).cancelAction();
        UIContacts uiContacts = (UIContacts)workingContainer.findFirstComponentOfType(UIContacts.class);
        if (groupId.equals(uiAddressBook.copyAddress)) {
            uiAddressBook.copyAddress = null;
        }
        if (groupId.equals(uiAddressBook.selectedGroup)) {
            uiAddressBook.selectedGroup = null;
            uiContacts.setContacts(null);
        }
        String selectedTag = uiContacts.getSelectedTag();
        ContactService contactService = ContactUtils.getContactService();
        String username = ContactUtils.getCurrentUser();
        if (!ContactUtils.isEmpty((String)selectedTag)) {
            uiContacts.setContacts((JCRPageList)contactService.getContactPageListByTag(username, selectedTag));
        }
        if (uiContacts.isDisplaySearchResult()) {
            UISearchForm cfr_ignored_0 = (UISearchForm)workingContainer.findFirstComponentOfType(UISearchForm.class);
            uiContacts.setContacts((JCRPageList)contactService.searchContact(username, UISearchForm.filter));
        }
        if (uiContacts.getSelectedGroup() != null && groupId.equals(uiContacts.getSelectedGroup())) {
            uiContacts.setSelectedGroup(null);
        }
        for (Contact contact : removedContacts) {
            uiAddressBook.copyContacts.remove(contact.getId());
        }
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)workingContainer);
    }

    static /* synthetic */ String access$002(UIAddressBooks x0, String x1) {
        x0.copyAddress = x1;
        return x0.copyAddress;
    }

    static /* synthetic */ Map access$100(UIAddressBooks x0) {
        return x0.copyContacts;
    }

    static /* synthetic */ Map access$200(UIAddressBooks x0) {
        return x0.privateAddressBookMap_;
    }

    static /* synthetic */ String access$000(UIAddressBooks x0) {
        return x0.copyAddress;
    }

    static /* synthetic */ Map access$300(UIAddressBooks x0) {
        return x0.sharedAddressBookMap_;
    }

    static /* synthetic */ String access$400(UIAddressBooks x0) {
        return x0.selectedGroup;
    }

    static /* synthetic */ void access$500(UIAddressBooks x0, UIAddressBooks x1, Event x2, List x3) throws Exception {
        x0.updateAfterDeleteAddress(x1, x2, x3);
    }

    static /* synthetic */ String access$402(UIAddressBooks x0, String x1) {
        x0.selectedGroup = x1;
        return x0.selectedGroup;
    }
}

