/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui;

import javax.portlet.PortletPreferences;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.contact.webui.UIActionBar;
import org.exoplatform.contact.webui.UIAddressBooks;
import org.exoplatform.contact.webui.UIWorkingContainer;
import org.exoplatform.contact.webui.popup.UIPopupAction;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/contact/webui/UIContactPortlet.gtmpl")
public class UIContactPortlet
extends UIPortletApplication {
    public UIContactPortlet() throws Exception {
        this.addChild(UIActionBar.class, null, null);
        this.addChild(UIWorkingContainer.class, null, null);
        UIPopupAction uiPopupAction = (UIPopupAction)this.addChild(UIPopupAction.class, null, null);
        uiPopupAction.setId("UIContactPopupAction");
        UIPopupWindow uiPopupWindow = (UIPopupWindow)uiPopupAction.getChild(UIPopupWindow.class);
        uiPopupWindow.setId("UIContactPopupWindow");
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        if (ContactUtils.isEmpty((String)context.getRequestParameter("objectId")) && !context.getParentAppRequestContext().useAjax()) {
            this.processByGroupInSpace((PortletRequestContext)context);
        }
        super.processRender(app, context);
    }

    private void processByGroupInSpace(PortletRequestContext pcontext) throws Exception {
        try {
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            UIAddressBooks addressBooks = (UIAddressBooks)this.findFirstComponentOfType(UIAddressBooks.class);
            String url = pref.getValue("SPACE_URL", null);
            if (url != null) {
                SpaceService sService = (SpaceService)this.getApplicationComponent(SpaceService.class);
                Space space = sService.getSpaceByUrl(url);
                String groupId = Utils.ADDRESSBOOK_ID_PREFIX + space.getPrettyName();
                addressBooks.processSelectGroup((WebuiRequestContext)pcontext, groupId);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to rendering portlet by group in space", (Throwable)e);
        }
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    protected ContinuationService getContinuationService() {
        ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    public String getUserToken() throws Exception {
        ContinuationService continuation = this.getContinuationService();
        try {
            return continuation.getUserToken(ContactUtils.getCurrentUser());
        }
        catch (Exception e) {
            return "";
        }
    }

    protected String getCometdContextName() {
        String cometdContextName = "cometd";
        try {
            EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
            return bayeux == null ? "cometd" : bayeux.getCometdContextName();
        }
        catch (Exception exception) {
            return cometdContextName;
        }
    }

    public String getRestContextName() {
        return PortalContainer.getInstance().getRestContextName();
    }
}

