/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.content.service.impl;

import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import org.exoplatform.content.model.ContentData;
import org.exoplatform.content.model.ContentNavigation;
import org.exoplatform.content.service.BaseContentService;
import org.exoplatform.content.service.ContentDAO;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class ContentDAOImpl
extends BaseContentService
implements ContentDAO {
    public static final String USER_TYPE = "user";
    public static final String GROUP_TYPE = "group";
    public static final String PORTAL_TYPE = "portal";
    private static final String NODE_NAME = "contentNavigation.xml";
    private static final String ID = "id";
    private static final String OWNER = "ownerId";
    private static final String DATA_TYPE = "dataType";
    private static final String DATA = "data";
    private static final String CREATED_DATE = "createdDate";
    private static final String MODIFIED_DATE = "modifiedDate";
    private static final String DATA_NODE_TYPE = "exo:content";
    public static final String APPLICATION_NAME = "ContentService";
    private NodeHierarchyCreator nodeCreator_;

    public ContentDAOImpl(CacheService cservice, NodeHierarchyCreator creator) throws Exception {
        super(cservice);
        this.nodeCreator_ = creator;
    }

    private Node createNode(Node parent, String name) throws Exception {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        Node node = parent.addNode(name);
        if (parent.isNew()) {
            parent.getSession().save();
        } else {
            parent.save();
        }
        return node;
    }

    private Node createApplicationNode(SessionProvider sessionProvider, String userName) throws Exception {
        Node userAppsNode = this.nodeCreator_.getUserApplicationNode(sessionProvider, userName);
        Node appNode = this.createNode(userAppsNode, APPLICATION_NAME);
        return appNode;
    }

    private Node getApplicationNode(SessionProvider sessionProvider, String userName) throws Exception {
        Node userAppsNode = this.nodeCreator_.getUserApplicationNode(sessionProvider, userName);
        if (userAppsNode.hasNode(APPLICATION_NAME)) {
            return userAppsNode.getNode(APPLICATION_NAME);
        }
        return null;
    }

    public void create(ContentNavigation navigation) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node appNode = this.nodeCreator_.getPublicApplicationNode(sessionProvider);
        if (navigation.getOwner() != "anonymous") {
            appNode = this.createApplicationNode(sessionProvider, navigation.getOwner());
        }
        ContentData data = new ContentData();
        data.setDataType(ContentNavigation.class.getName());
        data.setId(navigation.getOwner() + "::" + ContentNavigation.class.getName());
        data.setOwner(navigation.getOwner());
        data.setData(this.toXML(navigation));
        this.saveData(appNode, data);
        sessionProvider.close();
    }

    public void save(ContentNavigation navigation) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node appNode = this.nodeCreator_.getPublicApplicationNode(sessionProvider);
        if (navigation.getOwner() != "anonymous") {
            appNode = this.getApplicationNode(sessionProvider, navigation.getOwner());
        }
        if (appNode == null) {
            sessionProvider.close();
            this.create(navigation);
            return;
        }
        ContentData data = new ContentData();
        data.setDataType(ContentNavigation.class.getName());
        data.setId(navigation.getOwner() + "::" + ContentNavigation.class.getName());
        data.setOwner(navigation.getOwner());
        data.setData(this.toXML(navigation));
        this.saveData(appNode, data);
        sessionProvider.close();
    }

    public ContentNavigation get(String owner) throws Exception {
        ContentData data = this.getDataByOwner(owner);
        if (data == null) {
            return null;
        }
        return (ContentNavigation)this.fromXML(data.getData(), ContentNavigation.class);
    }

    public void remove(String owner) throws Exception {
        this.removeData(owner, NODE_NAME);
    }

    public ContentData getData(String id) throws Exception {
        String owner = id.substring(0, id.indexOf(58));
        return this.getDataByOwner(owner);
    }

    private ContentData getDataByOwner(String owner) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node appNode = this.nodeCreator_.getPublicApplicationNode(sessionProvider);
        if (owner != null) {
            appNode = this.getApplicationNode(sessionProvider, owner);
        }
        if (appNode == null || !appNode.hasNode(NODE_NAME)) {
            sessionProvider.close();
            return null;
        }
        Node node = appNode.getNode(NODE_NAME);
        ContentData contentData = this.nodeToContentData(node);
        sessionProvider.close();
        return contentData;
    }

    public void removeData(String id) throws Exception {
        this.removeDataByOwner(id.substring(0, id.indexOf(58)));
    }

    public void removeData(String owner, String type) throws Exception {
        this.removeDataByOwner(owner);
    }

    private void removeDataByOwner(String owner) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node appNode = this.getApplicationNode(sessionProvider, owner);
        if (!appNode.hasNode(NODE_NAME)) {
            sessionProvider.close();
            return;
        }
        Node node = appNode.getNode(NODE_NAME);
        node.remove();
        appNode.save();
        sessionProvider.close();
    }

    private void saveData(Node parentNode, ContentData data) throws Exception {
        Date time = Calendar.getInstance().getTime();
        data.setModifiedDate(time);
        if (data.getCreatedDate() == null) {
            data.setCreatedDate(time);
        }
        if (parentNode.hasNode(NODE_NAME)) {
            Node node = parentNode.getNode(NODE_NAME);
            this.contentDataToNode(data, node);
            node.save();
        } else {
            Node node = parentNode.addNode(NODE_NAME, DATA_NODE_TYPE);
            this.contentDataToNode(data, node);
            parentNode.save();
        }
    }

    private ContentData nodeToContentData(Node node) throws Exception {
        ContentData data = new ContentData();
        if (!node.hasProperty(ID)) {
            return null;
        }
        data.setId(node.getProperty(ID).getString());
        if (!node.hasProperty(OWNER)) {
            return null;
        }
        data.setOwner(node.getProperty(OWNER).getString());
        data.setDataType(node.getProperty(DATA_TYPE).getString());
        data.setData(node.getProperty(DATA).getString());
        data.setCreatedDate(node.getProperty(CREATED_DATE).getDate().getTime());
        data.setModifiedDate(node.getProperty(MODIFIED_DATE).getDate().getTime());
        return data;
    }

    private void contentDataToNode(ContentData data, Node node) throws Exception {
        node.setProperty(ID, data.getId());
        node.setProperty(OWNER, data.getOwner());
        node.setProperty("ownerType", USER_TYPE);
        node.setProperty(DATA_TYPE, data.getDataType());
        node.setProperty(DATA, data.getData());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data.getCreatedDate());
        node.setProperty(CREATED_DATE, calendar);
        calendar = Calendar.getInstance();
        calendar.setTime(data.getModifiedDate());
        node.setProperty(MODIFIED_DATE, calendar);
    }
}

