/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.content.service;

import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.content.model.ContentItem;
import org.exoplatform.content.model.ContentNode;
import org.exoplatform.content.service.ContentPageList;
import org.exoplatform.content.service.ContentPlugin;
import org.exoplatform.services.rss.parser.DefaultRSSChannel;
import org.exoplatform.services.rss.parser.DefaultRSSItem;
import org.exoplatform.services.rss.parser.RSSDocument;
import org.exoplatform.services.rss.parser.RSSParser;
import org.w3c.dom.Document;

public class RSSContentPlugin
extends ContentPlugin {
    private RSSParser service_;

    public RSSContentPlugin(RSSParser service) {
        this.type = "rss";
        this.service_ = service;
    }

    public PageList loadContentMeta(ContentNode node) throws Exception {
        DocumentBuilder docbuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docbuilder.parse(node.getUrl());
        String encode = doc.getXmlEncoding();
        if (encode == null || encode.trim().length() == 0) {
            encode = "utf-8";
        }
        URL uri = new URL(node.getUrl());
        RSSDocument document = this.service_.createDocument(uri, encode, DefaultRSSChannel.class, RSSItem.class);
        List list = document.getItems();
        return new ContentPageList(list);
    }

    public static class RSSItem
    extends DefaultRSSItem
    implements ContentItem {
        public void setCreator(String creator) {
            super.setCreator(creator);
        }

        public String getCreator() {
            return super.getCreator();
        }
    }
}

