/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Account {
    private String id = Utils.KEY_ACCOUNT + IdGenerator.generate();
    private String label;
    private String userDisplayName;
    private String emailAddress;
    private String emailReplyAddress;
    private String signature;
    private String description;
    private boolean checkedAuto_;
    private boolean emptyTrashWhenExit;
    private boolean isSavePassword_;
    private String placeSignature;
    private Date lastCheckedDate_;
    private Date lastStartCheckingTime_;
    private boolean checkAll_ = false;
    private Date checkFromDate_;
    private Map<String, String> serverProperties;
    private Map<String, String> popServerProperties;
    private Map<String, String> imapServerProperties;

    public Account() {
        this.setPopServerProperty(Utils.SVR_POP_LEAVE_ON_SERVER, "true");
        this.setImapServerProperty(Utils.SVR_IMAP_MARK_AS_DELETE, "false");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String s) {
        this.signature = s;
    }

    public String getEmailReplyAddress() {
        return this.emailReplyAddress;
    }

    public void setEmailReplyAddress(String s) {
        this.emailReplyAddress = s;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String s) {
        this.emailAddress = s;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String s) {
        this.userDisplayName = s;
    }

    public boolean checkedAuto() {
        return this.checkedAuto_;
    }

    public void setCheckedAuto(boolean checkedAuto) {
        this.checkedAuto_ = checkedAuto;
    }

    public boolean isSavePassword() {
        return this.isSavePassword_;
    }

    public void setIsSavePassword(boolean isSavePassword) {
        this.isSavePassword_ = isSavePassword;
    }

    public boolean isEmptyTrashWhenExit() {
        return this.emptyTrashWhenExit;
    }

    public void setEmptyTrashWhenExit(boolean bool) {
        this.emptyTrashWhenExit = bool;
    }

    public String getPlaceSignature() {
        return this.placeSignature;
    }

    public void setPlaceSignature(String placeSig) {
        this.placeSignature = placeSig;
    }

    public Date getLastCheckedDate() {
        return this.lastCheckedDate_;
    }

    public void setLastCheckedDate(Date date) {
        this.lastCheckedDate_ = date;
    }

    public Date getLastStartCheckingTime() {
        return this.lastStartCheckingTime_;
    }

    public void setLastStartCheckingTime(Date date) {
        this.lastStartCheckingTime_ = date;
    }

    public boolean isCheckAll() {
        return this.checkAll_;
    }

    public void setCheckAll(boolean b) {
        this.checkAll_ = b;
    }

    public Date getCheckFromDate() {
        return this.checkFromDate_;
    }

    public void setCheckFromDate(Date date) {
        this.checkFromDate_ = date;
    }

    public Folder getFolderByName(String name) {
        return null;
    }

    public void setServerProperty(String key, String value) {
        if (this.serverProperties == null) {
            this.serverProperties = new HashMap<String, String>();
        }
        this.serverProperties.put(key, value);
    }

    public Map<String, String> getServerProperties() {
        return this.serverProperties;
    }

    public String getProtocol() {
        return this.serverProperties.get(Utils.SVR_PROTOCOL);
    }

    public void setProtocol(String protocol) {
        this.setServerProperty(Utils.SVR_PROTOCOL, protocol);
    }

    public String getIncomingHost() {
        return this.serverProperties.get(Utils.SVR_INCOMING_HOST);
    }

    public void setIncomingHost(String host) {
        this.setServerProperty(Utils.SVR_INCOMING_HOST, host);
    }

    public String getIncomingPort() {
        return this.serverProperties.get(Utils.SVR_INCOMING_PORT);
    }

    public void setIncomingPort(String port) {
        this.setServerProperty(Utils.SVR_INCOMING_PORT, port);
    }

    public String getOutgoingHost() {
        return this.serverProperties.get(Utils.SVR_OUTGOING_HOST);
    }

    public void setOutgoingHost(String host) {
        this.setServerProperty(Utils.SVR_OUTGOING_HOST, host);
    }

    public String getOutgoingPort() {
        return this.serverProperties.get(Utils.SVR_OUTGOING_PORT);
    }

    public void setOutgoingPort(String port) {
        this.setServerProperty(Utils.SVR_OUTGOING_PORT, port);
    }

    public String getIncomingFolder() {
        return this.serverProperties.get(Utils.SVR_INCOMING_FOLDER);
    }

    public void setIncomingFolder(String folder) {
        this.setServerProperty(Utils.SVR_INCOMING_FOLDER, folder);
    }

    public String getIncomingUser() {
        return this.serverProperties.get(Utils.SVR_INCOMING_USERNAME);
    }

    public void setIncomingUser(String user) {
        this.setServerProperty(Utils.SVR_INCOMING_USERNAME, user);
    }

    public String getIncomingPassword() {
        return this.serverProperties.get(Utils.SVR_INCOMING_PASSWORD);
    }

    public void setIncomingPassword(String password) {
        this.setServerProperty(Utils.SVR_INCOMING_PASSWORD, password);
    }

    public boolean isIncomingSsl() {
        return this.serverProperties.get(Utils.SVR_INCOMING_SSL).equalsIgnoreCase("true");
    }

    public void setIncomingSsl(boolean b) {
        this.setServerProperty(Utils.SVR_INCOMING_SSL, String.valueOf(b));
    }

    public boolean isOutgoingSsl() {
        return this.serverProperties.get(Utils.SVR_OUTGOING_SSL).equalsIgnoreCase("true");
    }

    public void setOutgoingSsl(boolean b) {
        this.setServerProperty(Utils.SVR_OUTGOING_SSL, String.valueOf(b));
    }

    public void setPopServerProperty(String key, String value) {
        if (this.popServerProperties == null) {
            this.popServerProperties = new HashMap<String, String>();
        }
        this.popServerProperties.put(key, value);
    }

    public Map<String, String> getPopServerProperties() {
        return this.popServerProperties;
    }

    public void setImapServerProperty(String key, String value) {
        if (this.imapServerProperties == null) {
            this.imapServerProperties = new HashMap<String, String>();
        }
        this.imapServerProperties.put(key, value);
    }

    public Map<String, String> getImapServerProperties() {
        return this.imapServerProperties;
    }
}

