/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationLogoutListener
extends Listener<ConversationRegistry, ConversationState> {
    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer("portal");
        }
        MailService mService = (MailService)container.getComponentInstanceOfType(MailService.class);
        String username = ((ConversationState)event.getData()).getIdentity().getUserId();
        List<Account> accList = mService.getAccounts(SessionProvider.createSystemProvider(), username);
        for (Account acc : accList) {
            mService.stopCheckMail(username, acc.getId());
        }
    }
}

