/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.connection.impl;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.mail.connection.impl.BaseConnector;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapConnector
extends BaseConnector {
    private static final Log logger = LogFactory.getLog(Utils.class);
    private Account account_;

    public ImapConnector(Account account, SSLSocketFactory sslSocketFact) throws Exception {
        Session session = this.getSession(account, sslSocketFact);
        String protocolName = "imap";
        String emailaddr = account.getIncomingUser();
        if (Utils.isGmailAccount(emailaddr)) {
            protocolName = "imaps";
        }
        IMAPStore imapStore = (IMAPStore)session.getStore(protocolName);
        this.store_ = imapStore;
        this.account_ = account;
        this.store_.connect(this.account_.getIncomingHost(), Integer.valueOf(this.account_.getIncomingPort()).intValue(), this.account_.getIncomingUser(), this.account_.getIncomingPassword());
    }

    public Store getStore() {
        return this.store_;
    }

    @Override
    public void openStore(Account account) throws Exception {
    }

    private Session getSession(Account account, SSLSocketFactory sslSocketFact) throws Exception {
        Properties props = System.getProperties();
        String socketFactoryClass = Utils.SOCKET_FACTORY;
        String propSocketFactory = "mail.imap.socketFactory.class";
        if (account.isIncomingSsl()) {
            props.put("mail.imap.ssl.enable", (Object)true);
            propSocketFactory = "mail.imap.ssl.socketFactory.class";
            socketFactoryClass = "org.exoplatform.mail.service.impl.ExoMailSSLSocketFactory";
            props.put("mail.imap.socketFactory.fallback", (Object)false);
            props.put("mail.imap.ssl.socketFactory", sslSocketFact);
        }
        props.put(propSocketFactory, socketFactoryClass);
        props.put("mail.mime.base64.ignoreerrors", "true");
        return Session.getInstance((Properties)props, null);
    }

    @Override
    public javax.mail.Folder createFolder(Folder folder) throws Exception {
        return this.createFolder(null, folder);
    }

    @Override
    public javax.mail.Folder createFolder(Folder parentFolder, Folder folder) throws Exception {
        IMAPFolder imapFolder = null;
        if (parentFolder == null) {
            imapFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(folder.getName());
            if (!imapFolder.exists()) {
                imapFolder.create((int)folder.getType());
            }
        } else {
            URLName url = new URLName(parentFolder.getURLName());
            IMAPFolder parentImapFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (parentImapFolder != null && parentImapFolder.exists()) {
                boolean isOpen = parentImapFolder.isOpen();
                if (!isOpen) {
                    parentImapFolder.open(2);
                }
                if (!(imapFolder = (IMAPFolder)parentImapFolder.getFolder(folder.getName())).exists()) {
                    imapFolder.create((int)folder.getType());
                }
                parentImapFolder.close(true);
            }
        }
        return imapFolder;
    }

    @Override
    public Folder renameFolder(String newName, Folder folder) throws Exception {
        try {
            boolean result = false;
            URLName url = new URLName(folder.getURLName());
            IMAPFolder folderToBeRenamed = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (folderToBeRenamed.exists()) {
                if (folderToBeRenamed.isOpen()) {
                    folderToBeRenamed.close(false);
                }
                IMAPFolder f1 = (IMAPFolder)((IMAPStore)this.store_).getFolder(newName);
                result = folderToBeRenamed.renameTo((javax.mail.Folder)f1);
                folder.setURLName(f1.getURLName().toString());
                folder.setName(newName);
                if (!result) {
                    logger.info((Object)"Error while renaming folder!");
                }
            } else {
                logger.info((Object)"Folder does not exists!");
            }
            return folder;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public int emptyFolder(Folder folder) throws Exception {
        IMAPFolder folderToEmpty = (IMAPFolder)((IMAPStore)this.store_).getFolder(folder.getName());
        javax.mail.Message[] messages = folderToEmpty.getMessagesByUID(0L, -1L);
        int messageCount = messages.length;
        for (int i = 0; i < messageCount; ++i) {
            messages[i].setFlag(Flags.Flag.DELETED, true);
        }
        folderToEmpty.close(true);
        return messageCount;
    }

    @Override
    public boolean deleteFolder(Folder folder) throws Exception {
        try {
            boolean result = false;
            URLName url = new URLName(folder.getURLName());
            IMAPFolder folderToBeRemoved = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (folderToBeRemoved.exists()) {
                if (folderToBeRemoved.isOpen()) {
                    folderToBeRemoved.close(true);
                }
                if (!(result = folderToBeRemoved.delete(true))) {
                    logger.info((Object)"Error while deleting folder!");
                }
            } else {
                logger.info((Object)"Folder does not exists!");
            }
            return result;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public List<Message> createMessage(List<Message> msgs, Folder folder) throws Exception {
        URLName remoteURL;
        IMAPFolder remoteFolder;
        ArrayList<Message> successList;
        block24: {
            if (msgs == null || msgs.size() == 0 || folder == null) {
                return null;
            }
            successList = new ArrayList<Message>();
            remoteFolder = null;
            remoteURL = null;
            try {
                if (folder.getURLName().equals("") && !Utils.isEmptyField(folder.getName())) {
                    remoteFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(folder.getName());
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block24;
                logger.debug((Object)"Cannot get folder on server by folder name.", (Throwable)e);
            }
        }
        try {
            if (remoteFolder == null) {
                remoteURL = new URLName(folder.getURLName());
                remoteFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(remoteURL);
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cannot get folder by a empty URL name.", (Throwable)e);
            }
            remoteFolder = (IMAPFolder)this.createFolder(folder);
        }
        try {
            if (remoteFolder != null && !remoteFolder.isOpen()) {
                remoteFolder.open(2);
            } else if (remoteFolder == null) {
                return null;
            }
        }
        catch (Exception e) {
            logger.info((Object)("Cannot open \"" + folder.getName() + "\" folder. It will be created on server."));
            remoteFolder = (IMAPFolder)this.createFolder(folder);
            remoteFolder.open(2);
        }
        Properties props = System.getProperties();
        Session session = Session.getInstance((Properties)props, null);
        javax.mail.Message[] messages = new javax.mail.Message[msgs.size()];
        javax.mail.Message[] createdMsgs = null;
        for (int i = 0; i < msgs.size(); ++i) {
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage = Utils.mergeToMimeMessage(msgs.get(i), mimeMessage);
            messages[i] = mimeMessage;
        }
        if (remoteFolder.isOpen()) {
            try {
                createdMsgs = remoteFolder.addMessages(messages);
            }
            catch (MessagingException me) {
                logger.error((Object)"Synchronize message from local to server fail.\n", (Throwable)me);
            }
            if (createdMsgs != null && createdMsgs.length > 0 && createdMsgs.length == msgs.size()) {
                String uid = "";
                for (int l = 0; l < createdMsgs.length; ++l) {
                    if (createdMsgs[l] != null) {
                        block25: {
                            try {
                                uid = String.valueOf(remoteFolder.getUID(createdMsgs[l]));
                            }
                            catch (MessagingException me) {
                                if (!logger.isDebugEnabled()) break block25;
                                logger.debug((Object)("Not found UID for \"" + createdMsgs[l].getSubject() + "\"."), (Throwable)me);
                            }
                        }
                        if (Utils.isEmptyField(uid)) {
                            uid = MimeMessageParser.getMsgUID();
                        }
                        msgs.get(l).setId(MimeMessageParser.getMessageId(createdMsgs[l]));
                        msgs.get(l).setUID(uid);
                    }
                    successList.add(msgs.get(l));
                }
                remoteFolder.close(true);
            } else {
                logger.warn((Object)"Not all messages are synchronized with server.");
            }
        }
        return successList;
    }

    @Override
    public boolean deleteMessage(List<Message> msgs, Folder folder) throws Exception {
        try {
            URLName url = new URLName(folder.getURLName());
            IMAPFolder inFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            boolean isOpen = inFolder.isOpen();
            if (!isOpen) {
                inFolder.open(2);
            }
            for (Message msg : msgs) {
                javax.mail.Message message = inFolder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                message.setFlag(Flags.Flag.DELETED, true);
            }
            inFolder.close(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<Message> moveMessage(List<Message> msgs, Folder sourceFolder, Folder desFolder) throws Exception {
        if (!sourceFolder.isPersonalFolder() && !sourceFolder.getName().equalsIgnoreCase(Utils.FD_INBOX) && desFolder.isPersonalFolder()) {
            return this.moveMessages(msgs, sourceFolder, desFolder, true, true);
        }
        if (!(sourceFolder.isPersonalFolder() || sourceFolder.getName().equalsIgnoreCase(Utils.FD_INBOX) || desFolder.isPersonalFolder())) {
            return this.moveMessages(msgs, sourceFolder, desFolder, true, false);
        }
        if (sourceFolder.isPersonalFolder() && !desFolder.getName().equalsIgnoreCase(Utils.FD_INBOX) && !desFolder.isPersonalFolder() || sourceFolder.getName().equalsIgnoreCase(Utils.FD_INBOX) && !desFolder.getName().equalsIgnoreCase(Utils.FD_INBOX) && !desFolder.isPersonalFolder()) {
            return this.moveMessages(msgs, sourceFolder, desFolder, false, false);
        }
        if (sourceFolder.isPersonalFolder() && desFolder.isPersonalFolder() || sourceFolder.getName().equalsIgnoreCase(Utils.FD_INBOX) && desFolder.isPersonalFolder() || desFolder.getName().equalsIgnoreCase(Utils.FD_INBOX) && sourceFolder.isPersonalFolder()) {
            return this.moveMessages(msgs, sourceFolder, desFolder, false, true);
        }
        return null;
    }

    private List<Message> moveMessages(List<Message> msgs, Folder sourceFolder, Folder desFolder, boolean isLocalFolder, boolean isRemoteFolder) throws Exception {
        block22: {
            if (msgs == null || msgs.size() == 0) {
                return null;
            }
            IMAPFolder sourceImapFolder = null;
            IMAPFolder desImapFolder = null;
            try {
                block21: {
                    URLName srcURL;
                    if (isLocalFolder && isRemoteFolder) {
                        sourceImapFolder = (IMAPFolder)this.createFolder(sourceFolder);
                        URLName desURL = new URLName(desFolder.getURLName());
                        desImapFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(desURL);
                    } else if (isLocalFolder && !isRemoteFolder) {
                        sourceImapFolder = (IMAPFolder)this.createFolder(sourceFolder);
                        desImapFolder = (IMAPFolder)this.createFolder(desFolder);
                    } else if (!isLocalFolder && isRemoteFolder) {
                        srcURL = new URLName(sourceFolder.getURLName());
                        sourceImapFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(srcURL);
                        URLName desURL = new URLName(desFolder.getURLName());
                        desImapFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(desURL);
                    } else if (!isLocalFolder && !isRemoteFolder) {
                        srcURL = new URLName(sourceFolder.getURLName());
                        sourceImapFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(srcURL);
                        desImapFolder = (IMAPFolder)this.createFolder(desFolder);
                    }
                    if (sourceImapFolder == null || desImapFolder == null) {
                        return null;
                    }
                    try {
                        if (!sourceImapFolder.isOpen()) {
                            sourceImapFolder.open(2);
                        }
                        if (!desImapFolder.isOpen()) {
                            desImapFolder.open(2);
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block21;
                        logger.debug((Object)("ImapConnector: \"" + sourceFolder + "\" or \"" + desFolder + "\" folder was not synchronized with server\n"), (Throwable)e);
                    }
                }
                if (!sourceImapFolder.isOpen() || !desImapFolder.isOpen()) break block22;
                ArrayList<javax.mail.Message> copiedMsgs = new ArrayList<javax.mail.Message>();
                javax.mail.Message msg = null;
                for (Message m : msgs) {
                    try {
                        if (m != null && m.getUID() != null) {
                            msg = sourceImapFolder.getMessageByUID(Long.valueOf(m.getUID()).longValue());
                        } else {
                            logger.info((Object)"Message is null or UID is null.");
                        }
                    }
                    catch (Exception e) {
                        logger.info((Object)("The UID: \"" + m.getUID() + "\" of message: \"" + m.getSubject() + "\" is not exist on server mail\n"));
                    }
                    if (msg == null) continue;
                    copiedMsgs.add(msg);
                }
                if (copiedMsgs != null && copiedMsgs.size() > 0) {
                    javax.mail.Message[] messages = copiedMsgs.toArray(new javax.mail.Message[copiedMsgs.size()]);
                    sourceImapFolder.copyMessages(messages, (javax.mail.Folder)desImapFolder);
                    Flags flags = new Flags();
                    flags.add(Flags.Flag.DELETED);
                    sourceImapFolder.setFlags(messages, flags, true);
                    sourceImapFolder.expunge();
                    desImapFolder.expunge();
                }
                sourceImapFolder.close(true);
                desImapFolder.close(true);
            }
            catch (Exception e) {
                logger.error((Object)"ImapConnector: Error in move message.\n", (Throwable)e);
            }
        }
        return msgs;
    }

    @Override
    public boolean markAsRead(List<Message> msgList, Folder f) throws Exception {
        try {
            URLName url = new URLName(f.getURLName());
            IMAPFolder folder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (!folder.isOpen()) {
                folder.open(2);
            }
            for (Message msg : msgList) {
                javax.mail.Message message = folder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                message.setFlag(Flags.Flag.SEEN, true);
            }
            folder.close(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean markAsUnread(List<Message> msgList, Folder f) throws Exception {
        try {
            URLName url = new URLName(f.getURLName());
            IMAPFolder folder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (!folder.isOpen()) {
                folder.open(2);
            }
            for (Message msg : msgList) {
                javax.mail.Message message = folder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                message.setFlag(Flags.Flag.SEEN, false);
            }
            folder.close(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setIsStared(List<Message> msgList, boolean isStared, Folder f) throws Exception {
        try {
            URLName url = new URLName(f.getURLName());
            IMAPFolder folder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (!folder.isOpen()) {
                folder.open(2);
            }
            for (Message msg : msgList) {
                javax.mail.Message message = folder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                message.setFlag(Flags.Flag.FLAGGED, isStared);
            }
            folder.close(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

