/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.JCRMessageAttachment;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSettingConfig;
import org.exoplatform.mail.service.Message;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.gatein.common.util.ParameterValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Log logger = ExoLogger.getLogger((String)"cs.mail.service");
    public static MailService mailService_;
    public static JobSchedulerService schedulerService_;
    public static final String SVR_MAIL = "mail";
    public static final String SVR_IMAP = "imap";
    public static final String SVR_IMAPS = "imaps";
    public static final String IMAP_SSL_FACTORY;
    public static final String SVR_IMAP_STARTTLS_REQUIRED;
    public static final String MAIL_IMAP_SSL_ENABLE;
    public static final String IMAP_CONECT_TIMEOUT;
    public static final String IMAP_SSL_STARTTLS_ENABLE;
    public static final String IMAP_SASL_MECHS;
    public static final String POP3_SSL_STARTTLS_ENABLE;
    public static final String SVR_POP3 = "pop3";
    public static final String SVR_POP3S = "pop3s";
    public static final String POP3_SSL_FACTORY;
    public static final String SVR_POP3_STARTTLS_REQUIRED;
    public static final String MAIL_POP3_SSL_ENABLE;
    public static final String POP3_CONECT_TIMEOUT;
    public static final String NULL = "null";
    public static final String IMAP_MSX_PARTIAL_FETCH;
    public static final String SVR_SMTP = "smtp";
    public static final String SVR_SMTPS = "smtps";
    public static final String SVR_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String SVR_SMTP_HOST;
    public static final String SVR_SMTP_PORT;
    public static final String SVR_SMTP_USER;
    public static final String SVR_SMTP_PASSWORD;
    public static final String SVR_SMTP_AUTH;
    public static final String SVR_SMTP_SOCKET_FACTORY_FALLBACK;
    public static final String SVR_SMTP_SOCKET_FACTORY_PORT;
    public static final String SVR_SMTP_SOCKET_FACTORY_CLASS;
    public static final String SVR_SMTP_SSL_SOCKET_FACTORY_CLASS = "ssl.socketFactory.class";
    public static final String SVR_SMTP_SSL_SOCKET_FACTORY_PORT = "ssl.socketFactory.port";
    public static final String SVR_SMTP_STARTTLS_REQUIRED;
    public static final String SMTP_SSL_FACTORY;
    public static final String SVR_SMTP_SSL_ENABLE;
    public static final String SMTP_QUIT_WAIT;
    public static final String SMTP_SSL_PROTOCOLS;
    public static final String SMTP_CONECT_TIMEOUT;
    public static final String SVR_MAIL_SMTP_DEBUG;
    public static final String SMTP_ISAUTHENTICATION;
    public static final String SMTP_USEINCOMINGSETTING;
    public static final String SMTP_DNS_NOTIFY;
    public static final String SMTP_DNS_RET;
    public static final String SMTP_TIMEOUT = "timeout";
    public static final String SMATP_SSL_STARTTLS_ENABLE;
    public static final String SMTP_AUTH_MECHS;
    public static final String SSL_FACTORY;
    public static final String SVR_SSL_CLASSNAME;
    public static final String SOCKET_FACTORY;
    public static final String SVR_MAIL_DEBUG;
    public static final String SVR_SMTP_STARTTLS_ENABLE;
    public static final String SVR_PROTOCOL;
    public static final String SVR_INCOMING_HOST;
    public static final String SVR_INCOMING_PORT;
    public static final String SVR_INCOMING_FOLDER;
    public static final String SVR_IS_CUSTOM_INBOX;
    public static final String SVR_INCOMING_USERNAME;
    public static final String SVR_INCOMING_PASSWORD;
    public static final String SVR_OUTGOING_HOST;
    public static final String SVR_OUTGOING_PORT;
    public static final String SVR_OUTGOING_USERNAME;
    public static final String SVR_OUTGOING_PASSWORD;
    public static final String SVR_INCOMING_SSL;
    public static final String SVR_OUTGOING_SSL;
    public static final String SVR_LEAVE_ON_SERVER;
    public static final String SVR_POP_SKIP_OVER_SIZE;
    public static final String KEY_FOLDERS;
    public static final String KEY_MESSAGE;
    public static final String KEY_TAGS;
    public static final String KEY_FILTER;
    public static final String KEY_MAIL_SETTING;
    public static final String KEY_SPAM_FILTER;
    public static final String KEY_ACCOUNT;
    public static final String KEY_HEADER;
    public static final String KEY_CONVERSATION;
    public static final String KEY_ATTACHMENT;
    public static final String EXO_ACCOUNT;
    public static final String EXO_ID;
    public static final String EXO_UID;
    public static final String EXO_IN_REPLY_TO_HEADER;
    public static final String EXO_LABEL;
    public static final String EXO_USERDISPLAYNAME;
    public static final String EXO_EMAILADDRESS;
    public static final String EXO_REPLYEMAIL;
    public static final String EXO_SIGNATURE;
    public static final String EXO_DESCRIPTION;
    public static final String EXO_FROM;
    public static final String EXO_FROMS;
    public static final String EXO_TO;
    public static final String EXO_SUBJECT;
    public static final String EXO_CONTENT_TYPE;
    public static final String EXO_REPLYTO;
    public static final String EXO_CC;
    public static final String EXO_BCC;
    public static final String EXO_BODY;
    public static final String EXO_SIZE;
    public static final String EXO_STAR;
    public static final String EXO_PRIORITY;
    public static final String EXO_HASATTACH;
    public static final String IS_LOADED;
    public static final String ATT_IS_LOADED_PROPERLY;
    public static final String ATT_IS_SHOWN_IN_BODY;
    public static final String IS_RETURN_RECEIPT;
    public static final String EXO_TAGS;
    public static final String MSG_FOLDERS;
    public static final String MSG_HEADERS;
    public static final String EXO_PERSONAL;
    public static final String EXO_RECEIVEDDATE;
    public static final String EXO_SENDDATE;
    public static final String EXO_SERVERPROPERTIES;
    public static final String EXO_SMTPSERVERPROPERTIES;
    public static final String EXO_MESSAGE;
    public static final String EXO_ISUNREAD;
    public static final String EXO_TOTALMESSAGE;
    public static final String EXO_FOLDER;
    public static final String EXO_UNREADMESSAGES;
    public static final String EXO_FOLDERTYPE;
    public static final String EXO_NAME;
    public static final String EXO_MAILTAG;
    public static final String EXO_COLOR;
    public static final String EXO_CHECKMAILAUTO;
    public static final String EXO_EMPTYTRASH;
    public static final String EXO_PLACESIGNATURE;
    public static final String EXO_SPAM_FILTER;
    public static final String EXO_CONVERSATION;
    public static final String EXO_CONVERSATIONID;
    public static final String EXO_LAST_START_CHECKING_TIME;
    public static final String EXO_LAST_CHECKED_TIME;
    public static final String EXO_CHECK_ALL;
    public static final String EXO_CHECK_FROM_DATE;
    public static final String EXO_IS_SAVE_PASSWORD;
    public static final String EXO_MAIL_ATTACHMENT;
    public static final String EXO_ATT_NAME;
    public static final String EXO_IS_ROOT;
    public static final String EXO_LAST_UPDATE_TIME;
    public static final String EXO_SECURE_AUTHS_INCOMING;
    public static final String EXO_SECURE_AUTHS_OUTGOING;
    public static final String EXO_AUTH_MECHS_INCOMING;
    public static final String EXO_AUTH_MECHS_OUTGOING;
    public static final String EXO_MAIL_SETTING;
    public static final String EXO_NUMBER_MSG_PER_PAGE;
    public static final String EXO_FORMAT_AS_ORIGINAL;
    public static final String EXO_REPLY_WITH_ATTACH;
    public static final String EXO_FORWARD_WITH_ATTACH;
    public static final String EXO_PREFIX_MESSAGE_WITH;
    public static final String EXO_PERIOD_CHECKMAIL_AUTO;
    public static final String EXO_DEFAULT_ACCOUNT;
    public static final String EXO_USE_WYSIWYG;
    public static final String EXO_SAVE_SENT_MESSAGE;
    public static final String EXO_FILTER;
    public static final String EXO_PATH;
    public static final String EXO_LAYOUT;
    public static final String EXO_RETURN_RECEIPT;
    public static final String NT_UNSTRUCTURED;
    public static final String NT_FILE;
    public static final String NT_RESOURCE;
    public static final String JCR_LASTMODIFIED;
    public static final String JCR_CONTENT;
    public static final String JCR_MIMETYPE;
    public static final String JCR_DATA;
    public static final String MIMETYPE_TEXTPLAIN;
    public static final String MIMETYPE_TEXTHTML;
    public static final String ATTACHMENT;
    public static final String INLINE;
    public static final String EXO_FROM_CONDITION;
    public static final String EXO_TO_CONDITION;
    public static final String EXO_SUBJECT_CONDITION;
    public static final String EXO_BODY_CONDITION;
    public static final String EXO_APPLY_TAG;
    public static final String EXO_APPLY_FOLDER;
    public static final String EXO_KEEP_IN_INBOX;
    public static final String EXO_APPLY_FOR_ALL;
    public static final int CONDITION_CONTAIN = 0;
    public static final int CONDITION_NOT_CONTAIN = 1;
    public static final int CONDITION_IS = 2;
    public static final int CONDITION_NOT_IS = 3;
    public static final int CONDITION_STARTS_WITH = 4;
    public static final int CONDITION_ENDS_WITH = 5;
    public static final String POP3;
    public static final String IMAP;
    public static final String FD_INBOX;
    public static final String FD_DRAFTS;
    public static final String FD_SENT;
    public static final String FD_SPAM;
    public static final String FD_TRASH;
    public static final String[] DEFAULT_FOLDERS;
    public static final String P_HEAD;
    public static final String P_FOOT;
    public static final String HEADER_IN_REPLY_TO;
    public static final String HEADER_REFERENCES;
    public static final long PRIORITY_HIGH = 1L;
    public static final long PRIORITY_NORMAL = 3L;
    public static final long PRIORITY_LOW = 5L;
    public static final String TAG_RED;
    public static final String TAG_BLUE;
    public static final String TAG_GREEN;
    public static final String TAG_BROWN;
    public static final String TAG_ORANGE;
    public static final String TAG_PING;
    public static final String TAG_PING_VIOLET;
    public static final String TAG_VIOLET;
    public static final String TAG_YELLOW;
    public static final String[] TAG_COLOR;
    public static final String[] MIME_MAIL_TYPES;
    public static final String[] NOT_SUPPORTED_CHARSETS;
    public static final byte NO_MAIL_DUPLICATE = 0;
    public static final byte MAIL_DUPLICATE_IN_SAME_FOLDER = 1;
    public static final byte MAIL_DUPLICATE_IN_OTHER_FOLDER = 2;
    public static final boolean SHOWCONVERSATION = true;
    public static final String TLS_SSL = "ssl/tls";
    public static final String STARTTLS = "starttls";
    public static final String NTLM = "ntlm";
    public static final String PLAIN = "plain";
    public static final String LOGIN = "login";
    public static final String DIGIT_MD5 = "digest-md5";
    public static final String CRAM_MD5 = "cram-md5";
    public static final String KERBEROS_GSSAPI = "kerberos/gssapi";
    public static final String[] MECHANISM;
    public static final String EXO_PERMISSIONS;
    public static final String READ_ONLY;
    public static final String SEND_RECIEVE;
    private static final String SERVICE_SETTINGS_NAME;
    private static final String LEAVE_ON_SEVER;
    private static final String INCOMING_SERVER;
    private static final String OUTGOING_SEVER;
    private static final String INCOMING_SERVER_PORT;
    private static final String OUTGOING_SEVER_PORT;
    private static final String ACCEPT_INCOMING_SECURE_AUTHENTICATION;
    private static final String INCOMING_SECURE_AUTHENTICATION;
    private static final String INCOMING_AUTHENTICATION_MECHANISM;
    private static final String ACCEPT_OUTGOING_SECURE_AUTHENTICATION;
    private static final String OUTGOING_SECURE_AUTHENTICATION;
    private static final String OUTGOING_AUTHENTICATION_MECHANISM;
    private static String PLUS_ENCODE;
    private static String EQUAL_ENCODE;
    private static String AND_ENCODE;

    public static boolean isEmptyField(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean checkConnection(Account acc) throws Exception {
        try {
            String protocol = acc.getProtocol();
            Properties props = System.getProperties();
            String socketFactoryClass = "javax.net.SocketFactory";
            if (acc.isIncomingSsl()) {
                socketFactoryClass = SSL_FACTORY;
            }
            if (protocol.equals(POP3)) {
                props.setProperty("mail.pop3.socketFactory.fallback", "false");
                props.setProperty("mail.pop3.socketFactory.class", socketFactoryClass);
            } else if (protocol.equals(IMAP)) {
                props.setProperty("mail.imap.socketFactory.fallback", "false");
                props.setProperty("mail.imap.socketFactory.class", socketFactoryClass);
            }
            Session session = Session.getInstance((Properties)props, null);
            URLName url = new URLName(acc.getProtocol(), acc.getIncomingHost(), Integer.valueOf(acc.getIncomingPort()).intValue(), null, acc.getIncomingUser(), acc.getIncomingPassword());
            Store store = session.getStore(url);
            store.connect();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isNumber(String number) {
        try {
            Long.parseLong(number.trim());
        }
        catch (Exception nfe) {
            return false;
        }
        return true;
    }

    public static String formatDate(String format, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format((Object)date);
    }

    public static String getPersonal(InternetAddress address) throws Exception {
        String personal = "";
        if (address != null) {
            personal = !Utils.isEmptyField(address.getPersonal()) ? address.getPersonal() : address.getAddress();
        }
        return personal;
    }

    public static String[] getAddresses(String addressList) {
        String[] strs = new String[1];
        try {
            InternetAddress[] internetAddresses = Utils.getInternetAddress(addressList);
            strs = new String[internetAddresses.length];
            for (int i = 0; i < internetAddresses.length; ++i) {
                strs[i] = internetAddresses[i].getAddress();
            }
        }
        catch (Exception e) {
            strs[0] = "";
        }
        return strs;
    }

    public static String[] getAllRecipients(javax.mail.Message msg) throws Exception {
        return Utils.getAddresses(InternetAddress.toString((Address[])msg.getFrom()) + "," + InternetAddress.toString((Address[])msg.getAllRecipients()));
    }

    public static Map<String, String> getAddressMap(String addressList) throws Exception {
        InternetAddress[] internetAddresses = Utils.getInternetAddress(addressList);
        HashMap<String, String> addressMap = new HashMap<String, String>();
        for (int i = 0; i < internetAddresses.length; ++i) {
            String address = internetAddresses[i].getAddress();
            addressMap.put(address, address);
        }
        return addressMap;
    }

    public static InternetAddress[] getInternetAddress(String addressList) throws Exception {
        if (Utils.isEmptyField(addressList)) {
            return new InternetAddress[1];
        }
        try {
            return InternetAddress.parse((String)addressList);
        }
        catch (Exception e) {
            return new InternetAddress[1];
        }
    }

    public static String generateFID(String accountId, String folderName, boolean isPersonal) {
        if (isPersonal) {
            return accountId + "UserFolder" + folderName;
        }
        for (int i = 0; i < DEFAULT_FOLDERS.length; ++i) {
            if (!folderName.equalsIgnoreCase(DEFAULT_FOLDERS[i])) continue;
            return accountId + "DefaultFolder" + DEFAULT_FOLDERS[i];
        }
        return accountId + "DefaultFolder" + folderName;
    }

    public static String getFolderNameFromFolderId(String folderId) {
        int index = -1;
        if (folderId.indexOf("UserFolder") > -1) {
            index = folderId.indexOf("UserFolder") + 10;
        } else if (folderId.indexOf("DefaultFolder") > -1) {
            index = folderId.indexOf("DefaultFolder") + 13;
        }
        if (index > 0) {
            return folderId.substring(index, folderId.length());
        }
        return "";
    }

    public static MimeMessage setHeader(MimeMessage mm, Message message) throws Exception {
        mm.setHeader("X-Priority", String.valueOf(message.getPriority()));
        String priority = "Normal";
        if (message.getPriority() == 1L) {
            priority = "High";
        } else if (message.getPriority() == 5L) {
            priority = "Low";
        }
        if (message.getPriority() != 0L) {
            mm.setHeader("Importance", priority);
        }
        Iterator<String> iter = message.getHeaders().keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            mm.setHeader(key, message.getHeaders().get(key));
        }
        return mm;
    }

    public static MimeMessage mergeToMimeMessage(Message message, MimeMessage mimeMessage) throws Exception {
        List<Attachment> attachList;
        String subject;
        InternetAddress addressFrom = null;
        if (message.getFrom() != null) {
            addressFrom = new InternetAddress(message.getFrom());
        }
        mimeMessage.setFrom(addressFrom);
        if (!StringUtils.isEmpty((String)message.getMessageTo())) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)message.getMessageTo()));
        }
        if (!StringUtils.isEmpty((String)message.getMessageCc())) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)message.getMessageCc(), (boolean)true));
        }
        if (!StringUtils.isEmpty((String)message.getMessageBcc())) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)message.getMessageBcc(), (boolean)false));
        }
        if (!StringUtils.isEmpty((String)message.getReplyTo())) {
            mimeMessage.setReplyTo((Address[])Utils.getInternetAddress(message.getReplyTo()));
        }
        if ((subject = message.getSubject()) == null) {
            subject = "";
        }
        mimeMessage.setSubject(subject);
        mimeMessage.setSentDate(message.getSendDate());
        mimeMessage = Utils.setHeader(mimeMessage, message);
        MimeMultipart mixedPart = new MimeMultipart("mixed");
        MimeMultipart alternativePart = new MimeMultipart("alternative");
        String contentType = "text/plain";
        if (message.getContentType() != null && message.getContentType().toLowerCase().indexOf("text/html") > -1) {
            contentType = "text/html";
        }
        if ((attachList = message.getAttachments()) != null && attachList.size() > 0) {
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            MimeBodyPart textBodyPart = new MimeBodyPart();
            textBodyPart.setContent((Object)Utils.html2text(Utils.decodeHTML(message.getMessageBody())), "text/plain");
            alternativePart.addBodyPart((BodyPart)textBodyPart);
            MimeBodyPart htmlBodyPart = new MimeBodyPart();
            htmlBodyPart.setContent((Object)Utils.text2html(Utils.decodeHTML(message.getMessageBody())), "text/html");
            alternativePart.addBodyPart((BodyPart)htmlBodyPart);
            contentPartRoot.setContent((Multipart)alternativePart);
            mixedPart.addBodyPart((BodyPart)contentPartRoot);
            for (Attachment att : attachList) {
                InputStream is = att.getInputStream();
                MimeBodyPart attachPart = new MimeBodyPart();
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(is, att.getMimeType());
                attachPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
                attachPart.setDisposition("attachment");
                attachPart.setFileName(att.getName());
                mixedPart.addBodyPart((BodyPart)attachPart);
            }
            mimeMessage.setContent((Multipart)mixedPart);
        } else if (message.getContentType() != null && contentType.equals("text/plain")) {
            mimeMessage.setText(Utils.html2text(Utils.decodeHTML(message.getMessageBody())));
        } else {
            mimeMessage.setContent((Object)message.getMessageBody(), "text/html");
        }
        return mimeMessage;
    }

    public static String encodeJCRTextSearch(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static String encodeHTML(String htmlContent) throws Exception {
        return !Utils.isEmptyField(htmlContent) ? htmlContent.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&#39;") : "";
    }

    public static String decodeHTML(String htmlContent) throws Exception {
        return !Utils.isEmptyField(htmlContent) ? htmlContent.replaceAll("&amp;", "&").replaceAll("&quot;", "\"").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&#39;", "'") : "";
    }

    public static String decodeText(String str) throws Exception {
        if (Utils.isEmptyField(str)) {
            return str;
        }
        try {
            String ret = MimeUtility.decodeText((String)str);
            return ret;
        }
        catch (Exception e) {
            logger.error((Object)"decode text error", (Throwable)e);
            return str;
        }
    }

    public static String html2text(String str) throws Exception {
        if (str != null) {
            str = str.replaceAll("<[^>]*>", "");
            str = str.replaceAll("&nbsp;", "");
            str = str.replaceAll("&quot;", "\"");
        } else {
            str = "";
        }
        return str;
    }

    public static String text2html(String str) throws Exception {
        str = str != null ? str.replaceAll("\n", "<br>") : "";
        return str;
    }

    public static void setMailService(MailService mailService) {
        mailService_ = mailService;
    }

    public static void setScheduleService(JobSchedulerService schedulerService) {
        schedulerService_ = schedulerService;
    }

    public static MailService getMailService() {
        return mailService_;
    }

    public static JobSchedulerService getJobSchedulerService() {
        return schedulerService_;
    }

    public static String convertSize(long size) throws Exception {
        String str = "";
        DecimalFormat df = new DecimalFormat("0.00");
        str = size > 0x100000L ? str + df.format((double)size / 1048576.0) + " MB" : (size > 1024L ? str + df.format((double)size / 1024.0) + " KB" : str + size + " B");
        return str;
    }

    public static ContinuationService getContinuationService() throws Exception {
        ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    public static String escapeIllegalJcrChars(String name) {
        StringBuffer buffer = new StringBuffer(name.length() * 2);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '%' || ch == '/' || ch == ':' || ch == '[' || ch == ']' || ch == '*' || ch == '\'' || ch == '\"' || ch == '|' || ch == '.' && name.length() < 3 || ch == ' ' && (i == 0 || i == name.length() - 1) || ch == '\t' || ch == '\r' || ch == '\n') {
                buffer.append('%');
                buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
                buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String unescapeIllegalJcrChars(String name) {
        StringBuffer buffer = new StringBuffer(name.length());
        int i = name.indexOf(37);
        while (i > -1 && i + 2 < name.length()) {
            buffer.append(name.toCharArray(), 0, i);
            int a = Character.digit(name.charAt(i + 1), 16);
            int b = Character.digit(name.charAt(i + 2), 16);
            if (a > -1 && b > -1) {
                buffer.append((char)(a * 16 + b));
                name = name.substring(i + 3);
            } else {
                buffer.append('%');
                name = name.substring(i + 1);
            }
            i = name.indexOf(37);
        }
        buffer.append(name);
        return buffer.toString();
    }

    public static boolean isGmailAccount(String emailaddr) {
        String suffixEmail;
        return emailaddr != null && emailaddr.length() > 0 && emailaddr.contains("@") && ((suffixEmail = emailaddr.split("@")[1]).equalsIgnoreCase("gmail.com") || suffixEmail.equalsIgnoreCase("google.com"));
    }

    public static long getNumberOfUnreadMessageReally(List<Message> msgList) {
        long numberOfUnread = 0L;
        if (msgList != null && msgList.size() > 0) {
            for (Message msg : msgList) {
                if (!msg.isUnread()) continue;
                ++numberOfUnread;
            }
        }
        return numberOfUnread;
    }

    public static boolean isDelegatedAccount(Account acc, String recieve) {
        return acc != null && acc.getDelegateFrom() != null && recieve != null && !recieve.equalsIgnoreCase(acc.getDelegateFrom());
    }

    public static Message getMessage(Node messageNode) throws Exception {
        int i;
        Message msg = new Message();
        if (messageNode.hasProperty(EXO_ID)) {
            msg.setId(messageNode.getProperty(EXO_ID).getString());
        }
        if (messageNode.hasProperty(EXO_UID)) {
            msg.setUID(messageNode.getProperty(EXO_UID).getString());
        }
        msg.setPath(messageNode.getPath());
        if (messageNode.hasProperty(EXO_IN_REPLY_TO_HEADER)) {
            msg.setInReplyToHeader(messageNode.getProperty(EXO_IN_REPLY_TO_HEADER).getString());
        }
        if (messageNode.hasProperty(EXO_ACCOUNT)) {
            msg.setAccountId(messageNode.getProperty(EXO_ACCOUNT).getString());
        }
        if (messageNode.hasProperty(EXO_FROM)) {
            msg.setFrom(messageNode.getProperty(EXO_FROM).getString());
        }
        if (messageNode.hasProperty(EXO_TO)) {
            msg.setMessageTo(messageNode.getProperty(EXO_TO).getString());
        }
        if (messageNode.hasProperty(EXO_SUBJECT)) {
            msg.setSubject(messageNode.getProperty(EXO_SUBJECT).getString());
        }
        if (messageNode.hasProperty(EXO_CC)) {
            if (NULL.equals(messageNode.getProperty(EXO_CC).getString())) {
                msg.setMessageCc("");
            } else {
                msg.setMessageCc(messageNode.getProperty(EXO_CC).getString());
            }
        }
        if (messageNode.hasProperty(EXO_BCC)) {
            msg.setMessageBcc(messageNode.getProperty(EXO_BCC).getString());
        }
        if (messageNode.hasProperty(EXO_REPLYTO)) {
            msg.setReplyTo(messageNode.getProperty(EXO_REPLYTO).getString());
        }
        if (messageNode.hasProperty(EXO_CONTENT_TYPE)) {
            msg.setContentType(messageNode.getProperty(EXO_CONTENT_TYPE).getString());
        }
        if (messageNode.hasProperty(EXO_BODY)) {
            msg.setMessageBody(messageNode.getProperty(EXO_BODY).getString());
        }
        if (messageNode.hasProperty(EXO_SIZE)) {
            msg.setSize(messageNode.getProperty(EXO_SIZE).getLong());
        }
        if (messageNode.hasProperty(EXO_HASATTACH)) {
            msg.setHasAttachment(messageNode.getProperty(EXO_HASATTACH).getBoolean());
        }
        if (messageNode.hasProperty(ATT_IS_SHOWN_IN_BODY)) {
            msg.setHasAttachment(messageNode.getProperty(ATT_IS_SHOWN_IN_BODY).getBoolean());
        }
        if (messageNode.hasProperty(EXO_STAR)) {
            msg.setHasStar(messageNode.getProperty(EXO_STAR).getBoolean());
        }
        if (messageNode.hasProperty(EXO_PRIORITY)) {
            msg.setPriority(messageNode.getProperty(EXO_PRIORITY).getLong());
        }
        if (messageNode.hasProperty(EXO_ISUNREAD)) {
            msg.setUnread(messageNode.getProperty(EXO_ISUNREAD).getBoolean());
        }
        if (messageNode.hasProperty(MSG_FOLDERS)) {
            Value[] propFolders = messageNode.getProperty(MSG_FOLDERS).getValues();
            String[] folders = new String[propFolders.length];
            for (i = 0; i < propFolders.length; ++i) {
                folders[i] = propFolders[i].getString();
            }
            msg.setFolders(folders);
        }
        if (messageNode.hasProperty(EXO_TAGS)) {
            Value[] propTags = messageNode.getProperty(EXO_TAGS).getValues();
            String[] tags = new String[propTags.length];
            for (i = 0; i < propTags.length; ++i) {
                tags[i] = propTags[i].getString();
            }
            msg.setTags(tags);
        }
        if (messageNode.hasProperty(MSG_HEADERS)) {
            Value[] properties = messageNode.getProperty(MSG_HEADERS).getValues();
            for (int i2 = 0; i2 < properties.length; ++i2) {
                String property = properties[i2].getString();
                int index = property.indexOf(61);
                if (index == -1) continue;
                msg.setHeader(property.substring(0, index), property.substring(index + 1));
            }
        }
        GregorianCalendar cal = new GregorianCalendar();
        if (messageNode.hasProperty(EXO_RECEIVEDDATE)) {
            cal.setTimeInMillis(messageNode.getProperty(EXO_RECEIVEDDATE).getLong());
        }
        msg.setReceivedDate(cal.getTime());
        if (messageNode.hasProperty(EXO_SENDDATE)) {
            cal.setTimeInMillis(messageNode.getProperty(EXO_SENDDATE).getLong());
        }
        msg.setSendDate(cal.getTime());
        if (messageNode.hasProperty(EXO_LAST_CHECKED_TIME)) {
            cal.setTimeInMillis(messageNode.getProperty(EXO_LAST_UPDATE_TIME).getLong());
        }
        msg.setLastUpdateDate(cal.getTime());
        if (messageNode.hasProperty(IS_LOADED)) {
            msg.setIsLoaded(messageNode.getProperty(IS_LOADED).getBoolean());
        }
        if (messageNode.hasProperty(ATT_IS_LOADED_PROPERLY)) {
            msg.setAttIsLoadedProperly(messageNode.getProperty(ATT_IS_LOADED_PROPERLY).getBoolean());
        }
        if (messageNode.hasProperty(IS_RETURN_RECEIPT)) {
            msg.setIsReturnReceipt(messageNode.getProperty(IS_RETURN_RECEIPT).getBoolean());
        }
        return msg;
    }

    public static JCRMessageAttachment getJCRMessageAttachment(Node attactNode) throws Exception {
        JCRMessageAttachment file = new JCRMessageAttachment();
        file.setId(attactNode.getPath());
        file.setMimeType(attactNode.getNode(JCR_CONTENT).getProperty(JCR_MIMETYPE).getString());
        file.setName(attactNode.getProperty(EXO_ATT_NAME).getString());
        if (attactNode.hasNode(ATT_IS_LOADED_PROPERLY)) {
            file.setIsLoadedProperly(attactNode.getProperty(ATT_IS_LOADED_PROPERLY).getBoolean());
        }
        file.setIsShowInBody(attactNode.getProperty(ATT_IS_SHOWN_IN_BODY).getBoolean());
        file.setWorkspace(attactNode.getSession().getWorkspace().getName());
        file.setSize(attactNode.getNode(JCR_CONTENT).getProperty(JCR_DATA).getLength());
        file.setPath("/" + file.getWorkspace() + attactNode.getPath());
        return file;
    }

    private static Map<String, MailSettingConfig> getSettingConfig() {
        MailService mailService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
        return mailService.getSettingConfig().get(SERVICE_SETTINGS_NAME).getMailSettingConfig();
    }

    public static boolean isUserAllowedLeaveOnServer() throws Exception {
        return Utils.getSettingConfig().get(LEAVE_ON_SEVER).getUserAllowed();
    }

    public static String getLeaveOnServer() {
        return Utils.getSettingConfig().get(LEAVE_ON_SEVER).getDefaultValue();
    }

    public static boolean isUserAllowedInconmingServer() throws Exception {
        return Utils.getSettingConfig().get(INCOMING_SERVER).getUserAllowed();
    }

    public static String getIncomingServer() {
        return Utils.getSettingConfig().get(INCOMING_SERVER).getDefaultValue();
    }

    public static boolean isUserAllowedIncomingPort() throws Exception {
        return Utils.getSettingConfig().get(INCOMING_SERVER_PORT).getUserAllowed();
    }

    public static String getIncomingPort() {
        return Utils.getSettingConfig().get(INCOMING_SERVER_PORT).getDefaultValue();
    }

    public static boolean isUserAllowedOutgoingServer() throws Exception {
        return Utils.getSettingConfig().get(OUTGOING_SEVER).getUserAllowed();
    }

    public static String getOutgoingServer() {
        return Utils.getSettingConfig().get(OUTGOING_SEVER).getDefaultValue();
    }

    public static boolean isUserAllowedOutgoingPort() throws Exception {
        return Utils.getSettingConfig().get(OUTGOING_SEVER_PORT).getUserAllowed();
    }

    public static String getOutgoingPort() {
        return Utils.getSettingConfig().get(OUTGOING_SEVER_PORT).getDefaultValue();
    }

    public static boolean isUserAllowedAcceptIncomingSecureAuthentication() throws Exception {
        return Utils.getSettingConfig().get(ACCEPT_INCOMING_SECURE_AUTHENTICATION).getUserAllowed();
    }

    public static String getAcceptIncomingSecureAuthentication() {
        return Utils.getSettingConfig().get(ACCEPT_INCOMING_SECURE_AUTHENTICATION).getDefaultValue();
    }

    public static boolean isUserAllowedIncomingSecureAuthentication() throws Exception {
        return Utils.getSettingConfig().get(INCOMING_SECURE_AUTHENTICATION).getUserAllowed();
    }

    public static String getIncomingSecureAuthentication() {
        return Utils.getSettingConfig().get(INCOMING_SECURE_AUTHENTICATION).getDefaultValue();
    }

    public static boolean isUserAllowedIncomingAuthenticationMechanism() throws Exception {
        return Utils.getSettingConfig().get(INCOMING_AUTHENTICATION_MECHANISM).getUserAllowed();
    }

    public static String getIncomingAuthenticationMechanism() {
        return Utils.getSettingConfig().get(INCOMING_AUTHENTICATION_MECHANISM).getDefaultValue();
    }

    public static boolean isUserAllowedAcceptOutgoingSecureAuthentication() throws Exception {
        return Utils.getSettingConfig().get(ACCEPT_OUTGOING_SECURE_AUTHENTICATION).getUserAllowed();
    }

    public static String getAcceptOutgoingSecureAuthentication() {
        return Utils.getSettingConfig().get(ACCEPT_OUTGOING_SECURE_AUTHENTICATION).getDefaultValue();
    }

    public static boolean isUserAllowedOutgoingSecureAuthentication() throws Exception {
        return Utils.getSettingConfig().get(OUTGOING_SECURE_AUTHENTICATION).getUserAllowed();
    }

    public static String getOutgoingSecureAuthentication() {
        return Utils.getSettingConfig().get(OUTGOING_SECURE_AUTHENTICATION).getDefaultValue();
    }

    public static boolean isUserAllowedOutgoingAuthenticationMechanism() throws Exception {
        return Utils.getSettingConfig().get(OUTGOING_AUTHENTICATION_MECHANISM).getUserAllowed();
    }

    public static String getOutgoingAuthenticationMechanism() {
        return Utils.getSettingConfig().get(OUTGOING_AUTHENTICATION_MECHANISM).getDefaultValue();
    }

    public static String getMailConfigPropertyName(String protocol, String property) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)protocol, (String)"protocol", null);
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)property, (String)"property", null);
        return "mail." + protocol + "." + property;
    }

    public static String encodeMailId(String id) {
        if (id == null) {
            return "";
        }
        return id.replaceAll("\\+", PLUS_ENCODE).replaceAll("=", EQUAL_ENCODE).replaceAll("&", AND_ENCODE);
    }

    public static String decodeMailId(String id) {
        if (id == null) {
            return "";
        }
        return id.replaceAll(PLUS_ENCODE, "+").replaceAll(EQUAL_ENCODE, "=").replaceAll(AND_ENCODE, "&");
    }

    public static SessionProvider createSessionProvider() {
        PortalContainer container = null;
        try {
            container = PortalContainer.getInstance();
        }
        catch (IllegalStateException ie) {
            container = ExoContainerContext.getCurrentContainer();
        }
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        SessionProvider provider = service.getSessionProvider(null);
        if (provider == null) {
            provider = service.getSystemSessionProvider(null);
        }
        return provider;
    }

    public static SessionProvider createSystemProvider() {
        SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
        return sessionProviderService.getSystemSessionProvider(null);
    }

    static {
        IMAP_SSL_FACTORY = "mail.imap.ssl.socketFactory".intern();
        SVR_IMAP_STARTTLS_REQUIRED = "mail.imap.starttls.required".intern();
        MAIL_IMAP_SSL_ENABLE = "mail.imap.ssl.enable".intern();
        IMAP_CONECT_TIMEOUT = "mail.imap.connectiontimeout".intern();
        IMAP_SSL_STARTTLS_ENABLE = "mail.imap.starttls.enable".intern();
        IMAP_SASL_MECHS = "mail.imap.sasl.mechanisms".intern();
        POP3_SSL_STARTTLS_ENABLE = "mail.pop3.starttls.enable".intern();
        POP3_SSL_FACTORY = "mail.pop3.ssl.socketFactory".intern();
        SVR_POP3_STARTTLS_REQUIRED = "mail.pop3.starttls.required".intern();
        MAIL_POP3_SSL_ENABLE = "mail.pop3.ssl.enable".intern();
        POP3_CONECT_TIMEOUT = "mail.pop3.connectiontimeout".intern();
        IMAP_MSX_PARTIAL_FETCH = "mail.imap.partialfetch".intern();
        SVR_SMTP_HOST = "host".intern();
        SVR_SMTP_PORT = "port".intern();
        SVR_SMTP_USER = "user".intern();
        SVR_SMTP_PASSWORD = "user".intern();
        SVR_SMTP_AUTH = "auth".intern();
        SVR_SMTP_SOCKET_FACTORY_FALLBACK = "socketFactory.fallback".intern();
        SVR_SMTP_SOCKET_FACTORY_PORT = "socketFactory.port".intern();
        SVR_SMTP_SOCKET_FACTORY_CLASS = "socketFactory.class".intern();
        SVR_SMTP_STARTTLS_REQUIRED = "starttls.required".intern();
        SMTP_SSL_FACTORY = "ssl.socketFactory".intern();
        SVR_SMTP_SSL_ENABLE = "ssl.enable".intern();
        SMTP_QUIT_WAIT = "quitwait".intern();
        SMTP_SSL_PROTOCOLS = "ssl.protocols".intern();
        SMTP_CONECT_TIMEOUT = "connectiontimeout".intern();
        SVR_MAIL_SMTP_DEBUG = "debug".intern();
        SMTP_ISAUTHENTICATION = "smtp.isauthentication".intern();
        SMTP_USEINCOMINGSETTING = "smtp.useincomingsetting".intern();
        SMTP_DNS_NOTIFY = "dsn.notify".intern();
        SMTP_DNS_RET = "dsn.ret".intern();
        SMATP_SSL_STARTTLS_ENABLE = "starttls.enable".intern();
        SMTP_AUTH_MECHS = "auth.mechanisms".intern();
        SSL_FACTORY = "javax.net.ssl.SSLSocketFactory".intern();
        SVR_SSL_CLASSNAME = "javax.net.ssl.SSLSocketFactory".intern();
        SOCKET_FACTORY = "javax.net.SocketFactory".intern();
        SVR_MAIL_DEBUG = "mail.debug".intern();
        SVR_SMTP_STARTTLS_ENABLE = "starttls.enable".intern();
        SVR_PROTOCOL = "protocol".intern();
        SVR_INCOMING_HOST = "incoming.host".intern();
        SVR_INCOMING_PORT = "incoming.port".intern();
        SVR_INCOMING_FOLDER = "folder".intern();
        SVR_IS_CUSTOM_INBOX = "isCustomInbox".intern();
        SVR_INCOMING_USERNAME = "incoming.username".intern();
        SVR_INCOMING_PASSWORD = "incoming.password".intern();
        SVR_OUTGOING_HOST = "outgoing.host".intern();
        SVR_OUTGOING_PORT = "outgoing.port".intern();
        SVR_OUTGOING_USERNAME = "outgoing.username".intern();
        SVR_OUTGOING_PASSWORD = "outgoing.password".intern();
        SVR_INCOMING_SSL = "ssl".intern();
        SVR_OUTGOING_SSL = "outgoing.ssl".intern();
        SVR_LEAVE_ON_SERVER = "leave.on.server".intern();
        SVR_POP_SKIP_OVER_SIZE = "skip.over.size".intern();
        KEY_FOLDERS = "Folders".intern();
        KEY_MESSAGE = "Messages".intern();
        KEY_TAGS = "Tags".intern();
        KEY_FILTER = "Filter".intern();
        KEY_MAIL_SETTING = "MailSetting".intern();
        KEY_SPAM_FILTER = "SpamFilter".intern();
        KEY_ACCOUNT = "account".intern();
        KEY_HEADER = "mailHeader".intern();
        KEY_CONVERSATION = "Conversation".intern();
        KEY_ATTACHMENT = "attachment".intern();
        EXO_ACCOUNT = "exo:account".intern();
        EXO_ID = "exo:id".intern();
        EXO_UID = "exo:uid".intern();
        EXO_IN_REPLY_TO_HEADER = "exo:inReplyToHeader".intern();
        EXO_LABEL = "exo:label".intern();
        EXO_USERDISPLAYNAME = "exo:userDisplayName".intern();
        EXO_EMAILADDRESS = "exo:emailAddress".intern();
        EXO_REPLYEMAIL = "exo:emailReplyAddress".intern();
        EXO_SIGNATURE = "exo:signature".intern();
        EXO_DESCRIPTION = "exo:description".intern();
        EXO_FROM = "exo:from".intern();
        EXO_FROMS = "exo:froms".intern();
        EXO_TO = "exo:to".intern();
        EXO_SUBJECT = "exo:subject".intern();
        EXO_CONTENT_TYPE = "exo:contentType".intern();
        EXO_REPLYTO = "exo:replyto".intern();
        EXO_CC = "exo:cc".intern();
        EXO_BCC = "exo:bcc".intern();
        EXO_BODY = "exo:body".intern();
        EXO_SIZE = "exo:size".intern();
        EXO_STAR = "exo:star".intern();
        EXO_PRIORITY = "exo:priority".intern();
        EXO_HASATTACH = "exo:hasAttach".intern();
        IS_LOADED = "exo:isLoaded".intern();
        ATT_IS_LOADED_PROPERLY = "exo:isLoadedProperly".intern();
        ATT_IS_SHOWN_IN_BODY = "exo:isShownInBody".intern();
        IS_RETURN_RECEIPT = "exo:isReturnReceipt".intern();
        EXO_TAGS = "exo:tags".intern();
        MSG_FOLDERS = "exo:folders".intern();
        MSG_HEADERS = "exo:headers".intern();
        EXO_PERSONAL = "exo:personal".intern();
        EXO_RECEIVEDDATE = "exo:receivedDate".intern();
        EXO_SENDDATE = "exo:sendDate".intern();
        EXO_SERVERPROPERTIES = "exo:serverProperties".intern();
        EXO_SMTPSERVERPROPERTIES = "exo:smtpServerProperties".intern();
        EXO_MESSAGE = "exo:message".intern();
        EXO_ISUNREAD = "exo:isUnread".intern();
        EXO_TOTALMESSAGE = "exo:totalMessages".intern();
        EXO_FOLDER = "exo:folder".intern();
        EXO_UNREADMESSAGES = "exo:unreadMessages".intern();
        EXO_FOLDERTYPE = "exo:folderType".intern();
        EXO_NAME = "exo:name".intern();
        EXO_MAILTAG = "exo:mailtag".intern();
        EXO_COLOR = "exo:color".intern();
        EXO_CHECKMAILAUTO = "exo:checkMailAuto".intern();
        EXO_EMPTYTRASH = "exo:emptyTrash".intern();
        EXO_PLACESIGNATURE = "exo:placeSignature".intern();
        EXO_SPAM_FILTER = "exo:spamFilter".intern();
        EXO_CONVERSATION = "exo:conversation".intern();
        EXO_CONVERSATIONID = "exo:conversationId".intern();
        EXO_LAST_START_CHECKING_TIME = "exo:lastStartCheckingTime".intern();
        EXO_LAST_CHECKED_TIME = "exo:lastCheckedTime".intern();
        EXO_CHECK_ALL = "exo:checkAll".intern();
        EXO_CHECK_FROM_DATE = "exo:checkFromDate".intern();
        EXO_IS_SAVE_PASSWORD = "exo:isSavePassword".intern();
        EXO_MAIL_ATTACHMENT = "exo:mailAttachment".intern();
        EXO_ATT_NAME = "exo:fileName".intern();
        EXO_IS_ROOT = "exo:isRoot".intern();
        EXO_LAST_UPDATE_TIME = "exo:lastUpdateTime".intern();
        EXO_SECURE_AUTHS_INCOMING = "exo:secureAuthsIncoming".intern();
        EXO_SECURE_AUTHS_OUTGOING = "exo:secureAuthsOutgoing".intern();
        EXO_AUTH_MECHS_INCOMING = "exo:authMechsIncoming".intern();
        EXO_AUTH_MECHS_OUTGOING = "exo:authMechsOutgoing".intern();
        EXO_MAIL_SETTING = "exo:mailSetting".intern();
        EXO_NUMBER_MSG_PER_PAGE = "exo:numberMsgPerPage".intern();
        EXO_FORMAT_AS_ORIGINAL = "exo:formatAsOriginal".intern();
        EXO_REPLY_WITH_ATTACH = "exo:replyWithAttach".intern();
        EXO_FORWARD_WITH_ATTACH = "exo:forwardWithAttach".intern();
        EXO_PREFIX_MESSAGE_WITH = "exo:prefixMsgWith".intern();
        EXO_PERIOD_CHECKMAIL_AUTO = "exo:periodCheckAuto".intern();
        EXO_DEFAULT_ACCOUNT = "exo:defaultAccount".intern();
        EXO_USE_WYSIWYG = "exo:useWysiwyg".intern();
        EXO_SAVE_SENT_MESSAGE = "exo:saveMsgInSent".intern();
        EXO_FILTER = "exo:filter".intern();
        EXO_PATH = "exo:path".intern();
        EXO_LAYOUT = "exo:layout".intern();
        EXO_RETURN_RECEIPT = "exo:returnReceipt".intern();
        NT_UNSTRUCTURED = "nt:unstructured".intern();
        NT_FILE = "nt:file".intern();
        NT_RESOURCE = "nt:resource".intern();
        JCR_LASTMODIFIED = "jcr:lastModified".intern();
        JCR_CONTENT = "jcr:content".intern();
        JCR_MIMETYPE = "jcr:mimeType".intern();
        JCR_DATA = "jcr:data".intern();
        MIMETYPE_TEXTPLAIN = "text/plain".intern();
        MIMETYPE_TEXTHTML = "text/html".intern();
        ATTACHMENT = "ATTACHMENT".intern();
        INLINE = "INLINE".intern();
        EXO_FROM_CONDITION = "exo:fromCondition".intern();
        EXO_TO_CONDITION = "exo:toCondition".intern();
        EXO_SUBJECT_CONDITION = "exo:subjectCondition".intern();
        EXO_BODY_CONDITION = "exo:bodyCondition".intern();
        EXO_APPLY_TAG = "exo:applyTag".intern();
        EXO_APPLY_FOLDER = "exo:applyFolder".intern();
        EXO_KEEP_IN_INBOX = "exo:keepInbox".intern();
        EXO_APPLY_FOR_ALL = "exo:applyForAll".intern();
        POP3 = SVR_POP3.intern();
        IMAP = SVR_IMAP.intern();
        FD_INBOX = "Inbox".intern();
        FD_DRAFTS = "Drafts".intern();
        FD_SENT = "Sent".intern();
        FD_SPAM = "Spam".intern();
        FD_TRASH = "Trash".intern();
        DEFAULT_FOLDERS = new String[]{FD_INBOX, FD_DRAFTS, FD_SENT, FD_SPAM, FD_TRASH};
        P_HEAD = "Head".intern();
        P_FOOT = "Foot".intern();
        HEADER_IN_REPLY_TO = "In-Reply-To".intern();
        HEADER_REFERENCES = "References".intern();
        TAG_RED = "Red".intern();
        TAG_BLUE = "Blue".intern();
        TAG_GREEN = "Green".intern();
        TAG_BROWN = "Brown".intern();
        TAG_ORANGE = "Orange".intern();
        TAG_PING = "Ping".intern();
        TAG_PING_VIOLET = "PingViolet".intern();
        TAG_VIOLET = "Violet".intern();
        TAG_YELLOW = "Yellow".intern();
        TAG_COLOR = new String[]{TAG_RED, TAG_BLUE, TAG_GREEN, TAG_BROWN, TAG_ORANGE, TAG_PING, TAG_YELLOW, TAG_VIOLET};
        MIME_MAIL_TYPES = new String[]{"eml"};
        NOT_SUPPORTED_CHARSETS = new String[]{"koi8-r"};
        MECHANISM = new String[]{NTLM, PLAIN, LOGIN, DIGIT_MD5, KERBEROS_GSSAPI, CRAM_MD5};
        EXO_PERMISSIONS = "exo:permissions".intern();
        READ_ONLY = "read".intern();
        SEND_RECIEVE = "send".intern();
        SERVICE_SETTINGS_NAME = "cs.mail.service.settings".intern();
        LEAVE_ON_SEVER = "leaveOnServer".intern();
        INCOMING_SERVER = "incomingServer".intern();
        OUTGOING_SEVER = "outgoingServer".intern();
        INCOMING_SERVER_PORT = "incomingPort".intern();
        OUTGOING_SEVER_PORT = "outgoingPort".intern();
        ACCEPT_INCOMING_SECURE_AUTHENTICATION = "acceptIncomingSecureAuthentication".intern();
        INCOMING_SECURE_AUTHENTICATION = "incomingSecureAuthentication".intern();
        INCOMING_AUTHENTICATION_MECHANISM = "incomingAuthenticationMechanism".intern();
        ACCEPT_OUTGOING_SECURE_AUTHENTICATION = "acceptOutgoingSecureAuthentication".intern();
        OUTGOING_SECURE_AUTHENTICATION = "outgoingSecureAuthentication".intern();
        OUTGOING_AUTHENTICATION_MECHANISM = "outgoingAuthenticationMechanism".intern();
        PLUS_ENCODE = "PLUS_ENCODE_043";
        EQUAL_ENCODE = "EQUAL_ENCODE_061";
        AND_ENCODE = "AND_ENCODE_038";
    }
}

