/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactGroup;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.webui.SelectItem;
import org.exoplatform.mail.webui.SelectOption;
import org.exoplatform.mail.webui.SelectOptionGroup;
import org.exoplatform.mail.webui.UIFormSelectBoxWithGroups;
import org.exoplatform.mail.webui.popup.UIAddressBookForm;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAddressBookForm.gtmpl", events={@EventConfig(listeners={AddNewGroupActionListener.class}), @EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={EditContactActionListener.class}), @EventConfig(listeners={ChangeGroupActionListener.class}), @EventConfig(listeners={SelectContactActionListener.class}), @EventConfig(listeners={DeleteContactActionListener.class}, confirm="UIAddressBookForm.msg.confirm-remove-contact"), @EventConfig(listeners={CloseActionListener.class})})
public class UIAddressBookForm
extends UIForm
implements UIPopupComponent {
    public static final String ALL_GROUP = "All group".intern();
    public static final String SELECT_GROUP = "select-group".intern();
    private Contact selectedContact;
    LinkedHashMap<String, Contact> contactMap_ = new LinkedHashMap();
    List<Contact> contactList_ = new ArrayList();

    public UIAddressBookForm() throws Exception {
        UIFormSelectBoxWithGroups uiSelectGroup = new UIFormSelectBoxWithGroups(SELECT_GROUP, SELECT_GROUP, this.getOptions());
        uiSelectGroup.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)uiSelectGroup);
        this.refrestContactList((String)uiSelectGroup.getValue());
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public List<SelectItem> getOptions() throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        SelectOptionGroup personalContacts = new SelectOptionGroup("personal-contacts");
        for (ContactGroup pcg : contactSrv.getGroups(SessionProviderFactory.createSystemProvider(), username)) {
            personalContacts.addOption(new SelectOption(pcg.getName(), pcg.getId()));
        }
        options.add((SelectItem)personalContacts);
        return options;
    }

    public Contact getSelectedContact() {
        return this.selectedContact;
    }

    public void setSelectedContact(Contact contact) {
        this.selectedContact = contact;
    }

    public DownloadService getDownloadService() {
        return (DownloadService)this.getApplicationComponent(DownloadService.class);
    }

    public List<Contact> getContacts() throws Exception {
        return this.contactList_;
    }

    public void refrestContactList(String groupId) throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        List contactList = new ArrayList();
        ContactFilter ctFilter = new ContactFilter();
        ctFilter.setOrderBy("fullName");
        ctFilter.setAscending(true);
        if (groupId != null && groupId.trim().length() > 0) {
            ctFilter.setCategories(new String[]{groupId});
            contactList = contactSrv.searchContact(SessionProviderFactory.createSystemProvider(), username, ctFilter).getAll();
        } else {
            ctFilter.setCategories(new String[]{((ContactGroup)contactSrv.getGroups(SessionProviderFactory.createSystemProvider(), username).get(0)).getId()});
            contactList = contactSrv.searchContact(SessionProviderFactory.createSystemProvider(), username, ctFilter).getAll();
        }
        this.contactMap_.clear();
        for (Contact ct : contactList) {
            this.contactMap_.put(ct.getId(), ct);
        }
        this.contactList_ = new ArrayList(this.contactMap_.values());
        this.selectedContact = this.contactList_.size() > 0 ? (Contact)this.contactList_.get(0) : null;
    }

    public void updateGroup(String selectedGroup) throws Exception {
        ((UIFormSelectBoxWithGroups)this.getChildById(SELECT_GROUP)).setOptions(this.getOptions());
        ((UIFormSelectBoxWithGroups)this.getChildById(SELECT_GROUP)).setValue(selectedGroup);
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

