/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetAddress;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.BufferAttachment;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.popup.UIComposeForm;
import org.exoplatform.mail.webui.popup.UIComposeInput;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIComposeForm.gtmpl", events={@EventConfig(listeners={SendActionListener.class}), @EventConfig(listeners={SaveDraftActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={DiscardChangeActionListener.class}), @EventConfig(listeners={AttachmentActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={RemoveAttachmentActionListener.class}), @EventConfig(listeners={ToActionListener.class}), @EventConfig(listeners={ToCCActionListener.class}), @EventConfig(listeners={ToBCCActionListener.class}), @EventConfig(listeners={ChangePriorityActionListener.class}), @EventConfig(listeners={UseVisualEdiorActionListener.class}), @EventConfig(listeners={ShowCcActionListener.class}), @EventConfig(listeners={ShowBccActionListener.class})})
public class UIComposeForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_TO_SET = "toSet".intern();
    public static final String FIELD_FROM = "from";
    public static final String FIELD_SUBJECT = "subject";
    public static final String FIELD_TO = "to";
    public static final String FIELD_CC = "cc";
    public static final String FIELD_BCC = "bcc";
    public static final String FIELD_ATTACHMENTS = "attachments";
    public static final String FIELD_MESSAGECONTENT = "messageContent";
    public static final String ACT_TO = "To";
    public static final String ACT_CC = "ToCC";
    public static final String ACT_BCC = "ToBCC";
    public static final String ACT_REMOVE = "remove";
    public static final int MESSAGE_NEW = 0;
    public final int MESSAGE_IN_DRAFT = 1;
    public final int MESSAGE_REPLY = 2;
    public final int MESSAGE_REPLY_ALL = 3;
    public final int MESSAGE_FOWARD = 4;
    private List<Attachment> attachments_ = new ArrayList();
    private Message message_ = null;
    private long priority_ = 3L;
    private Boolean isVisualEditor = true;
    private int composeType_ = 0;
    private String accountId_;
    public String parentPath_;
    public List<Contact> toContacts = new ArrayList();
    public List<Contact> ccContacts = new ArrayList();
    public List<Contact> bccContacts = new ArrayList();

    public boolean isVisualEditor() {
        return this.isVisualEditor;
    }

    public void setVisualEditor(boolean b) {
        this.isVisualEditor = b;
    }

    public void init(String accountId, Message msg, int composeType) throws Exception {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        String username = MailUtils.getCurrentUser();
        this.accountId_ = accountId;
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        for (Account acc : mailSrv.getAccounts(SessionProviderFactory.createSystemProvider(), username)) {
            SelectItemOption itemOption = new SelectItemOption(acc.getUserDisplayName() + " &lt;" + acc.getEmailAddress() + "&gt;", (Object)acc.getId());
            if (acc.getId().equals(accountId)) {
                itemOption.setSelected(true);
            }
            options.add(itemOption);
        }
        UIComposeInput toSet = new UIComposeInput(FIELD_TO_SET);
        toSet.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_FROM, FIELD_FROM, options));
        toSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_TO, null, null));
        UIFormTextAreaInput textAreaCC = new UIFormTextAreaInput(FIELD_CC, FIELD_CC, null);
        textAreaCC.setId(FIELD_CC);
        textAreaCC.setColumns(2);
        toSet.addUIFormInput((UIFormInput)textAreaCC);
        UIFormTextAreaInput textAreaBCC = new UIFormTextAreaInput(FIELD_BCC, FIELD_BCC, null);
        textAreaBCC.setColumns(2);
        textAreaBCC.setId(FIELD_BCC);
        toSet.addUIFormInput((UIFormInput)textAreaBCC);
        toSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_SUBJECT, FIELD_SUBJECT, null));
        toSet.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_ATTACHMENTS, FIELD_ATTACHMENTS, null));
        toSet.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
        this.addUIFormInput((UIFormInputSet)toSet);
        MailSetting mailSetting = mailSrv.getMailSetting(SessionProviderFactory.createSystemProvider(), username);
        this.isVisualEditor = mailSetting.useWysiwyg();
        if (this.isVisualEditor.booleanValue()) {
            this.addUIFormInput((UIFormInput)new UIFormWYSIWYGInput(FIELD_MESSAGECONTENT, FIELD_MESSAGECONTENT, null, true));
        } else {
            this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MESSAGECONTENT, FIELD_MESSAGECONTENT, null));
        }
        this.setPriority(3L);
        this.setMessage(msg, composeType);
    }

    public List<Contact> getToContacts() {
        return this.toContacts;
    }

    public void setToContacts(List<Contact> contactList) {
        this.toContacts = contactList;
    }

    public List<Contact> getCcContacts() {
        return this.ccContacts;
    }

    public void setCcContacts(List<Contact> contactList) {
        this.ccContacts = contactList;
    }

    public List<Contact> getBccContacts() {
        return this.bccContacts;
    }

    public void setBccContacts(List<Contact> contactList) {
        this.bccContacts = contactList;
    }

    public int getComposeType() {
        return this.composeType_;
    }

    public void setComposeType(int t) {
        this.composeType_ = t;
    }

    public List<UIFormInputWithActions.ActionData> getUploadFileList() throws Exception {
        ArrayList<UIFormInputWithActions.ActionData> uploadedFiles = new ArrayList<UIFormInputWithActions.ActionData>();
        for (Attachment attachdata : this.attachments_) {
            UIFormInputWithActions.ActionData fileUpload = new UIFormInputWithActions.ActionData();
            fileUpload.setActionListener("Download");
            fileUpload.setActionParameter(attachdata.getId());
            fileUpload.setActionType(0);
            fileUpload.setCssIconClass("AttachmentIcon");
            fileUpload.setActionName(attachdata.getName() + " (" + MailUtils.convertSize((long)attachdata.getSize()) + ")");
            fileUpload.setShowLabel(true);
            uploadedFiles.add(fileUpload);
            UIFormInputWithActions.ActionData removeAction = new UIFormInputWithActions.ActionData();
            removeAction.setActionListener("RemoveAttachment");
            removeAction.setActionName(ACT_REMOVE);
            removeAction.setActionParameter(attachdata.getId());
            removeAction.setCssIconClass("LabelLink");
            removeAction.setActionType(1);
            removeAction.setBreakLine(true);
            uploadedFiles.add(removeAction);
        }
        return uploadedFiles;
    }

    public List<String> getCheckedAttach() throws Exception {
        ArrayList<String> checkedAttach = new ArrayList<String>();
        for (Attachment att : this.attachments_) {
            UIComposeInput inputSet = (UIComposeInput)this.getChildById(FIELD_TO_SET);
            UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)inputSet.getChildById(att.getId());
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            checkedAttach.add(att.getId());
        }
        return checkedAttach;
    }

    public void refreshUploadFileList() throws Exception {
        UIComposeInput inputSet = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        inputSet.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
    }

    public void addToUploadFileList(Attachment attachfile) {
        this.attachments_.add(attachfile);
        UIComposeInput inputSet = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        inputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(attachfile.getId(), null, null).setChecked(true));
    }

    public void removeFromUploadFileList(Attachment attachfile) {
        UIComposeInput inputSet = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        inputSet.removeChildById(attachfile.getId());
        this.attachments_.remove(attachfile);
    }

    public void removeUploadFileList() {
        UIComposeInput inputSet = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        for (Attachment att : this.attachments_) {
            inputSet.removeChildById(att.getId());
        }
        this.attachments_.clear();
    }

    public List<Attachment> getAttachFileList() {
        return this.attachments_;
    }

    public Message getMessage() {
        return this.message_;
    }

    public void setMessage(Message message, int composeType) throws Exception {
        this.setComposeType(composeType);
        this.message_ = message;
        this.fillFields(this.message_);
    }

    public void fillFields(Message msg) throws Exception {
        if (msg == null) {
            this.setFieldContentValue("");
            return;
        }
        MailService mailSrv = MailUtils.getMailService();
        String username = MailUtils.getCurrentUser();
        MailSetting mailSetting = mailSrv.getMailSetting(SessionProviderFactory.createSystemProvider(), MailUtils.getCurrentUser());
        UIComposeInput inputSet = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        String subject = "";
        String replyContent = "";
        switch (this.getComposeType()) {
            case 1: {
                this.setFieldSubjectValue(msg.getSubject());
                this.setFieldToValue(msg.getMessageTo());
                this.setFieldCcValue(msg.getMessageCc());
                this.setFieldBccValue(msg.getMessageBcc());
                this.setFieldContentValue(this.formatContent(msg));
                if (msg == null || !msg.hasAttachment()) break;
                msg = mailSrv.loadAttachments(SessionProviderFactory.createSystemProvider(), username, this.accountId_, msg);
                for (Attachment att : msg.getAttachments()) {
                    this.attachments_.add(att);
                }
                if (this.attachments_.size() <= 0) break;
                for (UIFormInputWithActions.ActionData actionData : this.getUploadFileList()) {
                    inputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(actionData.getActionParameter(), null, null).setChecked(true));
                }
                this.refreshUploadFileList();
                break;
            }
            case 2: {
                this.setFieldToValue(msg.getReplyTo());
                subject = msg.getSubject();
                if (!subject.toLowerCase().startsWith("re:")) {
                    subject = "Re: " + subject;
                }
                this.setFieldSubjectValue(subject);
                if (msg != null && msg.hasAttachment()) {
                    if (msg.getAttachments() == null) {
                        msg = mailSrv.loadAttachments(SessionProviderFactory.createSystemProvider(), username, this.accountId_, msg);
                    }
                    for (Attachment att : msg.getAttachments()) {
                        this.attachments_.add(att);
                    }
                }
                if (mailSetting.replyWithAttach()) {
                    this.addOriginalMessageAsAttach(msg);
                } else {
                    replyContent = this.getReplyContent(msg);
                }
                this.setFieldContentValue(replyContent);
                if (this.attachments_.size() <= 0) break;
                for (UIFormInputWithActions.ActionData actionData : this.getUploadFileList()) {
                    inputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(actionData.getActionParameter(), null, null));
                }
                this.refreshUploadFileList();
                break;
            }
            case 3: {
                subject = msg.getSubject();
                if (!subject.toLowerCase().startsWith("re:")) {
                    subject = "Re: " + subject;
                }
                this.setFieldSubjectValue(subject);
                String replyTo = msg.getReplyTo();
                this.setFieldToValue(replyTo);
                String replyCc = "";
                String msgTo = msg.getMessageTo() != null ? msg.getMessageTo() : "";
                InternetAddress[] msgToAdds = Utils.getInternetAddress((String)msgTo);
                MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
                Account account = mailSvr.getAccountById(SessionProviderFactory.createSystemProvider(), MailUtils.getCurrentUser(), this.accountId_);
                for (int i = 0; i < msgToAdds.length; ++i) {
                    if (msgToAdds[i] == null || msgToAdds[i].getAddress().equalsIgnoreCase(account.getEmailAddress()) || msgToAdds[i].getAddress().equalsIgnoreCase(account.getIncomingUser())) continue;
                    if (replyCc.trim().length() > 0) {
                        replyCc = replyCc + ", ";
                    }
                    replyCc = replyCc + msgToAdds[i].toString();
                }
                String msgCc = msg.getMessageCc() != null ? msg.getMessageCc() : "";
                InternetAddress[] msgCcAdds = Utils.getInternetAddress((String)msgCc);
                for (int i = 0; i < msgCcAdds.length; ++i) {
                    if (msgCcAdds[i] == null || msgCcAdds[i].getAddress().equalsIgnoreCase(account.getEmailAddress()) || msgCcAdds[i].getAddress().equalsIgnoreCase(account.getIncomingUser())) continue;
                    if (replyCc.trim().length() > 0) {
                        replyCc = replyCc + ", ";
                    }
                    replyCc = replyCc + msgCcAdds[i].toString();
                }
                if (replyCc.trim().length() > 0) {
                    this.setFieldCcValue(replyCc);
                    this.setShowCc(true);
                }
                if (msg != null && msg.hasAttachment()) {
                    if (msg.getAttachments() == null) {
                        msg = mailSrv.loadAttachments(SessionProviderFactory.createSystemProvider(), username, this.accountId_, msg);
                    }
                    for (Attachment att : msg.getAttachments()) {
                        this.attachments_.add(att);
                    }
                }
                if (mailSetting.replyWithAttach()) {
                    this.addOriginalMessageAsAttach(msg);
                } else {
                    replyContent = this.getReplyContent(msg);
                }
                this.setFieldContentValue(replyContent);
                if (this.attachments_.size() <= 0) break;
                for (UIFormInputWithActions.ActionData actionData : this.getUploadFileList()) {
                    inputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(actionData.getActionParameter(), null, null));
                }
                this.refreshUploadFileList();
                break;
            }
            case 4: {
                String toAddress = msg.getMessageTo() != null ? msg.getMessageTo() : "";
                subject = msg.getSubject();
                if (!subject.toLowerCase().startsWith("fwd:")) {
                    subject = "Fwd: " + subject;
                }
                this.setFieldSubjectValue(subject);
                this.setFieldToValue("");
                if (msg != null && msg.hasAttachment()) {
                    if (msg.getAttachments() == null) {
                        msg = mailSrv.loadAttachments(SessionProviderFactory.createSystemProvider(), username, this.accountId_, msg);
                    }
                    for (Attachment att : msg.getAttachments()) {
                        this.attachments_.add(att);
                    }
                }
                StringBuffer forwardTxt = new StringBuffer("");
                if (!mailSetting.forwardWithAtt()) {
                    forwardTxt.append("<br><br>-------- Original Message --------<br>");
                    forwardTxt.append("Subject: ").append(MailUtils.encodeHTML((String)msg.getSubject())).append("<br>");
                    forwardTxt.append("Date: ").append(msg.getSendDate()).append("<br>");
                    forwardTxt.append("From: ");
                    InternetAddress[] addresses = Utils.getInternetAddress((String)msg.getFrom());
                    for (int i = 0; i < addresses.length; ++i) {
                        if (i > 0) {
                            forwardTxt.append(", ");
                        }
                        if (addresses[i] == null) continue;
                        forwardTxt.append(Utils.getPersonal((InternetAddress)addresses[i])).append(" \"").append(addresses[i].getAddress()).append("\"");
                    }
                    forwardTxt.append("<br>To: ");
                    InternetAddress[] toAddresses = Utils.getInternetAddress((String)toAddress);
                    for (int i = 0; i < toAddresses.length; ++i) {
                        if (i > 0) {
                            forwardTxt.append(", ");
                        }
                        if (toAddresses[i] == null) continue;
                        forwardTxt.append(Utils.getPersonal((InternetAddress)toAddresses[i])).append(" \"").append(toAddresses[i].getAddress()).append("\"");
                    }
                    forwardTxt.append("<br><br>").append(this.formatContent(msg));
                } else {
                    this.addOriginalMessageAsAttach(msg);
                }
                this.refreshUploadFileList();
                for (UIFormInputWithActions.ActionData actionData : this.getUploadFileList()) {
                    inputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(actionData.getActionParameter(), null, null).setChecked(true));
                }
                this.setFieldContentValue(forwardTxt.toString());
                break;
            }
        }
    }

    private String getReplyContent(Message msg) throws Exception {
        String msgContent;
        String content = msgContent = this.formatContent(msg);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        String from = "";
        try {
            from = Utils.getAddresses((String)msg.getFrom())[0];
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.isVisualEditor.booleanValue()) {
            content = "<br><br><div> On " + MailUtils.formatDate((String)"MMM dd, yyyy HH:mm aaa", (Date)msg.getSendDate(), (Locale)locale) + ", " + from + " wrote: <br>";
            content = content + "<blockquote style=\"border-left:1px #cccccc solid ; margin-left: 10px; padding-left: 5px;\">" + msgContent + "</blockquote></div>";
        } else {
            content = "\n\n On " + MailUtils.formatDate((String)"MMM dd, yyyy HH:mm aaa", (Date)msg.getSendDate(), (Locale)locale) + ", " + from + " wrote: \n\n";
            content = content + msgContent;
        }
        return content;
    }

    private String formatContent(Message msg) throws Exception {
        String msgContent = msg.getMessageBody();
        if (this.isVisualEditor.booleanValue() && msg.getContentType().indexOf("text/plain") > -1) {
            msgContent = MailUtils.encodeHTML((String)msg.getMessageBody()).replaceAll("\n", "<br />");
        }
        return msgContent;
    }

    private void addOriginalMessageAsAttach(Message msg) throws Exception {
        MailService mailSrv = MailUtils.getMailService();
        String username = MailUtils.getCurrentUser();
        BufferAttachment att = new BufferAttachment();
        ByteArrayOutputStream outputStream = (ByteArrayOutputStream)mailSrv.exportMessage(SessionProviderFactory.createSystemProvider(), username, this.accountId_, msg);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        att.setSize((long)inputStream.available());
        att.setId("Attachment" + IdGenerator.generate());
        att.setName(msg.getSubject() + ".eml");
        att.setInputStream((InputStream)inputStream);
        att.setMimeType("message/rfc822");
        this.attachments_.add(att);
    }

    public long getPriority() {
        return this.priority_;
    }

    public void setPriority(long priority) {
        this.priority_ = priority;
    }

    public String getFieldFromValue() {
        UIComposeInput input = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        return (String)input.getUIFormSelectBox(FIELD_FROM).getValue();
    }

    public String getFieldSubjectValue() {
        UIComposeInput input = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        String subject = (String)input.getUIStringInput(FIELD_SUBJECT).getValue();
        if (subject == null) {
            subject = "(no subject)";
        }
        return subject;
    }

    public void setFieldSubjectValue(String value) {
        UIComposeInput input = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        input.getUIStringInput(FIELD_SUBJECT).setValue((Object)value);
    }

    public String getFieldToValue() {
        UIComposeInput input = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        return (String)input.getUIStringInput(FIELD_TO).getValue();
    }

    public void setFieldToValue(String value) {
        UIComposeInput input = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        input.getUIStringInput(FIELD_TO).setValue((Object)value);
    }

    public String getFieldCcValue() {
        UIComposeInput input = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        return (String)input.getUIFormTextAreaInput(FIELD_CC).getValue();
    }

    public void setFieldCcValue(String value) {
        UIComposeInput input = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        input.getUIFormTextAreaInput(FIELD_CC).setValue((Object)value);
    }

    public String getFieldBccValue() {
        UIComposeInput input = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        return (String)input.getUIFormTextAreaInput(FIELD_BCC).getValue();
    }

    public void setFieldBccValue(String value) {
        UIComposeInput input = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        input.getUIFormTextAreaInput(FIELD_BCC).setValue((Object)value);
    }

    public String getFieldAttachmentsValue() {
        UIComposeInput inputSet = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        return (String)inputSet.getUIFormInputInfo(FIELD_ATTACHMENTS).getValue();
    }

    public String getFieldContentValue() {
        String content = "";
        content = this.isVisualEditor != false ? (String)((UIFormWYSIWYGInput)this.getChild(UIFormWYSIWYGInput.class)).getValue() : (String)this.getUIFormTextAreaInput(FIELD_MESSAGECONTENT).getValue();
        if (content == null) {
            content = "";
        }
        return content;
    }

    public void setFieldContentValue(String value) throws Exception {
        String username = MailUtils.getCurrentUser();
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        Account account = mailSrv.getAccountById(SessionProviderFactory.createSystemProvider(), username, this.accountId_);
        if (this.isVisualEditor.booleanValue()) {
            if (!MailUtils.isFieldEmpty((String)account.getSignature()) && !this.fromDrafts()) {
                value = value + "<br><br> -- <br >" + account.getSignature().replace("\n", "<br>") + "";
            }
            ((UIFormWYSIWYGInput)this.getChild(UIFormWYSIWYGInput.class)).setValue((Object)value);
        } else {
            if (!MailUtils.isFieldEmpty((String)account.getSignature())) {
                value = MailUtils.html2text((String)value).replaceAll("\n", "\n > ") + "\n\n -- \n" + account.getSignature();
            }
            this.getUIFormTextAreaInput(FIELD_MESSAGECONTENT).setValue((Object)value);
        }
    }

    public List<Contact> getContacts() throws Exception {
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        String username = MailUtils.getCurrentUser();
        return contactSrv.getAllContact(SessionProviderFactory.createSystemProvider(), username);
    }

    public void resetFields() {
        this.reset();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private Message getNewMessage() throws Exception {
        String bcc;
        String cc;
        Message message = this.getMessage();
        if (!this.fromDrafts()) {
            if (message != null) {
                this.parentPath_ = message.getPath();
            }
            message = new Message();
        }
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String usename = uiPortlet.getCurrentUser();
        MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
        Account account = mailSvr.getAccountById(SessionProviderFactory.createSystemProvider(), usename, this.getFieldFromValue());
        String from = account.getUserDisplayName() + "<" + account.getEmailAddress() + ">";
        String subject = this.getFieldSubjectValue();
        String to = this.getFieldToValue();
        if (to != null && to.indexOf(";") > -1) {
            to = to.replace(';', ',');
        }
        if ((cc = this.getFieldCcValue()) != null && cc.indexOf(";") > -1) {
            cc = cc.replace(';', ',');
        }
        if ((bcc = this.getFieldBccValue()) != null && bcc.indexOf(";") > -1) {
            bcc = bcc.replace(';', ',');
        }
        String body = this.getFieldContentValue();
        Long priority = this.getPriority();
        message.setSendDate(new Date());
        message.setAccountId(this.accountId_);
        message.setFrom(from);
        String contentType = Utils.MIMETYPE_TEXTHTML;
        if (!this.isVisualEditor()) {
            contentType = Utils.MIMETYPE_TEXTPLAIN;
        }
        message.setContentType(contentType);
        message.setSubject(subject);
        message.setMessageTo(to);
        message.setMessageCc(cc);
        if (message.getReceivedDate() == null) {
            message.setReceivedDate(new Date());
        }
        message.setMessageBcc(bcc);
        message.setHasStar(false);
        message.setPriority(priority.longValue());
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (Attachment att : this.getAttachFileList()) {
            if (!this.getCheckedAttach().contains(att.getId())) continue;
            attachments.add(att);
        }
        message.setAttachements(attachments);
        long attSize = 0L;
        for (Attachment att : this.getAttachFileList()) {
            if (!this.getCheckedAttach().contains(att.getId())) continue;
            attSize += att.getSize();
        }
        message.setMessageBody(body);
        message.setUnread(false);
        message.setSize((long)body.getBytes().length + attSize);
        message.setReplyTo(account.getEmailReplyAddress());
        if (this.getComposeType() == 2 || this.getComposeType() == 3 || this.getComposeType() == 4) {
            message.setHeader(Utils.HEADER_IN_REPLY_TO, this.getMessage().getId());
        }
        return message;
    }

    public boolean fromDrafts() {
        return this.getMessage() != null && this.getMessage().getFolders()[0].equals(Utils.createFolderId((String)this.accountId_, (String)Utils.FD_DRAFTS, (boolean)false)) || this.getComposeType() == 1;
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public void setShowCc(boolean showCc_) {
        UIComposeInput uiInput = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        uiInput.setShowCc(showCc_);
    }

    public boolean isShowCc() {
        UIComposeInput uiInput = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        return uiInput.isShowCc();
    }

    public void setShowBcc(boolean showBcc_) {
        UIComposeInput uiInput = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        uiInput.setShowBcc(showBcc_);
    }

    public boolean isShowBcc() {
        UIComposeInput uiInput = (UIComposeInput)this.getChildById(FIELD_TO_SET);
        return uiInput.isShowBcc();
    }

    public void saveToSentFolder(String usename, String accountId, Message message) throws Exception {
        SessionProvider session = SessionProviderFactory.createSystemProvider();
        MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
        MailSetting setting = mailSvr.getMailSetting(session, usename);
        boolean isSaved = setting.saveMessageInSent();
        boolean fromDrafts = this.fromDrafts();
        if (!fromDrafts && isSaved) {
            message.setReplyTo(message.getMessageTo());
            message.setFolders(new String[]{Utils.createFolderId((String)accountId, (String)Utils.FD_SENT, (boolean)false)});
            mailSvr.saveMessage(session, usename, accountId, this.parentPath_, message, true);
        } else if (fromDrafts) {
            Folder drafts = mailSvr.getFolder(session, usename, accountId, Utils.createFolderId((String)accountId, (String)Utils.FD_DRAFTS, (boolean)false));
            if (isSaved) {
                message.setFolders(new String[]{Utils.createFolderId((String)accountId, (String)Utils.FD_SENT, (boolean)false)});
                mailSvr.saveMessage(session, usename, accountId, this.parentPath_, message, false);
            } else {
                mailSvr.removeMessage(session, usename, accountId, message);
            }
            drafts.setTotalMessage(drafts.getTotalMessage() - 1L);
            mailSvr.saveFolder(session, usename, accountId, drafts);
        }
    }

    private boolean validateMessage(Event<UIComposeForm> event, Message msg) throws Exception {
        String msgWarning = null;
        if (!MailUtils.isValidEmailAddresses((String)msg.getMessageTo())) {
            msgWarning = "UIComposeForm.msg.invalid-to-field";
        } else if (!MailUtils.isValidEmailAddresses((String)msg.getMessageCc())) {
            msgWarning = "UIComposeForm.msg.invalid-cc-field";
        } else if (!MailUtils.isValidEmailAddresses((String)msg.getMessageBcc())) {
            msgWarning = "UIComposeForm.msg.invalid-bcc-field";
        }
        if (msgWarning != null) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage(msgWarning, null));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return false;
        }
        return true;
    }

    static /* synthetic */ Message access$000(UIComposeForm x0) throws Exception {
        return x0.getNewMessage();
    }

    static /* synthetic */ boolean access$100(UIComposeForm x0, Event x1, Message x2) throws Exception {
        return x0.validateMessage(x1, x2);
    }

    static /* synthetic */ List access$200(UIComposeForm x0) {
        return x0.attachments_;
    }
}

