/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.webui.popup.UIMailSettings;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIMailSettings.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIMailSettings
extends UIForm
implements UIPopupComponent {
    public static final String DEFAULT_ACCOUNT = "default-account".intern();
    public static final String NUMBER_MSG_PER_PAGE = "number-of-conversation".intern();
    public static final String PERIOD_CHECK_AUTO = "period-check-mail".intern();
    public static final String COMPOSE_MESSAGE_IN = "compose-message-in".intern();
    public static final String REPLY_WITH_ATTACH = "reply-message-with".intern();
    public static final String FORWARD_WITH_ATTACH = "forward-message-with".intern();
    public static final String SAVE_SENT_MESSAGE = "save-sent-message".intern();

    public void init() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(DEFAULT_ACCOUNT, DEFAULT_ACCOUNT, this.getAccounts()));
        ArrayList<SelectItemOption> numberPerPage = new ArrayList<SelectItemOption>();
        for (int i = 1; i <= 7; ++i) {
            numberPerPage.add(new SelectItemOption((Object)String.valueOf(10 * i)));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(NUMBER_MSG_PER_PAGE, NUMBER_MSG_PER_PAGE, numberPerPage));
        ArrayList<SelectItemOption> periodCheckAuto = new ArrayList<SelectItemOption>();
        periodCheckAuto.add(new SelectItemOption("Never", (Object)("period." + String.valueOf(MailSetting.NEVER_CHECK_AUTO))));
        periodCheckAuto.add(new SelectItemOption("5 minutes", (Object)("period." + String.valueOf(MailSetting.FIVE_MINS))));
        periodCheckAuto.add(new SelectItemOption("10 minutes", (Object)("period." + String.valueOf(MailSetting.TEN_MINS))));
        periodCheckAuto.add(new SelectItemOption("20 minutes", (Object)("period." + String.valueOf(MailSetting.TWENTY_MINS))));
        periodCheckAuto.add(new SelectItemOption("30 minutes", (Object)("period." + String.valueOf(MailSetting.THIRTY_MINS))));
        periodCheckAuto.add(new SelectItemOption("1 hour", (Object)("period." + String.valueOf(MailSetting.ONE_HOUR))));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(PERIOD_CHECK_AUTO, PERIOD_CHECK_AUTO, periodCheckAuto));
        ArrayList<SelectItemOption> useWysiwyg = new ArrayList<SelectItemOption>();
        useWysiwyg.add(new SelectItemOption("Rich text editor (HTML format)", (Object)"editor.true"));
        useWysiwyg.add(new SelectItemOption("Plain text", (Object)"editor.false"));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(COMPOSE_MESSAGE_IN, COMPOSE_MESSAGE_IN, useWysiwyg));
        ArrayList<SelectItemOption> replyWithAtt = new ArrayList<SelectItemOption>();
        replyWithAtt.add(new SelectItemOption("Original message included attachment", (Object)"replywith.true"));
        replyWithAtt.add(new SelectItemOption("Original message", (Object)"replywith.false"));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(REPLY_WITH_ATTACH, REPLY_WITH_ATTACH, replyWithAtt));
        ArrayList<SelectItemOption> forwardWithAtt = new ArrayList<SelectItemOption>();
        forwardWithAtt.add(new SelectItemOption("Original message included attachment", (Object)"forwardwith.true"));
        forwardWithAtt.add(new SelectItemOption("Original message", (Object)"forwardwith.false"));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FORWARD_WITH_ATTACH, FORWARD_WITH_ATTACH, forwardWithAtt));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(SAVE_SENT_MESSAGE, SAVE_SENT_MESSAGE, (Object)false));
        this.fillData();
    }

    public List<SelectItemOption<String>> getAccounts() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        for (Account acc : mailSrv.getAccounts(SessionProviderFactory.createSystemProvider(), username)) {
            SelectItemOption itemOption = new SelectItemOption(acc.getLabel() + " &lt;" + acc.getEmailAddress() + "&gt;", (Object)acc.getId());
            options.add((SelectItemOption<String>)itemOption);
        }
        return options;
    }

    public void fillData() throws Exception {
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        MailSetting setting = mailSrv.getMailSetting(SessionProviderFactory.createSystemProvider(), username);
        if (setting != null) {
            this.getUIFormSelectBox(DEFAULT_ACCOUNT).setValue(setting.getDefaultAccount());
            this.getUIFormSelectBox(NUMBER_MSG_PER_PAGE).setValue(String.valueOf(setting.getNumberMsgPerPage()));
            this.getUIFormSelectBox(PERIOD_CHECK_AUTO).setValue("period." + String.valueOf(setting.getPeriodCheckAuto()));
            this.getUIFormSelectBox(COMPOSE_MESSAGE_IN).setValue("editor." + String.valueOf(setting.useWysiwyg()));
            this.getUIFormSelectBox(REPLY_WITH_ATTACH).setValue("replywith." + String.valueOf(setting.replyWithAttach()));
            this.getUIFormSelectBox(FORWARD_WITH_ATTACH).setValue("forwardwith." + String.valueOf(setting.forwardWithAtt()));
            this.getUIFormCheckBoxInput(SAVE_SENT_MESSAGE).setChecked(setting.saveMessageInSent());
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

