/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.Selector;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.popup.UIAccountCreation;
import org.exoplatform.mail.webui.popup.UIAccountWizardStep1;
import org.exoplatform.mail.webui.popup.UIAccountWizardStep2;
import org.exoplatform.mail.webui.popup.UIAccountWizardStep3;
import org.exoplatform.mail.webui.popup.UIAccountWizardStep4;
import org.exoplatform.mail.webui.popup.UIAccountWizardStep5;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormTabPane;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAccountCreation.gtmpl", events={@EventConfig(listeners={ViewStepActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeServerTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeCheckedActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeOutgoingSslActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={NextActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={FinishActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CheckFromDateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE, confirm="UIAccountCreation.msg.confirm-cancel")})
public class UIAccountCreation
extends UIFormTabPane
implements UIPopupComponent,
Selector {
    private int wizardMaxStep_ = 5;
    private int currentStep_ = 1;
    private int wizardMinStep_ = 1;
    private boolean isChildPopup_ = false;
    private boolean isShowStepActions_ = true;
    private Map<Integer, String> chidrenMap_ = new HashMap();
    public String password_ = null;
    public static final String POPUPID = "UIAccountCreationWizardPopup";
    public static final String INPUT_STEP1 = "step1";
    public static final String INPUT_STEP2 = "step2";
    public static final String INPUT_STEP3 = "step3";
    public static final String INPUT_STEP4 = "step4";
    public static final String INPUT_STEP5 = "step5";
    public static final String[] ACT_SELETFOLDER = new String[]{"SelectFolder"};
    public static final String ACT_CHECKSAVEPASS = "CheckSavePass";
    public static final String[] ACT_CHECKGETMAIL = new String[]{"CheckGetMail"};
    public static final String ACT_CHANGE_TYPE = "ChangeServerType".intern();
    public static final String ACT_CHANGE_ACT = "ChangeType".intern();
    public static final String ACT_CHANGE_SSL = "ChangeChecked".intern();
    public static final String ACT_CHANGE_OUTGOINGSSL = "ChangeOutgoingSsl".intern();
    public static final String FD_INBOX = "Inbox".intern();
    public static final String FD_DRAFTS = "Drafts".intern();
    public static final String FD_SENT = "Sent".intern();
    public static final String FD_SPAM = "Spam".intern();
    public static final String FD_TRASH = "Trash".intern();
    public static final String[] defaultFolders_ = new String[]{FD_INBOX, FD_DRAFTS, FD_SENT, FD_SPAM, FD_TRASH};
    public static final String DEFAULT_POP_SERVER = "pop.gmail.com".intern();
    public static final String DEFAULT_IMAP_SERVER = "imap.gmail.com".intern();
    public static final String DEFAULT_SMTP_SERVER = "smtp.gmail.com".intern();
    public static final String DEFAULT_POP_PORT = "110".intern();
    public static final String DEFAULT_SMTP_PORT = "25".intern();
    public static final String DEFAULT_POPSSL_PORT = "995".intern();
    public static final String DEFAULT_SMTPSSL_PORT = "465".intern();
    public static final String DEFAULT_SERVER_FOLDER = "Inbox".intern();
    public static final String DEFAULT_IMAP_PORT = "143".intern();
    public static final String DEFAULT_IMAPSSL_PORT = "993".intern();

    public UIAccountCreation() throws Exception {
        super("UIAccountCreation");
        UIAccountWizardStep1 uiAccountWizardStep1 = new UIAccountWizardStep1(INPUT_STEP1);
        this.setSelectedTab(uiAccountWizardStep1.getId());
        this.addUIComponentInput((UIComponent)new UIAccountWizardStep1(INPUT_STEP1));
        this.addUIComponentInput((UIComponent)new UIAccountWizardStep2(INPUT_STEP2));
        this.addUIComponentInput((UIComponent)new UIAccountWizardStep3(INPUT_STEP3));
        this.addUIComponentInput((UIComponent)new UIAccountWizardStep4(INPUT_STEP4));
        this.addUIComponentInput((UIComponent)new UIAccountWizardStep5(INPUT_STEP5));
        for (UIComponent c : this.getChildren()) {
            this.chidrenMap_.put(this.getChildren().indexOf(c) + 1, c.getId());
        }
        this.setSelectedTab(this.getCurrentChild());
    }

    public boolean showStepActions() {
        return this.isShowStepActions_;
    }

    protected void setShowStepActions(boolean isShow) {
        this.isShowStepActions_ = isShow;
    }

    public void setCurrentSep(int step) {
        this.currentStep_ = step;
    }

    public int getCurrentStep() {
        return this.currentStep_;
    }

    public int getMaxStep() {
        return this.wizardMaxStep_;
    }

    public String getCurrentChild() {
        return (String)this.chidrenMap_.get(this.currentStep_);
    }

    public int getNumberSteps() {
        return this.wizardMaxStep_;
    }

    protected boolean isChildPopup() {
        return this.isChildPopup_;
    }

    protected void setChildPopup(boolean isChildPopup) {
        this.isChildPopup_ = isChildPopup;
    }

    protected void viewStep(int step) {
        this.currentStep_ = step;
        this.setSelectedTab((String)this.chidrenMap_.get(this.getCurrentStep()));
    }

    protected void nextStep() {
        ++this.currentStep_;
        this.setSelectedTab((String)this.chidrenMap_.get(this.getCurrentStep()));
    }

    protected void backStep() {
        --this.currentStep_;
        this.setSelectedTab((String)this.chidrenMap_.get(this.getCurrentStep()));
    }

    public String[] getActions() {
        if (this.currentStep_ == this.wizardMinStep_) {
            return new String[]{"Next", "Cancel"};
        }
        if (this.currentStep_ == this.wizardMaxStep_) {
            return new String[]{"Back", "Finish", "Cancel"};
        }
        return new String[]{"Back", "Next", "Cancel"};
    }

    protected void saveForm(String currentUser, Account account) throws Exception {
        MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
        mailSvr.createAccount(SessionProviderFactory.createSystemProvider(), currentUser, account);
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String username = uiPortlet.getCurrentUser();
        for (String folderName : defaultFolders_) {
            String folderId = Utils.createFolderId((String)account.getId(), (String)folderName, (boolean)false);
            Folder folder = mailSvr.getFolder(SessionProviderFactory.createSystemProvider(), username, account.getId(), folderId);
            if (folder != null) continue;
            folder = new Folder();
            folder.setId(folderId);
            folder.setName(folderName);
            folder.setPersonalFolder(false);
            mailSvr.saveFolder(SessionProviderFactory.createSystemProvider(), username, account.getId(), folder);
        }
    }

    protected void getMail(String accountId) throws Exception {
        MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String username = uiPortlet.getCurrentUser();
        mailSvr.checkMail(username, accountId);
    }

    protected void resetForm() {
        UIAccountWizardStep1 uiAccWs1 = (UIAccountWizardStep1)this.getChildById(INPUT_STEP1);
        UIAccountWizardStep2 uiAccWs2 = (UIAccountWizardStep2)this.getChildById(INPUT_STEP2);
        UIAccountWizardStep3 uiAccWs3 = (UIAccountWizardStep3)this.getChildById(INPUT_STEP3);
        UIAccountWizardStep4 uiAccWs4 = (UIAccountWizardStep4)this.getChildById(INPUT_STEP4);
        UIAccountWizardStep5 uiAccWs5 = (UIAccountWizardStep5)this.getChildById(INPUT_STEP5);
        uiAccWs1.resetFields();
        uiAccWs2.resetFields();
        uiAccWs3.resetFields();
        uiAccWs4.resetFields();
        uiAccWs5.resetFields();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateValue(String fieldId, String value) {
    }

    static /* synthetic */ boolean access$000(UIAccountCreation x0) {
        return x0.isChildPopup_;
    }
}

