/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.io.Writer;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormDateTimePicker
extends UIFormInputBase<String> {
    private String dateStyle_ = "MM/dd/yyyy";
    private String timeStyle_ = "HH:mm:ss";
    private Date date_;
    private boolean isDisplayTime_;
    private Locale locale_;

    public UIFormDateTimePicker(String name, String bindField, Date date, boolean isDisplayTime) {
        super(name, bindField, String.class);
        this.date_ = date;
        this.isDisplayTime_ = isDisplayTime;
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
    }

    private String getDaysName() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.locale_ == null) {
            this.locale_ = locale;
        }
        DateFormatSymbols dfs_ = new DateFormatSymbols(this.locale_);
        StringBuffer sb = new StringBuffer();
        for (String n : dfs_.getWeekdays()) {
            if (n == null || n.trim().length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(n.substring(0, 1));
        }
        return sb.toString();
    }

    protected String getMonthsName() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.locale_ == null) {
            this.locale_ = locale;
        }
        DateFormatSymbols dfs_ = new DateFormatSymbols(this.locale_);
        StringBuffer sb = new StringBuffer();
        for (String n : dfs_.getMonths()) {
            if (n == null || n.trim().length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(n);
        }
        return sb.toString();
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, boolean isDisplayTime, Locale locale) {
        super(name, bindField, String.class);
        this.date_ = date;
        this.isDisplayTime_ = isDisplayTime;
        this.locale_ = locale;
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, boolean isDisplayTime, String dateStyle) {
        super(name, bindField, String.class);
        this.dateStyle_ = dateStyle;
        this.isDisplayTime_ = isDisplayTime;
        this.date_ = date;
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, boolean isDisplayTime, String dateStyle, String timeStyle) {
        super(name, bindField, String.class);
        this.dateStyle_ = dateStyle;
        this.timeStyle_ = timeStyle;
        this.date_ = date;
        this.isDisplayTime_ = isDisplayTime;
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
    }

    public UIFormDateTimePicker(String name, String bindField, Date date) {
        this(name, bindField, date, true);
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, String dateStyle) {
        this(name, bindField, date, false, dateStyle);
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, String dateStyle, String timeStyle) {
        this(name, bindField, date, true, dateStyle, timeStyle);
    }

    public void setDisplayTime(boolean isDisplayTime) {
        this.isDisplayTime_ = isDisplayTime;
    }

    public void setCalendar(Calendar date) {
        this.date_ = date.getTime();
        this.value_ = this.getFormater().format(date.getTime());
    }

    public Calendar getCalendar() {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.getFormater().parse((String)this.value_ + " 0:0:0"));
            return calendar;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateValue() {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.getFormater().parse((String)this.value_ + " 0:0:0"));
            return calendar.getTime();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setDateFormatStyle(String dateStyle) {
        this.dateStyle_ = dateStyle;
        this.value_ = this.getFormater().format(this.date_);
    }

    public void setTimeFormatStyle(String timeStyle) {
        this.timeStyle_ = timeStyle;
        this.value_ = this.getFormater().format(this.date_);
    }

    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (input != null) {
            this.value_ = ((String)input).trim();
        }
    }

    public String getFormatStyle() {
        if (this.isDisplayTime_) {
            return this.dateStyle_ + " " + this.timeStyle_;
        }
        return this.dateStyle_;
    }

    private String getLang() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        return locale.getLanguage();
    }

    private DateFormat getFormater() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.locale_ == null) {
            this.locale_ = locale;
        }
        return new SimpleDateFormat(this.getFormatStyle(), this.locale_);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Locale locale;
        this.locale_ = locale = context.getParentAppRequestContext().getLocale();
        String disabled = this.isEditable() ? "" : "disabled";
        context.getJavascriptManager().importJavascript((CharSequence)"eXo.webui.UICalendar");
        context.getJavascriptManager().importJavascript("eXo.cs.UIDateTimePicker", "/csResources/javascript/");
        Writer w = context.getWriter();
        w.write("<input lang='" + this.getLang() + "' format='" + this.getFormatStyle() + "' type='text' onfocus='eXo.cs.UIDateTimePicker.init(this,");
        w.write(String.valueOf(this.isDisplayTime_));
        w.write(");' onkeyup='eXo.cs.UIDateTimePicker.show();' name='");
        w.write(this.getName());
        w.write(39);
        if (this.value_ != null && ((String)this.value_).length() > 0) {
            w.write(" value='" + (String)this.value_ + "'");
        }
        w.write(" onmousedown='event.cancelBubble = true' />");
    }
}

