/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.UIFolderContainer;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UIMessagePreview;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/mail/webui/UIMessagePreview.gtmpl", events={@EventConfig(listeners={DownloadAttachmentActionListener.class}), @EventConfig(listeners={AddStarActionListener.class}), @EventConfig(listeners={ReplyActionListener.class}), @EventConfig(listeners={ReplyAllActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIMessagePreview.msg.confirm-remove-message"), @EventConfig(listeners={ForwardActionListener.class}), @EventConfig(listeners={CreateFilterActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={AddTagActionListener.class}), @EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={MoveMessagesActionListener.class}), @EventConfig(listeners={AnswerInvitationActionListener.class}), @EventConfig(listeners={ViewAllHeadersActionListener.class}), @EventConfig(listeners={BackToListActionListener.class}), @EventConfig(listeners={HideMessageListActionListener.class})})
public class UIMessagePreview
extends UIComponent {
    public static String QUESTION = "question".intern();
    public static String ANSWER_IMPORT = "yes-import".intern();
    public static String ANSWER_YES = "yes".intern();
    public static String ANSWER_NO = "no".intern();
    public static String ANSWER_MAYBE = "maybe".intern();
    private Message selectedMessage_;
    private List<Message> showedMsgs = new ArrayList();
    private boolean isHideMessageList_ = false;
    private List<String> unreadMsgIds = new ArrayList();

    public Message getMessage() throws Exception {
        return this.selectedMessage_;
    }

    public void setMessage(Message msg) throws Exception {
        this.selectedMessage_ = msg;
    }

    public List<Message> getShowedMessages() throws Exception {
        return this.showedMsgs;
    }

    public void setShowedMessages(List<Message> msgList) throws Exception {
        this.showedMsgs = msgList;
    }

    public List<String> getUnreadMessages() throws Exception {
        return this.unreadMsgIds;
    }

    public void setUnreadMessages(List<String> unreadMsgIds) throws Exception {
        this.unreadMsgIds = unreadMsgIds;
    }

    public Map<String, String> getImageLocationMap(Message message) throws Exception {
        HashMap<String, String> imageLocation = new HashMap<String, String>();
        DownloadService dservice = this.getDownloadService();
        String attLink = "";
        String attId = "";
        if (message.getAttachments() != null) {
            for (Attachment att : message.getAttachments()) {
                if (!att.isShownInBody() || (attLink = MailUtils.getImageSource((Attachment)att, (DownloadService)dservice)) == null) continue;
                attLink = "/" + this.getPortalName() + "/rest/jcr/" + this.getRepository() + att.getPath();
                attId = att.getId();
                imageLocation.put(attId.substring(attId.lastIndexOf("/") + 1, attId.length()), attLink.substring(0, attLink.lastIndexOf("/") + 1));
            }
        }
        return imageLocation;
    }

    public void setIsHideMessageList(boolean b) {
        this.isHideMessageList_ = b;
    }

    public boolean isHideMessageList() {
        return this.isHideMessageList_;
    }

    public boolean isShowBcc(Message msg) throws Exception {
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String selectedFolder = ((UIFolderContainer)uiPortlet.findFirstComponentOfType(UIFolderContainer.class)).getSelectedFolder();
        String accId = ((UISelectAccount)uiPortlet.findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
        String username = MailUtils.getCurrentUser();
        MailService mailServ = (MailService)uiPortlet.getApplicationComponent(MailService.class);
        Account account = mailServ.getAccountById(username, accId);
        InternetAddress[] fromAddress = Utils.getInternetAddress((String)msg.getFrom());
        InternetAddress from = fromAddress[0];
        return !MailUtils.isFieldEmpty((String)selectedFolder) && selectedFolder.equals(Utils.generateFID((String)accId, (String)Utils.FD_SENT, (boolean)false)) && !MailUtils.isFieldEmpty((String)msg.getMessageBcc()) && account != null && from.getAddress().equalsIgnoreCase(account.getEmailAddress());
    }

    public CalendarEvent getEvent(Message msg) throws Exception {
        CalendarService calendarSrv = (CalendarService)this.getApplicationComponent(CalendarService.class);
        CalendarEvent calEvent2 = null;
        try {
            if (0 == Integer.parseInt(MailUtils.getEventType((Message)msg))) {
                ArrayList<String> calIds = new ArrayList<String>();
                calIds.add(MailUtils.getCalendarId((Message)msg));
                for (CalendarEvent calEvent2 : calendarSrv.getUserEventByCalendar(MailUtils.getEventFrom((Message)msg), calIds)) {
                    if (!MailUtils.getCalendarEventId((Message)msg).equals(calEvent2.getId())) continue;
                }
                if (!MailUtils.getCalendarEventId((Message)msg).equals(calEvent2.getId())) {
                    calEvent2 = null;
                }
            } else if (1 != Integer.parseInt(MailUtils.getEventType((Message)msg)) && 2 == Integer.parseInt(MailUtils.getEventType((Message)msg))) {
                calEvent2 = calendarSrv.getGroupEvent(MailUtils.getCalendarId((Message)msg), MailUtils.getCalendarEventId((Message)msg));
            }
        }
        catch (Exception e) {
            calEvent2 = null;
        }
        return calEvent2;
    }

    public Message getShowedMessageById(String id) throws Exception {
        for (Message msg : this.getShowedMessages()) {
            if (!msg.getId().equals(id)) continue;
            return msg;
        }
        return null;
    }

    public DownloadService getDownloadService() {
        return (DownloadService)this.getApplicationComponent(DownloadService.class);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public String getAnswerStatus() throws Exception {
        CalendarEvent calEvent = this.getEvent(this.getMessage());
        if (calEvent == null) {
            return null;
        }
        String[] parStatus = calEvent.getParticipantStatus();
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String username = uiPortlet.getCurrentUser();
        String accId = ((UISelectAccount)uiPortlet.findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
        MailService mailSvr = (MailService)uiPortlet.getApplicationComponent(MailService.class);
        Account account = mailSvr.getAccountById(username, accId);
        String currentEmail = "";
        if (account != null) {
            currentEmail = account.getEmailAddress();
        }
        for (String par : parStatus) {
            String[] entry = par.split(":");
            if (!entry[0].equalsIgnoreCase(username) && !entry[0].equalsIgnoreCase(currentEmail)) continue;
            if (entry.length > 1) {
                return entry[1];
            }
            return new String("");
        }
        return null;
    }
}

