/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.mail.webui.popup.UIFormMultiValueInputSet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UIFormMultiValueInputSet
extends UIFormInputContainer<List> {
    protected List<Validator> validators;
    private Class<? extends UIFormInput> clazz_;
    private Constructor constructor_ = null;

    public UIFormMultiValueInputSet() throws Exception {
        super(null, null);
    }

    public UIFormMultiValueInputSet(String name, String bindingField) throws Exception {
        super(name, bindingField);
        this.setComponentConfig(this.getClass(), null);
    }

    public Class<List> getTypeValue() {
        return List.class;
    }

    public void setType(Class<? extends UIFormInput> clazz) {
        this.clazz_ = clazz;
        Constructor<?>[] constructors = this.clazz_.getConstructors();
        if (constructors.length > 0) {
            this.constructor_ = constructors[0];
        }
    }

    public Class<? extends UIFormInput> getUIFormInputBase() {
        return this.clazz_;
    }

    public List<?> getValue() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (UIComponent child : this.getChildren()) {
            UIFormInputBase uiInput = (UIFormInputBase)child;
            if (uiInput.getValue() == null) continue;
            values.add(uiInput.getValue());
        }
        return values;
    }

    public UIFormInput setValue(List<?> values) throws Exception {
        this.getChildren().clear();
        for (int i = 0; i < values.size(); ++i) {
            UIFormInputBase uiInput = this.createUIFormInput(i);
            uiInput.setValue(values.get(i));
        }
        return this;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = uiForm.getSubmitAction();
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event == null) {
            return;
        }
        event.broadcast();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            this.createUIFormInput(0);
        }
        Writer writer = context.getWriter();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        int size = this.getChildren().size();
        ResourceBundle res = context.getApplicationResourceBundle();
        String addItem = "Add Item";
        String removeItem = "Remove Item";
        try {
            addItem = res.getString("UIFormMultiValueInputSet.label.addItem");
            removeItem = res.getString("UIFormMultiValueInputSet.label.removeItem");
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < size; ++i) {
            UIFormInputBase uiInput = (UIFormInputBase)this.getChild(i);
            writer.append("<div class=\"MultiValueContainer\">");
            uiInput.processRender(context);
            if (i == size - 1) {
                if (size >= 2) {
                    writer.append("<a href=\"");
                    writer.append(uiForm.event("Remove", this.getId() + String.valueOf(i))).append("\" title=\"" + removeItem + "\">");
                    writer.append("<img class=\"MultiFieldAction Remove16x16Icon\" src=\"/eXoResources/skin/sharedImages/Blank.gif\" ></a>");
                }
                writer.append("<a href=\"");
                writer.append(uiForm.event("Add", this.getId())).append("\" title=\"" + addItem + "\">");
                writer.append("<img class=\"MultiFieldAction AddNewNodeIcon\" src=\"/eXoResources/skin/sharedImages/Blank.gif\" ></a>");
            }
            writer.append("</div>");
        }
    }

    public UIFormInputBase createUIFormInput(int idx) throws Exception {
        Class<?>[] classes = this.constructor_.getParameterTypes();
        Object[] params = new Object[classes.length];
        params[0] = this.getId() + String.valueOf(idx);
        UIFormInputBase inputBase = (UIFormInputBase)this.constructor_.newInstance(params);
        this.addChild((UIComponent)inputBase);
        return inputBase;
    }
}

