/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.webui.popup.UIAddressBookForm;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAddressBookForm.gtmpl", events={@EventConfig(listeners={AddNewGroupActionListener.class}), @EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={EditContactActionListener.class}), @EventConfig(listeners={ChangeGroupActionListener.class}), @EventConfig(listeners={CheckContactActionListener.class}), @EventConfig(listeners={SelectContactActionListener.class}), @EventConfig(listeners={SendEmailActionListener.class}), @EventConfig(listeners={DeleteContactActionListener.class}, confirm="UIAddressBookForm.msg.confirm-remove-contact"), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={SendMultiEmailActionListener.class})})
public class UIAddressBookForm
extends UIForm
implements UIPopupComponent {
    public static final String ALL_GROUP = "All group".intern();
    public static final String SELECT_GROUP = "select-group".intern();
    private Contact selectedContact;
    LinkedHashMap<String, Contact> contactMap_ = new LinkedHashMap();
    List<Contact> contactList_ = new ArrayList();
    HashMap<String, String> checkedContactMap = new LinkedHashMap();
    private String sharedContacts_ = "sharedContacts";

    public UIAddressBookForm() throws Exception {
        UIFormSelectBoxWithGroups uiSelectGroup = new UIFormSelectBoxWithGroups(SELECT_GROUP, SELECT_GROUP, this.getOptions());
        uiSelectGroup.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)uiSelectGroup);
        this.refrestContactList((String)uiSelectGroup.getValue());
    }

    public boolean havePermission(String groupId) throws Exception {
        String currentUser = MailUtils.getCurrentUser();
        AddressBook sharedGroup = ((ContactService)this.getApplicationComponent(ContactService.class)).getSharedAddressBook(currentUser, groupId);
        if (sharedGroup == null) {
            return false;
        }
        if (sharedGroup.getEditPermissionUsers() != null && Arrays.asList(sharedGroup.getEditPermissionUsers()).contains(currentUser + DataStorage.HYPHEN)) {
            return true;
        }
        String[] editPerGroups = sharedGroup.getEditPermissionGroups();
        if (editPerGroups != null) {
            for (String editPer : editPerGroups) {
                if (!MailUtils.getUserGroups().contains(editPer)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean havePermission(Contact contact) throws Exception {
        if (!contact.getContactType().equals(DataStorage.SHARED)) {
            return true;
        }
        String currentUser = MailUtils.getCurrentUser();
        if (contact.getEditPermissionUsers() != null && Arrays.asList(contact.getEditPermissionUsers()).contains(currentUser + DataStorage.HYPHEN)) {
            return true;
        }
        String[] editPerGroups = contact.getEditPermissionGroups();
        if (editPerGroups != null) {
            for (String editPer : editPerGroups) {
                if (!MailUtils.getUserGroups().contains(editPer)) continue;
                return true;
            }
        }
        return !((String)((UIFormSelectBoxWithGroups)this.getChild(UIFormSelectBoxWithGroups.class)).getValue()).equals(this.sharedContacts_) && this.havePermission((String)((UIFormSelectBoxWithGroups)this.getChild(UIFormSelectBoxWithGroups.class)).getValue());
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public List<SelectItem> getOptions() throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        SelectOptionGroup personalContacts = new SelectOptionGroup("personal-contacts");
        for (AddressBook pcg : contactSrv.getGroups(username)) {
            personalContacts.addOption(new SelectOption(pcg.getName(), pcg.getId()));
        }
        options.add((SelectItem)personalContacts);
        SelectOptionGroup sharedContacts = new SelectOptionGroup("shared-contacts");
        for (SharedAddressBook scg : contactSrv.getSharedAddressBooks(username)) {
            sharedContacts.addOption(new SelectOption(MailUtils.getDisplayAdddressShared((String)scg.getSharedUserId(), (String)scg.getName()), scg.getId()));
        }
        sharedContacts.addOption(new SelectOption(this.sharedContacts_, this.sharedContacts_));
        options.add((SelectItem)sharedContacts);
        return options;
    }

    public Contact getSelectedContact() {
        return this.selectedContact;
    }

    public void setSelectedContact(Contact contact) {
        this.selectedContact = contact;
    }

    public HashMap<String, String> getCheckedContactMap() {
        return this.checkedContactMap;
    }

    public void flipFlopCheckedContactMap(String contactId) {
        for (Map.Entry entry : this.checkedContactMap.entrySet()) {
            if (!((String)entry.getKey()).equals(contactId)) continue;
            if (((String)entry.getValue()).equals("0")) {
                this.checkedContactMap.put(entry.getKey(), "1");
                break;
            }
            this.checkedContactMap.put(entry.getKey(), "0");
            break;
        }
    }

    public boolean isCheckedContact(String contactId) {
        for (Map.Entry entry : this.checkedContactMap.entrySet()) {
            if (!((String)entry.getKey()).equals(contactId)) continue;
            return !((String)entry.getValue()).equals("0");
        }
        return false;
    }

    public DownloadService getDownloadService() {
        return (DownloadService)this.getApplicationComponent(DownloadService.class);
    }

    public List<Contact> getContacts() throws Exception {
        return this.contactList_;
    }

    public void refrestContactList(String groupId) throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        List contactList = new ArrayList();
        ContactFilter ctFilter = new ContactFilter();
        ctFilter.setOrderBy("fullName");
        ctFilter.setAscending(true);
        if (groupId != null && groupId.trim().length() > 0) {
            SelectOptionGroup privateGroups = (SelectOptionGroup)((UIFormSelectBoxWithGroups)this.getChild(UIFormSelectBoxWithGroups.class)).getOptions().get(0);
            for (SelectOption option : privateGroups.getOptions()) {
                if (!option.getValue().equals(groupId)) continue;
                ctFilter.setType(DataStorage.PERSONAL);
                break;
            }
            if (ctFilter.getType() == null) {
                ctFilter.setType(DataStorage.SHARED);
            }
            if (!groupId.equals(this.sharedContacts_)) {
                ctFilter.setCategories(new String[]{groupId});
            } else {
                ctFilter.setSearchSharedContacts(true);
            }
            contactList = contactSrv.searchContact(username, ctFilter).getAll();
        } else {
            ctFilter.setType(DataStorage.PERSONAL);
            ctFilter.setCategories(new String[]{((SelectOption)((SelectOptionGroup)((UIFormSelectBoxWithGroups)this.getChild(UIFormSelectBoxWithGroups.class)).getOptions().get(0)).getOptions().get(0)).getValue()});
            contactList = contactSrv.searchContact(username, ctFilter).getAll();
        }
        this.contactMap_.clear();
        this.checkedContactMap.clear();
        for (Contact ct : contactList) {
            this.contactMap_.put(ct.getId(), ct);
            this.checkedContactMap.put(ct.getId(), "0");
        }
        this.contactList_ = new ArrayList(this.contactMap_.values());
        if (this.contactList_.size() > 0) {
            this.selectedContact = (Contact)this.contactList_.get(0);
            this.checkedContactMap.put(this.selectedContact.getId(), "1");
        } else {
            this.selectedContact = null;
        }
    }

    public void updateGroup(String selectedGroup) throws Exception {
        ((UIFormSelectBoxWithGroups)this.getChildById(SELECT_GROUP)).setOptions(this.getOptions());
        ((UIFormSelectBoxWithGroups)this.getChildById(SELECT_GROUP)).setValue(selectedGroup);
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ String access$000(UIAddressBookForm x0) {
        return x0.sharedContacts_;
    }
}

