/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.webui.CalendarUtils;
import org.exoplatform.mail.webui.Selector;
import org.exoplatform.mail.webui.UIFormComboBox;
import org.exoplatform.mail.webui.UIFormDateTimePicker;
import org.exoplatform.mail.webui.popup.UIEventDetailTab;
import org.exoplatform.mail.webui.popup.UIEventForm;
import org.exoplatform.mail.webui.popup.UIEventReminderTab;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormTabPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddEmailAddressActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DownloadAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)})
public class UIEventForm
extends UIFormTabPane
implements UIPopupComponent,
Selector {
    public static final String TAB_EVENTDETAIL = "eventDetail".intern();
    public static final String TAB_EVENTREMINDER = "eventReminder".intern();
    public static final String TAB_EVENTSHARE = "eventShare".intern();
    public static final String TAB_EVENTATTENDER = "eventAttender".intern();
    public static final String FIELD_SHARE = "shareEvent".intern();
    public static final String FIELD_STATUS = "status".intern();
    public static final String FIELD_MEETING = "meeting".intern();
    public static final String FIELD_PARTICIPANT = "participant".intern();
    public static final String ITEM_PUBLIC = "public".intern();
    public static final String ITEM_PRIVATE = "private".intern();
    public static final String ITEM_AVAILABLE = "available".intern();
    public static final String ITEM_BUSY = "busy".intern();
    public static final String ITEM_REPEAT = "true".intern();
    public static final String ITEM_UNREPEAT = "false".intern();
    public static final String ACT_REMOVE = "RemoveAttachment".intern();
    public static final String ACT_DOWNLOAD = "DownloadAttachment".intern();
    public static final String ACT_ADDEMAIL = "AddEmailAddress".intern();
    public static final String ACT_ADDCATEGORY = "AddCategory".intern();
    public boolean isAddNew_ = true;
    protected String calType_ = "0";
    private String errorMsg_ = null;

    public UIEventForm() throws Exception {
        super("UIEventForm");
        UIEventDetailTab eventDetailTab = new UIEventDetailTab(TAB_EVENTDETAIL);
        this.addChild((UIComponent)eventDetailTab);
        this.setSelectedTab(eventDetailTab.getId());
        UIEventReminderTab eventReminderTab = new UIEventReminderTab(TAB_EVENTREMINDER);
        this.addChild((UIComponent)eventReminderTab);
    }

    public String getLabel(String id) {
        String label = id;
        try {
            label = super.getLabel(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return label;
    }

    public void reset() {
        super.reset();
    }

    public void initForm(CalendarSetting calSetting, CalendarEvent eventCalendar) throws Exception {
        this.reset();
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        List fromTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat());
        List toTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat());
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME).setOptions(fromTimes);
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME).setOptions(toTimes);
        if (eventCalendar != null) {
            this.isAddNew_ = false;
            this.setEventSumary(eventCalendar.getSummary());
            this.setEventDescription(eventCalendar.getDescription());
            this.setEventAllDate(CalendarUtils.isAllDayEvent((CalendarEvent)eventCalendar));
            this.setEventFromDate(eventCalendar.getFromDateTime());
            this.setEventToDate(eventCalendar.getToDateTime());
            UIFormSelectBox selectBox = eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
            boolean hasEventCategory = false;
            String eventCategoryName = eventCalendar.getEventCategoryName();
            for (SelectItemOption o : selectBox.getOptions()) {
                if (!o.getLabel().equalsIgnoreCase(eventCategoryName)) continue;
                hasEventCategory = true;
                this.setSelectedCategory((String)o.getValue());
                break;
            }
            if (!hasEventCategory && !MailUtils.isFieldEmpty((String)eventCategoryName)) {
                CalendarService calService = (CalendarService)this.getApplicationComponent(CalendarService.class);
                EventCategory eventCategory = new EventCategory();
                eventCategory.setName(eventCategoryName);
                calService.saveEventCategory(MailUtils.getCurrentUser(), eventCategory, true);
                selectBox.getOptions().add(new SelectItemOption(eventCategory.getName(), (Object)eventCategory.getId()));
                this.setSelectedCategory(eventCategory.getId());
            }
            this.setEventPlace(eventCalendar.getLocation());
            this.setEventRepeat(eventCalendar.getRepeatType());
            this.setSelectedEventPriority(eventCalendar.getPriority());
            this.setEventReminders(eventCalendar.getReminders());
            this.setAttachments(eventCalendar.getAttachment());
        } else {
            java.util.Calendar cal = GregorianCalendar.getInstance();
            int beginMinute = cal.get(12) / 15 * 15;
            cal.set(12, beginMinute);
            this.setEventFromDate(cal.getTime());
            cal.add(12, 30);
            this.setEventToDate(cal.getTime());
        }
    }

    public void update(String calType, List<SelectItem> options) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        if (options != null) {
            ((UIFormSelectBoxWithGroups)uiEventDetailTab.getChildById(UIEventDetailTab.FIELD_CALENDAR)).setOptions(options);
        } else {
            ((UIFormSelectBoxWithGroups)uiEventDetailTab.getChildById(UIEventDetailTab.FIELD_CALENDAR)).setOptions(UIEventForm.getCalendarOption());
        }
        this.calType_ = calType;
    }

    public static List<SelectItem> getCalendarOption() throws Exception {
        List lgcd;
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = Util.getPortalRequestContext().getRemoteUser();
        SelectOptionGroup privGrp = new SelectOptionGroup("privateCalendar");
        List calendars = calendarService.getUserCalendars(username, true);
        for (Calendar c : calendars) {
            if (c.getId().equals(Utils.getDefaultCalendarId((String)username)) && c.getName().equals("defaultCalendarName")) {
                String newName = CalendarUtils.getResourceBundle((String)"UIEventForm.label.defaultCalendarId");
                c.setName(newName);
            }
            privGrp.addOption(new SelectOption(c.getName(), CalendarUtils.PRIVATE_TYPE + CalendarUtils.COLON + c.getId()));
        }
        options.add((SelectItem)privGrp);
        GroupCalendarData gcd = calendarService.getSharedCalendars(username, true);
        if (gcd != null) {
            SelectOptionGroup sharedGrp = new SelectOptionGroup("sharedCalendar");
            for (Calendar c : gcd.getCalendars()) {
                if (!CalendarUtils.canEdit(null, (String[])c.getEditPermission(), (String)username)) continue;
                if (c.getId().equals(Utils.getDefaultCalendarId((String)username)) && c.getName().equals("defaultCalendarName")) {
                    String newName = CalendarUtils.getResourceBundle((String)"UIEventForm.label.defaultCalendarId");
                    c.setName(newName);
                }
                String owner = "";
                if (c.getCalendarOwner() != null) {
                    owner = c.getCalendarOwner() + "- ";
                }
                sharedGrp.addOption(new SelectOption(owner + c.getName(), CalendarUtils.SHARED_TYPE + CalendarUtils.COLON + c.getId()));
            }
            options.add((SelectItem)sharedGrp);
        }
        if ((lgcd = calendarService.getGroupCalendars(CalendarUtils.getUserGroups((String)username), true, username)) != null) {
            OrganizationService oService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            SelectOptionGroup pubGrp = new SelectOptionGroup("publicCalendar");
            for (GroupCalendarData g : lgcd) {
                for (Calendar c : g.getCalendars()) {
                    if (!CalendarUtils.canEdit((OrganizationService)oService, (String[])c.getEditPermission(), (String)username)) continue;
                    pubGrp.addOption(new SelectOption(c.getName(), CalendarUtils.PUBLIC_TYPE + CalendarUtils.COLON + c.getId()));
                }
            }
            options.add((SelectItem)pubGrp);
        }
        return options;
    }

    public static List<SelectItemOption<String>> getCategory() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List eventCategories = calendarService.getEventCategories(Util.getPortalRequestContext().getRemoteUser());
        for (EventCategory category : eventCategories) {
            if (category.getId().contains("defaultEventCategoryId") && category.getName().contains("defaultEventCategoryName")) {
                String newName = CalendarUtils.getResourceBundle((String)("UIEventForm.label." + category.getId()));
                options.add((SelectItemOption<String>)new SelectItemOption(newName, (Object)category.getId()));
                continue;
            }
            options.add((SelectItemOption<String>)new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        return options;
    }

    protected void refreshCategory() throws Exception {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setOptions(UIEventForm.getCategory());
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateValue(String selectField, String value) {
    }

    protected boolean isEventDetailValid() {
        Date from = null;
        Date to = null;
        if (CalendarUtils.isEmpty((String)this.getEventSumary())) {
            this.errorMsg_ = "UIEventForm.msg.event-summary-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getCalendarId())) {
            this.errorMsg_ = "UIEventForm.msg.event-calendar-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventCategory())) {
            this.errorMsg_ = "UIEventForm.msg.event-category-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventFormDateValue())) {
            this.errorMsg_ = "UIEventForm.msg.event-fromdate-required";
            return false;
        }
        try {
            from = this.getEventFromDate();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg_ = "UIEventForm.msg.event-fromdate-notvalid";
            return false;
        }
        try {
            to = this.getEventToDate();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg_ = "UIEventForm.msg.event-todate-notvalid";
            return false;
        }
        if (from.after(to) || from.equals(to)) {
            this.errorMsg_ = "UIEventForm.msg.event-date-time-logic";
            return false;
        }
        this.errorMsg_ = null;
        return true;
    }

    private boolean isReminderValid() throws Exception {
        if (this.getEmailReminder()) {
            if (CalendarUtils.isEmpty((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-required";
                return false;
            }
            if (!CalendarUtils.isAllEmailValid((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-invalid";
                return false;
            }
        }
        this.errorMsg_ = null;
        return true;
    }

    protected String getEventSumary() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).getValue();
    }

    protected void setEventSumary(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).setValue((Object)value);
    }

    protected String getEventDescription() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).getValue();
    }

    protected void setEventDescription(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).setValue((Object)value);
    }

    protected String getCalendarId() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        String value = (String)((UIFormSelectBoxWithGroups)eventDetailTab.getChildById(UIEventDetailTab.FIELD_CALENDAR)).getValue();
        if (!CalendarUtils.isEmpty((String)value) && value.split(CalendarUtils.COLON).length > 0) {
            this.calType_ = value.split(CalendarUtils.COLON)[0];
            return value.split(CalendarUtils.COLON)[1];
        }
        return value;
    }

    public void setSelectedCalendarId(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        value = this.calType_ + CalendarUtils.COLON + value;
        ((UIFormSelectBoxWithGroups)eventDetailTab.getChildById(UIEventDetailTab.FIELD_CALENDAR)).setValue(value);
    }

    protected String getEventCategory() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).getValue();
    }

    protected void setSelectedCategory(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setValue(value);
    }

    protected Date getEventFromDate() throws Exception {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME);
        if (this.getEventAllDate()) {
            SimpleDateFormat df = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
            return CalendarUtils.getBeginDay((Date)df.parse((String)fromField.getValue())).getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat(CalendarUtils.DATETIMEFORMAT);
        return df.parse((String)fromField.getValue() + " " + (String)timeField.getValue());
    }

    protected String getEventFormDateValue() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        return (String)fromField.getValue();
    }

    protected void setEventFromDate(Date date) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME);
        SimpleDateFormat df = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
        fromField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(CalendarUtils.TIMEFORMAT);
        timeField.setValue((Object)df.format(date));
    }

    protected Date getEventToDate() throws Exception {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME);
        if (this.getEventAllDate()) {
            SimpleDateFormat df = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
            df.setCalendar(CalendarUtils.getInstanceTempCalendar());
            return CalendarUtils.getEndDay((Date)df.parse((String)toField.getValue())).getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat(CalendarUtils.DATETIMEFORMAT);
        return df.parse((String)toField.getValue() + " " + (String)timeField.getValue());
    }

    protected void setEventToDate(Date date) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME);
        SimpleDateFormat df = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
        toField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(CalendarUtils.TIMEFORMAT);
        timeField.setValue((Object)df.format(date));
    }

    protected String getEventToDateValue() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        return (String)toField.getValue();
    }

    protected boolean getEventAllDate() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).isChecked();
    }

    protected void setEventAllDate(boolean isCheckAll) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).setChecked(isCheckAll);
    }

    protected String getEventRepeat() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).getValue();
    }

    protected void setEventRepeat(String type) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).setValue(type);
    }

    protected String getEventPlace() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).getValue();
    }

    protected void setEventPlace(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).setValue((Object)value);
    }

    protected boolean getEmailReminder() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTREMINDER);
        return eventDetailTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).isChecked();
    }

    protected void setEmailReminder(boolean isChecked) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTREMINDER);
        eventDetailTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).setChecked(isChecked);
    }

    protected String getEmailReminderTime() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventDetailTab.getUIStringInput(UIEventReminderTab.EMAIL_REMIND_BEFORE).getValue();
    }

    protected void setEmailReminderTime(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTREMINDER);
        eventDetailTab.getUIStringInput(UIEventReminderTab.EMAIL_REMIND_BEFORE).setValue((Object)value);
    }

    protected String getEmailAddress() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventDetailTab.getUIFormTextAreaInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).getValue();
    }

    protected void setEmailAddress(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTREMINDER);
        eventDetailTab.getUIFormTextAreaInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).setValue((Object)value);
    }

    protected void setEventReminders(List<Reminder> reminders) {
        if (reminders != null) {
            for (Reminder r : reminders) {
                if (!Reminder.TYPE_EMAIL.equals(r.getReminderType())) continue;
                this.setEmailReminder(true);
                this.setEmailAddress(r.getEmailAddress());
                this.setEmailReminderTime(String.valueOf(r.getAlarmBefore()));
            }
        }
    }

    protected String getEmailRemindBefore() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REMIND_BEFORE).getValue();
    }

    protected String isEmailRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_IS_REPEAT).getValue();
    }

    protected String getEmailRepeatInterVal() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).getValue();
    }

    protected List<Reminder> getEventReminders(Date fromDateTime, List<Reminder> currentReminders) {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        if (this.getEmailReminder()) {
            Reminder email = new Reminder();
            if (currentReminders != null) {
                for (Reminder rm : currentReminders) {
                    if (!rm.getReminderType().equals(Reminder.TYPE_EMAIL)) continue;
                    email = rm;
                    break;
                }
            }
            email.setReminderType(Reminder.TYPE_EMAIL);
            email.setAlarmBefore(Long.parseLong(this.getEmailRemindBefore()));
            email.setEmailAddress(this.getEmailAddress());
            email.setRepeate(Boolean.parseBoolean(this.isEmailRepeat()));
            email.setRepeatInterval(Long.parseLong(this.getEmailRepeatInterVal()));
            email.setFromDateTime(fromDateTime);
            reminders.add(email);
        }
        return reminders;
    }

    protected String getEventPriority() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).getValue();
    }

    protected void setSelectedEventPriority(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).setValue(value);
    }

    protected long getTotalAttachment() {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        long attSize = 0L;
        for (Attachment att : uiEventDetailTab.getAttachments()) {
            attSize += att.getSize();
        }
        return attSize;
    }

    public Attachment getAttachment(String attId) {
        UIEventDetailTab uiDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        for (Attachment att : uiDetailTab.getAttachments()) {
            if (!att.getId().equals(attId)) continue;
            return att;
        }
        return null;
    }

    protected List<Attachment> getAttachments() {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        return uiEventDetailTab.getAttachments();
    }

    protected void setAttachments(List<Attachment> attachment) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        uiEventDetailTab.setAttachments(attachment);
        uiEventDetailTab.refreshUploadFileList();
    }

    static /* synthetic */ String access$000(UIEventForm x0) {
        return x0.errorMsg_;
    }

    static /* synthetic */ boolean access$100(UIEventForm x0) throws Exception {
        return x0.isReminderValid();
    }
}

