/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CalendarUtils {
    public static final String PRIVATE_CALENDARS = "privateCalendar".intern();
    public static final String SHARED_CALENDARS = "sharedCalendar".intern();
    public static final String PUBLIC_CALENDARS = "publicCalendar".intern();
    public static final String PRIVATE_TYPE = "0".intern();
    public static final String SHARED_TYPE = "1".intern();
    public static final String PUBLIC_TYPE = "2".intern();
    public static final String ANY = "*.*".intern();
    public static final String ANY_OF = "*.".intern();
    public static final String DOT = ".".intern();
    public static final String SEMICOLON = ";".intern();
    public static final String COLON = ",".intern();
    public static final String COMMA = ",".intern();
    public static final String COLON_SLASH = ":/".intern();
    public static final String SLASH_COLON = "/:".intern();
    public static final String STAR = "*".intern();
    public static final String UNDERSCORE = "_".intern();
    public static final String DOUBLESCORE = "--".intern();
    public static final int DENY = 0;
    public static final int ACCEPT = 1;
    public static final int NOTSURE = 2;
    public static final String TIMEFORMAT = "HH:mm".intern();
    public static final String DATEFORMAT = "MM/dd/yyyy".intern();
    public static final String DATETIMEFORMAT = DATEFORMAT + " " + TIMEFORMAT;
    public static final int DEFAULT_TIMEITERVAL = 15;
    public static final long MILISECONS_OF_DAY = 86400000L;
    public static final String SLASH = "/".intern();
    public static final String BACKSLASH = "\\".intern();
    public static final String GREATER_THAN = ">".intern();
    public static final String SMALLER_THAN = "<".intern();
    public static final String[] EXTENDEDCHARACTER = new String[]{SEMICOLON, COMMA, SLASH, BACKSLASH, "'", "|", GREATER_THAN, SMALLER_THAN, "\"", "?", "!", "@", "#", "$", "%", "^", "&", "*", "+", "]", "["};
    public static final String[] SIMPLECHARACTER = new String[]{GREATER_THAN, SMALLER_THAN};

    public static String[] getUserGroups(String username) throws Exception {
        OrganizationService organization = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        Object[] objs = organization.getGroupHandler().findGroupsOfUser(username).toArray();
        String[] groups = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groups[i] = ((Group)objs[i]).getId();
        }
        return groups;
    }

    public static String[] getAllGroups() throws Exception {
        OrganizationService organization = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        Object[] objs = organization.getGroupHandler().getAllGroups().toArray();
        String[] groups = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groups[i] = ((Group)objs[i]).getId();
        }
        return groups;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static CalendarService getCalendarService() throws Exception {
        return (CalendarService)PortalContainer.getComponent(CalendarService.class);
    }

    public static OrganizationService getOrganizationService() throws Exception {
        return (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String timeFormat) {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        java.util.Calendar cal = CalendarUtils.getBeginDay((java.util.Calendar)GregorianCalendar.getInstance());
        SimpleDateFormat df = new SimpleDateFormat(timeFormat);
        SimpleDateFormat df2 = new SimpleDateFormat(TIMEFORMAT);
        int time = 0;
        while (time++ < 96) {
            options.add((SelectItemOption<String>)new SelectItemOption(df.format(cal.getTime()), (Object)df2.format(cal.getTime())));
            cal.add(12, 15);
        }
        return options;
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String timeFormat, int timeInteval) {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        java.util.Calendar cal = CalendarUtils.getBeginDay((java.util.Calendar)GregorianCalendar.getInstance());
        SimpleDateFormat df = new SimpleDateFormat(timeFormat);
        SimpleDateFormat df2 = new SimpleDateFormat(TIMEFORMAT);
        int time = 0;
        while (time++ < 1440 / timeInteval) {
            options.add((SelectItemOption<String>)new SelectItemOption(df.format(cal.getTime()), (Object)df2.format(cal.getTime())));
            cal.add(12, timeInteval);
        }
        return options;
    }

    public static String parse(Date date, String timeFormat) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(timeFormat);
        return df.format(date);
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static boolean isAllDayEvent(CalendarEvent eventCalendar) {
        GregorianCalendar cal1 = new GregorianCalendar();
        GregorianCalendar cal2 = new GregorianCalendar();
        cal1.setTime(eventCalendar.getFromDateTime());
        cal2.setTime(eventCalendar.getToDateTime());
        return cal1.get(11) == 0 && cal1.get(12) == 0 && cal2.get(11) == 0 && cal2.get(12) == 0;
    }

    public static boolean isSameDate(java.util.Calendar date1, java.util.Calendar date2) {
        return date1.get(5) == date2.get(5) && date1.get(2) == date2.get(2) && date1.get(1) == date2.get(1);
    }

    public static boolean isSameDate(Date value1, Date value2) {
        java.util.Calendar date1 = GregorianCalendar.getInstance();
        date1.setTime(value1);
        java.util.Calendar date2 = GregorianCalendar.getInstance();
        date2.setTime(value2);
        return CalendarUtils.isSameDate((java.util.Calendar)date1, (java.util.Calendar)date2);
    }

    public static java.util.Calendar getBeginDay(java.util.Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static java.util.Calendar getEndDay(java.util.Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(11, 24);
        return cal;
    }

    public static java.util.Calendar getBeginDay(Date date) {
        java.util.Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        return CalendarUtils.getBeginDay((java.util.Calendar)cal);
    }

    public static java.util.Calendar getEndDay(Date date) {
        java.util.Calendar cal = CalendarUtils.getInstanceTempCalendar();
        cal.setTime(date);
        return CalendarUtils.getEndDay((java.util.Calendar)cal);
    }

    public static String getImageSource(Attachment attach, DownloadService dservice) throws Exception {
        if (attach != null) {
            InputStream input = attach.getInputStream();
            byte[] imageBytes = null;
            if (input != null) {
                imageBytes = new byte[input.available()];
                input.read(imageBytes);
                ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
                InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
                dresource.setDownloadName(attach.getName());
                return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
            }
        }
        return null;
    }

    public static List<SelectItemOption<String>> getCalendarOption() throws Exception {
        List lgcd;
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = Util.getPortalRequestContext().getRemoteUser();
        options.add(new SelectItemOption(PRIVATE_CALENDARS, (Object)""));
        List calendars = calendarService.getUserCalendars(username, true);
        for (Calendar c : calendars) {
            if (c.getId().equals(Utils.getDefaultCalendarId((String)username)) && c.getName().equals("defaultCalendarName")) {
                String newName = CalendarUtils.getResourceBundle((String)"UIEventForm.label.defaultCalendarId");
                c.setName(newName);
            }
            options.add((SelectItemOption<String>)new SelectItemOption(DOUBLESCORE + c.getName(), (Object)(PRIVATE_TYPE + COLON + c.getId())));
        }
        GroupCalendarData gcd = calendarService.getSharedCalendars(username, true);
        if (gcd != null) {
            options.add(new SelectItemOption(SHARED_CALENDARS, (Object)""));
            for (Calendar c : gcd.getCalendars()) {
                if (!CalendarUtils.canEdit(null, (String[])Utils.getEditPerUsers((Calendar)c), (String)username)) continue;
                if (c.getId().equals(Utils.getDefaultCalendarId((String)c.getCalendarOwner())) && c.getName().equals("defaultCalendarName")) {
                    String newName = CalendarUtils.getResourceBundle((String)"UIEventForm.label.defaultCalendarId");
                    c.setName(newName);
                }
                options.add((SelectItemOption<String>)new SelectItemOption(DOUBLESCORE + c.getName(), (Object)(SHARED_TYPE + COLON + c.getId())));
            }
        }
        if ((lgcd = calendarService.getGroupCalendars(CalendarUtils.getUserGroups((String)username), false, username)) != null) {
            OrganizationService oService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            options.add((SelectItemOption<String>)new SelectItemOption(PUBLIC_CALENDARS, (Object)""));
            for (GroupCalendarData g : lgcd) {
                for (Calendar c : g.getCalendars()) {
                    if (!CalendarUtils.canEdit((OrganizationService)oService, (String[])c.getEditPermission(), (String)username)) continue;
                    options.add((SelectItemOption<String>)new SelectItemOption(DOUBLESCORE + c.getName(), (Object)(PUBLIC_TYPE + COLON + c.getId())));
                }
            }
        }
        return options;
    }

    public static boolean hasEditPermission(String[] savePerms, String[] checkPerms) {
        if (savePerms != null) {
            for (String sp : savePerms) {
                for (String cp : checkPerms) {
                    if (!sp.equals(cp)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean canEdit(OrganizationService oService, String[] savePerms, String username) throws Exception {
        StringBuffer sb = new StringBuffer(username);
        if (oService != null) {
            Collection memberShipsType = oService.getMembershipHandler().findMembershipsByUser(username);
            Collection groups = oService.getGroupHandler().findGroupsOfUser(username);
            for (Group g : groups) {
                sb.append(COMMA).append(g.getId()).append(SLASH_COLON).append(ANY);
                sb.append(COMMA).append(g.getId()).append(SLASH_COLON).append(username);
                for (Membership mp : memberShipsType) {
                    sb.append(COMMA).append(g.getId()).append(SLASH_COLON).append(ANY_OF + mp.getMembershipType());
                }
            }
        }
        return CalendarUtils.hasEditPermission((String[])savePerms, (String[])sb.toString().split(COMMA));
    }

    public static boolean isNameValid(String name, String[] regexpression) {
        for (String c : regexpression) {
            if (!name.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmailValid(String value) {
        String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
        return value != null && value.trim().length() > 0 && value.trim().matches(emailRegex);
    }

    public static boolean isAllEmailValid(String addressList) {
        boolean isValid;
        block2: {
            isValid = true;
            if (CalendarUtils.isEmpty((String)addressList)) {
                return false;
            }
            int i$ = 0;
            String[] arr$ = addressList.split(COMMA);
            int len$ = arr$.length;
            if (i$ >= len$) break block2;
            String s = arr$[i$];
            if (!CalendarUtils.isEmailValid((String)(s = s.trim()))) {
                isValid = false;
            }
        }
        return isValid;
    }

    public static java.util.Calendar getInstanceTempCalendar() {
        java.util.Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static String getResourceBundle(String key) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            return null;
        }
    }
}

