/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.common.webui.UIPopupAction;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.MessagePageList;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.CalendarUtils;
import org.exoplatform.mail.webui.UIActionBar;
import org.exoplatform.mail.webui.UIFolderContainer;
import org.exoplatform.mail.webui.UIMessageArea;
import org.exoplatform.mail.webui.UIMessageList;
import org.exoplatform.mail.webui.UIMessagePreview;
import org.exoplatform.mail.webui.UINavigationContainer;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.mail.webui.UITagContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/mail/webui/UIMailPortlet.gtmpl")
public class UIMailPortlet
extends UIPortletApplication {
    private String formId = "";

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public UIMailPortlet() throws Exception {
        this.addChild(UIActionBar.class, null, null);
        this.addChild(UINavigationContainer.class, null, null);
        String accId = ((UISelectAccount)((UINavigationContainer)this.getChild(UINavigationContainer.class)).getChild(UISelectAccount.class)).getSelectedValue();
        UIMessageArea uiMessageArea = (UIMessageArea)this.createUIComponent(UIMessageArea.class, null, null);
        uiMessageArea.init(accId);
        uiMessageArea.setMailSetting(this.getMailSetting());
        this.addChild((UIComponent)uiMessageArea);
        this.addChild(UIPopupAction.class, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String isAjax = portalContext.getRequestParameter("ajaxRequest");
        if (isAjax != null && Boolean.parseBoolean(isAjax)) {
            super.processRender(app, context);
            return;
        }
        String url = portalContext.getRequest().getRequestURL().toString();
        try {
            MailService mailService = MailUtils.getMailService();
            String username = MailUtils.getCurrentUser();
            String[] content = url.split("/");
            int length = content.length;
            String account = content[length - 4];
            if (mailService.getAccountById(username, account) == null) {
                throw new PathNotFoundException();
            }
            String folder = content[length - 3];
            String tag = content[length - 2];
            String msgId = URLDecoder.decode(content[length - 1], "UTF-8");
            UISelectAccount uiSelectAccount = (UISelectAccount)((UINavigationContainer)this.getChild(UINavigationContainer.class)).getChild(UISelectAccount.class);
            uiSelectAccount.setSelectedValue(account);
            UIMessageArea uiMessageArea = (UIMessageArea)this.getChild(UIMessageArea.class);
            uiMessageArea.init(account);
            MessageFilter filter = new MessageFilter("Folder");
            if (!Utils.isEmptyField((String)folder) && !folder.equals("_")) {
                UIFolderContainer uiFolderContainer = (UIFolderContainer)this.findFirstComponentOfType(UIFolderContainer.class);
                uiFolderContainer.setSelectedFolder(folder);
                filter.setFolder(new String[]{folder});
            } else if (!Utils.isEmptyField((String)tag) && !tag.equals("_")) {
                UITagContainer uiTagContainer = (UITagContainer)this.findFirstComponentOfType(UITagContainer.class);
                uiTagContainer.setSelectedTagId(tag);
                filter.setTag(new String[]{tag});
            }
            UIMessageList uiMessageList = (UIMessageList)this.findFirstComponentOfType(UIMessageList.class);
            boolean isFound = false;
            filter.setAccountId(account);
            MessagePageList currentPageList = mailService.getMessagePageList(username, filter);
            uiMessageList.setMessagePageList(currentPageList);
            int page = 1;
            while ((long)page <= currentPageList.getAvailablePage()) {
                List messList = currentPageList.getPage((long)page, MailUtils.getCurrentUser());
                for (Message message : messList) {
                    if (!message.getId().equals(msgId)) continue;
                    uiMessageList.updateList((long)page);
                    message.setUnread(false);
                    uiMessageList.messageList_.put(msgId, message);
                    uiMessageList.setSelectedMessageId(msgId);
                    UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)uiMessageList.getChildById(msgId);
                    if (uiCheckbox != null) {
                        uiCheckbox.setChecked(true);
                    }
                    ArrayList<Message> showedMessages = new ArrayList<Message>();
                    showedMessages.add(message);
                    mailService.toggleMessageProperty(username, account, showedMessages, folder, Utils.EXO_ISUNREAD, false);
                    UIMessagePreview uiMessagePreview = (UIMessagePreview)this.findFirstComponentOfType(UIMessagePreview.class);
                    message = MailUtils.getMailService().loadTotalMessage(MailUtils.getCurrentUser(), account, message);
                    uiMessagePreview.setMessage(message);
                    uiMessagePreview.setShowedMessages(showedMessages);
                    isFound = true;
                }
                if (isFound) break;
                ++page;
            }
            context.addUIComponentToUpdateByAjax((UIComponent)this);
        }
        catch (PathNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            super.processRender(app, context);
        }
    }

    public String getAccountId() {
        return ((UISelectAccount)((UINavigationContainer)this.getChild(UINavigationContainer.class)).getChild(UISelectAccount.class)).getSelectedValue();
    }

    public String getCurrentUser() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public long getPeriodCheckAuto() throws Exception {
        Long period = this.getMailSetting().getPeriodCheckAuto() * 60L * 1000L;
        return period;
    }

    public MailSetting getMailSetting() throws Exception {
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        return mailSrv.getMailSetting(this.getCurrentUser());
    }

    public void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public String getRemoteUser() throws Exception {
        return CalendarUtils.getCurrentUser();
    }

    public String getUserToken() throws Exception {
        ContinuationService continuation = (ContinuationService)this.getApplicationComponent(ContinuationService.class);
        try {
            return continuation.getUserToken(this.getRemoteUser());
        }
        catch (Exception e) {
            System.out.println("\n\n can not get UserToken");
            return "";
        }
    }

    public String getRestContextName() {
        return PortalContainer.getInstance().getRestContextName();
    }

    protected String getCometdContextName() {
        String cometdContextName = "cometd";
        try {
            EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
            return bayeux == null ? "cometd" : bayeux.getCometdContextName();
        }
        catch (Exception exception) {
            return cometdContextName;
        }
    }

    public void showMessage(Event event) {
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        uiApp.addMessage(new ApplicationMessage("UISelectAccount.msg.account-list-no-permission", null));
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
    }
}

