/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.cs.common.webui.UIPopupComponent;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.webui.popup.UIDelegationInputSet;
import org.exoplatform.mail.webui.popup.UIMailLayoutTab;
import org.exoplatform.mail.webui.popup.UIMailSettings;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIMailSettings.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddAccountActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE)})
public class UIMailSettings
extends UIFormTabPane
implements UIPopupComponent {
    public static final String DEFAULT_ACCOUNT = "default-account".intern();
    public static final String NUMBER_MSG_PER_PAGE = "number-of-conversation".intern();
    public static final String PERIOD_CHECK_AUTO = "period-check-mail".intern();
    public static final String COMPOSE_MESSAGE_IN = "compose-message-in".intern();
    public static final String REPLY_WITH_ATTACH = "reply-message-with".intern();
    public static final String FORWARD_WITH_ATTACH = "forward-message-with".intern();
    public static final String SAVE_SENT_MESSAGE = "save-sent-message".intern();
    public static final String SENT_RECEIPT_ASKME = "askme".intern();
    public static final String SENT_RECEIPT_NEVER = "never".intern();
    public static final String SENT_RECEIPT_ALWAYS = "always".intern();
    public static final String RETURN_RECEIPTS = "returnReceipts".intern();
    public static final String TAB_GENERAL = "general".intern();
    public static final String TAB_RETURN_RECEIPT = "return-receipt".intern();
    public static final String TAB_LAYOUT = "layout".intern();
    public static final String TAB_ACCOUNT_DELEGATION = "account-delegation".intern();
    public static final String FIELD_OWNER_ACCOUNTS = "owner-accounts".intern();
    public static final String FIELD_DELEGATED_ACCOUNTS = "delegated-accounts".intern();
    public static final String FIELD_PRIVILEGE_FULL = "full-privilege".intern();
    public static final String FIELD_PRIVILEGE_READONLY = "readonly-pivilege".intern();

    public UIMailSettings() throws Exception {
        super("UIMailSettings");
    }

    public void init() throws Exception {
        UIFormInputSet generalInputSet = new UIFormInputSet(TAB_GENERAL);
        generalInputSet.addUIFormInput((UIFormInput)new UIFormSelectBox(DEFAULT_ACCOUNT, DEFAULT_ACCOUNT, this.getAccounts()));
        ArrayList<SelectItemOption> numberPerPage = new ArrayList<SelectItemOption>();
        String username = MailUtils.getCurrentUser();
        for (int i = 1; i <= 7; ++i) {
            numberPerPage.add(new SelectItemOption((Object)String.valueOf(10 * i)));
        }
        generalInputSet.addUIFormInput((UIFormInput)new UIFormSelectBox(NUMBER_MSG_PER_PAGE, NUMBER_MSG_PER_PAGE, numberPerPage));
        ArrayList<SelectItemOption> periodCheckAuto = new ArrayList<SelectItemOption>();
        periodCheckAuto.add(new SelectItemOption("Never", (Object)("period." + String.valueOf(0L))));
        periodCheckAuto.add(new SelectItemOption("5 minutes", (Object)("period." + String.valueOf(5L))));
        periodCheckAuto.add(new SelectItemOption("10 minutes", (Object)("period." + String.valueOf(10L))));
        periodCheckAuto.add(new SelectItemOption("20 minutes", (Object)("period." + String.valueOf(20L))));
        periodCheckAuto.add(new SelectItemOption("30 minutes", (Object)("period." + String.valueOf(30L))));
        periodCheckAuto.add(new SelectItemOption("1 hour", (Object)("period." + String.valueOf(60L))));
        generalInputSet.addUIFormInput((UIFormInput)new UIFormSelectBox(PERIOD_CHECK_AUTO, PERIOD_CHECK_AUTO, periodCheckAuto));
        ArrayList<SelectItemOption> useWysiwyg = new ArrayList<SelectItemOption>();
        useWysiwyg.add(new SelectItemOption("Rich text editor (HTML format)", (Object)"editor.true"));
        useWysiwyg.add(new SelectItemOption("Plain text", (Object)"editor.false"));
        generalInputSet.addUIFormInput((UIFormInput)new UIFormSelectBox(COMPOSE_MESSAGE_IN, COMPOSE_MESSAGE_IN, useWysiwyg));
        ArrayList<SelectItemOption> replyWithAtt = new ArrayList<SelectItemOption>();
        replyWithAtt.add(new SelectItemOption("Original message included attachment", (Object)"replywith.true"));
        replyWithAtt.add(new SelectItemOption("Original message", (Object)"replywith.false"));
        generalInputSet.addUIFormInput((UIFormInput)new UIFormSelectBox(REPLY_WITH_ATTACH, REPLY_WITH_ATTACH, replyWithAtt));
        ArrayList<SelectItemOption> forwardWithAtt = new ArrayList<SelectItemOption>();
        forwardWithAtt.add(new SelectItemOption("Original message included attachment", (Object)"forwardwith.true"));
        forwardWithAtt.add(new SelectItemOption("Original message", (Object)"forwardwith.false"));
        generalInputSet.addUIFormInput((UIFormInput)new UIFormSelectBox(FORWARD_WITH_ATTACH, FORWARD_WITH_ATTACH, forwardWithAtt));
        generalInputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(SAVE_SENT_MESSAGE, SAVE_SENT_MESSAGE, (Object)false));
        UIMailLayoutTab layoutInputSet = new UIMailLayoutTab(TAB_LAYOUT);
        UIFormInputSet returnReceiptInputSet = new UIFormInputSet(TAB_RETURN_RECEIPT);
        ArrayList<SelectItemOption> returnReceiptOptions = new ArrayList<SelectItemOption>();
        returnReceiptOptions.add(new SelectItemOption(SENT_RECEIPT_ASKME, (Object)SENT_RECEIPT_ASKME));
        returnReceiptOptions.add(new SelectItemOption(SENT_RECEIPT_NEVER, (Object)SENT_RECEIPT_NEVER));
        returnReceiptOptions.add(new SelectItemOption(SENT_RECEIPT_ALWAYS, (Object)SENT_RECEIPT_ALWAYS));
        returnReceiptInputSet.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(RETURN_RECEIPTS, RETURN_RECEIPTS, returnReceiptOptions).setAlign(UIFormRadioBoxInput.VERTICAL_ALIGN));
        UIDelegationInputSet accountDelegate = new UIDelegationInputSet(TAB_ACCOUNT_DELEGATION);
        UIFormSelectBox ownerAccounts = new UIFormSelectBox(FIELD_OWNER_ACCOUNTS, FIELD_OWNER_ACCOUNTS, this.getOwnerAccs(username));
        UIFormStringInput delegatedAccounts = new UIFormStringInput(FIELD_DELEGATED_ACCOUNTS, FIELD_DELEGATED_ACCOUNTS, null);
        UIFormCheckBoxInput fullPrivilege = new UIFormCheckBoxInput(FIELD_PRIVILEGE_FULL, FIELD_PRIVILEGE_FULL, null);
        accountDelegate.addUIFormInput((UIFormInput)ownerAccounts);
        accountDelegate.addUIFormInput((UIFormInput)delegatedAccounts);
        accountDelegate.addUIFormInput((UIFormInput)fullPrivilege);
        this.addUIFormInput(generalInputSet);
        this.addUIFormInput(returnReceiptInputSet);
        this.addUIFormInput((UIFormInputSet)layoutInputSet);
        this.addUIFormInput((UIFormInputSet)accountDelegate);
        this.setSelectedTab(generalInputSet.getId());
        this.fillData();
    }

    public List<SelectItemOption<String>> getAccounts() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        for (Account acc : mailSrv.getAccounts(username)) {
            SelectItemOption itemOption = new SelectItemOption(acc.getLabel() + " &lt;" + acc.getEmailAddress() + "&gt;", (Object)acc.getId());
            options.add((SelectItemOption<String>)itemOption);
        }
        return options;
    }

    public void fillData() throws Exception {
        String username;
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        MailSetting setting = mailSrv.getMailSetting(username = Util.getPortalRequestContext().getRemoteUser());
        if (setting != null) {
            long layout = setting.getLayout();
            long sendReturnReceipt = setting.getSendReturnReceipt();
            UIFormInputSet tabGeneral = (UIFormInputSet)this.getChildById(TAB_GENERAL);
            tabGeneral.getUIFormSelectBox(DEFAULT_ACCOUNT).setValue(setting.getDefaultAccount());
            tabGeneral.getUIFormSelectBox(NUMBER_MSG_PER_PAGE).setValue(String.valueOf(setting.getNumberMsgPerPage()));
            tabGeneral.getUIFormSelectBox(PERIOD_CHECK_AUTO).setValue("period." + String.valueOf(setting.getPeriodCheckAuto()));
            tabGeneral.getUIFormSelectBox(COMPOSE_MESSAGE_IN).setValue("editor." + String.valueOf(setting.useWysiwyg()));
            tabGeneral.getUIFormSelectBox(REPLY_WITH_ATTACH).setValue("replywith." + String.valueOf(setting.replyWithAttach()));
            tabGeneral.getUIFormSelectBox(FORWARD_WITH_ATTACH).setValue("forwardwith." + String.valueOf(setting.forwardWithAtt()));
            tabGeneral.getUIFormCheckBoxInput(SAVE_SENT_MESSAGE).setChecked(setting.saveMessageInSent());
            UIFormInputSet returnReceipts = (UIFormInputSet)this.getChildById(TAB_RETURN_RECEIPT);
            if (sendReturnReceipt == 0L) {
                ((UIFormRadioBoxInput)returnReceipts.getChildById(RETURN_RECEIPTS)).setValue((Object)SENT_RECEIPT_ASKME);
            } else if (sendReturnReceipt == 1L) {
                ((UIFormRadioBoxInput)returnReceipts.getChildById(RETURN_RECEIPTS)).setValue((Object)SENT_RECEIPT_NEVER);
            } else if (sendReturnReceipt == 2L) {
                ((UIFormRadioBoxInput)returnReceipts.getChildById(RETURN_RECEIPTS)).setValue((Object)SENT_RECEIPT_ALWAYS);
            }
            UIFormInputSet tabLayout = (UIFormInputSet)this.getChildById(TAB_LAYOUT);
            if (layout == 0L) {
                ((UIFormRadioBoxInput)tabLayout.getChildById("UIMailSettings-VerticalLayout")).setValue((Object)"vertical-layout");
            } else if (layout == 1L) {
                ((UIFormRadioBoxInput)tabLayout.getChildById("UIMailSettings-HorizontalLayout")).setValue((Object)"horizontal-layout");
            } else if (layout == 2L) {
                ((UIFormRadioBoxInput)tabLayout.getChildById("UIMailSettings-NosplitLayout")).setValue((Object)"nosplit-layout");
            }
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<SelectItemOption<String>> getOwnerAccs(String username) {
        List accs = null;
        try {
            accs = MailUtils.getMailService().getAccounts(username);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<SelectItemOption<String>> ownAccs = new ArrayList<SelectItemOption<String>>();
        SelectItemOption accountOpt = null;
        if (accs != null && accs.size() > 0) {
            for (Account acc : accs) {
                accountOpt = new SelectItemOption(acc.getUserDisplayName(), (Object)acc.getId());
                ownAccs.add((SelectItemOption<String>)accountOpt);
            }
        }
        return ownAccs;
    }
}

