/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.mail.webui.UIFormInputWithActions;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class UIFormInputWithActions
extends UIFormInputSet {
    private Log log = ExoLogger.getLogger(this.getClass());
    Map<String, List<ActionData>> actionField = new HashMap();

    public UIFormInputWithActions(String id) {
        super.setId(id);
    }

    public void setActionField(String fieldName, List<ActionData> actions) throws Exception {
        this.actionField.put(fieldName, actions);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getComponentConfig() != null) {
            super.processRender(context);
            return;
        }
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        Writer w = context.getWriter();
        w.write("<div id=\"" + this.getId() + "\" class=\"UIFormInputSet " + this.getId() + "\">");
        w.write("<table class=\"UIFormGrid\">");
        ResourceBundle res = context.getApplicationResourceBundle();
        for (UIComponent inputEntry : this.getChildren()) {
            String label;
            try {
                label = uiForm.getLabel(res, inputEntry.getId());
                if (inputEntry instanceof UIFormInputBase) {
                    ((UIFormInputBase)inputEntry).setLabel(label);
                }
            }
            catch (MissingResourceException ex) {
                label = inputEntry.getId();
                System.err.println("\n " + uiForm.getId() + ".label." + inputEntry.getId() + " not found value");
            }
            w.write("<tr>");
            if (!(inputEntry instanceof UIFormCheckBoxInput)) {
                w.write("<td class=\"FieldLabel\" style=\"text-align: left\">");
                w.write(label);
                w.write("</td>");
                w.write("<td class=\"FieldComponent\">");
                this.renderUIComponent(inputEntry);
            } else {
                w.write("<td class=\"FieldComponent\" style=\"text-align:left\" colspan=\"2\">");
                this.renderUIComponent(inputEntry);
            }
            List actions = (List)this.actionField.get(inputEntry.getName());
            if (actions != null) {
                for (ActionData action : actions) {
                    String actionLabel;
                    try {
                        actionLabel = uiForm.getLabel(res, "action." + action.getActionName());
                    }
                    catch (MissingResourceException ex) {
                        actionLabel = action.getActionName();
                        this.log.warn((Object)("\n Key: '" + uiForm.getId() + ".label.action." + action.getActionName() + "' not found"));
                    }
                    String actionLink = action.getActionParameter() != null ? this.getParent().event(action.getActionListener(), action.getActionParameter()) : this.getParent().event(action.getActionListener());
                    w.write("<a title=\"" + actionLabel + "\" href=\"" + actionLink + "\">");
                    if (action.getActionType() == 0) {
                        w.write("<img src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" class=\"" + action.getCssIconClass() + "\"/>");
                        if (ActionData.access$000((ActionData)action)) {
                            w.write(actionLabel);
                        }
                    } else if (action.getActionType() == 1) {
                        w.write(actionLabel);
                    }
                    w.write("</a>");
                    w.write("&nbsp;");
                    if (!action.isBreakLine()) continue;
                    w.write("<br/>");
                }
            }
            if (inputEntry instanceof UIFormCheckBoxInput) {
                w.write("<span class=\"FieldLabel\"> &nbsp;&nbsp;&nbsp;");
                w.write(label);
                w.write("</span>");
            }
            w.write("</td>");
            w.write("</tr>");
        }
        w.write("</table>");
        w.write("</div>");
    }
}

