/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISelectFolder
extends UIFormInputSet {
    private static final Log log = ExoLogger.getExoLogger(UISelectFolder.class);
    public static final String SELECT_FOLDER = "folder";
    public String level = "";
    public String accountId_ = "";

    public void init(String accountId) throws Exception {
        this.setId("UISelectFolder");
        this.accountId_ = accountId;
        this.addUIFormInput((UIFormInput)new UIFormSelectBoxWithGroups(SELECT_FOLDER, SELECT_FOLDER, this.getOptions()));
    }

    public void setSelectedValue(String s) {
        ((UIFormSelectBoxWithGroups)this.getChildById(SELECT_FOLDER)).setValue(s);
    }

    public String getSelectedValue() {
        return (String)((UIFormSelectBoxWithGroups)this.getChildById(SELECT_FOLDER)).getValue();
    }

    public List<Folder> getDefaultFolders() throws Exception {
        return this.getFolders(false);
    }

    public List<Folder> getCustomizeFolders() throws Exception {
        return this.getFolders(true);
    }

    public List<Folder> getSubFolders(String parentPath) throws Exception {
        MailService mailSvr = MailUtils.getMailService();
        String username = MailUtils.getCurrentUser();
        ArrayList<Folder> subFolders = new ArrayList<Folder>();
        for (Folder f : mailSvr.getSubFolders(username, this.accountId_, parentPath)) {
            subFolders.add(f);
        }
        return subFolders;
    }

    public List<Folder> getFolders(boolean isPersonal) throws Exception {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
        String username = MailUtils.getCurrentUser();
        try {
            folders.addAll(mailSvr.getFolders(username, this.accountId_, isPersonal));
        }
        catch (Exception e) {
            // empty catch block
        }
        return folders;
    }

    public SelectOptionGroup addChildOption(String folderPath, SelectOptionGroup optionList) throws Exception {
        this.level = this.level + "----";
        for (Folder cf : this.getSubFolders(folderPath)) {
            if (cf == null) continue;
            optionList.addOption(new SelectOption(this.level + " " + cf.getName(), cf.getId()));
            if (this.getSubFolders(cf.getPath()).size() <= 0) continue;
            optionList = this.addChildOption(cf.getPath(), optionList);
        }
        this.level = this.level.substring(0, this.level.length() - 4);
        return optionList;
    }

    protected UIForm getUIForm() {
        return (UIForm)this.getAncestorOfType(UIForm.class);
    }

    public List<SelectItem> getOptions() throws Exception {
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        SelectOptionGroup defaultFolders = new SelectOptionGroup("default-folder");
        for (Folder df : this.getDefaultFolders()) {
            defaultFolders.addOption(new SelectOption(this.getUIForm().getLabel(df.getName()), df.getId()));
        }
        options.add((SelectItem)defaultFolders);
        SelectOptionGroup customizeFolders = new SelectOptionGroup("my-folder");
        for (Folder cf : this.getCustomizeFolders()) {
            customizeFolders.addOption(new SelectOption(cf.getName(), cf.getId()));
            if (this.getSubFolders(cf.getPath()).size() <= 0) continue;
            customizeFolders = this.addChildOption(cf.getPath(), customizeFolders);
        }
        options.add((SelectItem)customizeFolders);
        return options;
    }
}

