/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.util.Hashtable;
import java.util.List;
import org.exoplatform.mail.DataCache;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.UIFolderContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/mail/webui/UIFolderContainer.gtmpl", events={@EventConfig(listeners={ChangeFolderActionListener.class}), @EventConfig(listeners={AddFolderActionListener.class}), @EventConfig(listeners={AddSubFolderActionListener.class}), @EventConfig(listeners={RenameFolderActionListener.class}), @EventConfig(listeners={RemoveFolderActionListener.class}, confirm="UIFolderContainer.msg.confirm-remove-folder"), @EventConfig(listeners={MarkReadActionListener.class}), @EventConfig(listeners={EmptyFolderActionListener.class}), @EventConfig(listeners={MoveToTrashActionListener.class})})
public class UIFolderContainer
extends UIContainer {
    private static final Log log = ExoLogger.getLogger(UIFolderContainer.class);
    private String currentFolder_ = null;
    public int i = 1;
    private boolean isChecking_ = false;
    private Hashtable<String, Folder> folderMap = new Hashtable();

    public void init(String accountId) throws Exception {
        this.currentFolder_ = Utils.generateFID((String)accountId, (String)Utils.FD_INBOX, (boolean)false);
    }

    public String getSelectedFolder() {
        return this.currentFolder_;
    }

    public void setSelectedFolder(String folderId) {
        this.currentFolder_ = folderId;
    }

    public List<Folder> getDefaultFolders() throws Exception {
        return this.getFolders(false);
    }

    public List<Folder> getCustomizeFolders() throws Exception {
        return this.getFolders(true);
    }

    public boolean isChecking() {
        return this.isChecking_;
    }

    public void setIsChecking(boolean b) {
        this.isChecking_ = b;
    }

    public List<Folder> getSubFolders(String parentPath) throws Exception {
        DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
        String accountId = dataCache.getSelectedAccountId();
        String username = MailUtils.getDelegateFrom((String)accountId, (DataCache)dataCache);
        List folders = dataCache.getSubFolders(username, accountId, parentPath);
        for (Folder folder : folders) {
            this.folderMap.put(folder.getId(), folder);
        }
        return folders;
    }

    public Folder getFolderById(String folderId) throws Exception {
        DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
        String accountId = dataCache.getSelectedAccountId();
        String username = MailUtils.getDelegateFrom((String)accountId, (DataCache)dataCache);
        Folder folder = (Folder)this.folderMap.get(folderId);
        if (folder != null) {
            return MailUtils.getMailService().getFolder(username, accountId, folder.getPath());
        }
        return dataCache.getFolderById(username, accountId, folderId);
    }

    public Folder getCurrentFolder() throws Exception {
        return this.getFolderById(this.currentFolder_);
    }

    public List<Folder> getFolders(boolean isPersonal) throws Exception {
        DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
        String accountId = dataCache.getSelectedAccountId();
        String username = MailUtils.getDelegateFrom((String)accountId, (DataCache)dataCache);
        List folders = dataCache.getFolders(username, accountId, isPersonal);
        for (Folder folder : folders) {
            this.folderMap.put(folder.getId(), folder);
        }
        return folders;
    }

    public String[] getActions() {
        return new String[]{"AddFolder"};
    }

    public boolean isImap() throws Exception {
        try {
            DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
            String accountId = dataCache.getSelectedAccountId();
            String username = MailUtils.getDelegateFrom((String)accountId, (DataCache)dataCache);
            Account acc = dataCache.getAccountById(username, accountId);
            return Utils.IMAP.equalsIgnoreCase(acc.getProtocol());
        }
        catch (Exception e) {
            return false;
        }
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

