/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.common.webui.UIPopupAction;
import org.exoplatform.mail.DataCache;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.MessagePageList;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.CalendarUtils;
import org.exoplatform.mail.webui.UIActionBar;
import org.exoplatform.mail.webui.UIFolderContainer;
import org.exoplatform.mail.webui.UIMessageArea;
import org.exoplatform.mail.webui.UIMessageList;
import org.exoplatform.mail.webui.UIMessagePreview;
import org.exoplatform.mail.webui.UINavigationContainer;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.mail.webui.UITagContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/mail/webui/UIMailPortlet.gtmpl")
public class UIMailPortlet
extends UIPortletApplication {
    public static final Log log = ExoLogger.getExoLogger(UIMailPortlet.class);
    private String formId = "";
    private DataCache dataCache = new DataCache();

    public DataCache getDataCache() {
        return this.dataCache;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public UIMailPortlet() throws Exception {
        this.dataCache.setMailPortlet(this);
        this.addChild(UIActionBar.class, null, null);
        this.addChild(UINavigationContainer.class, null, null);
        String accId = this.dataCache.getSelectedAccountId();
        UIMessageArea uiMessageArea = (UIMessageArea)this.createUIComponent(UIMessageArea.class, null, null);
        uiMessageArea.init(accId);
        uiMessageArea.setMailSetting(this.getMailSetting());
        this.addChild((UIComponent)uiMessageArea);
        this.addChild(UIPopupAction.class, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        context.setAttribute(DataCache.class, (Object)this.dataCache);
        this.dataCache.clearCache();
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String isAjax = portalContext.getRequestParameter("ajaxRequest");
        if (isAjax != null && Boolean.parseBoolean(isAjax)) {
            super.processRender(app, context);
            return;
        }
        String url = portalContext.getRequest().getRequestURL().toString();
        try {
            String username = MailUtils.getCurrentUser();
            String[] content = url.split("/");
            int length = content.length;
            String account = content[length - 4];
            if (this.dataCache.getAccountById(username, account) == null) {
                throw new PathNotFoundException();
            }
            String folder = content[length - 3];
            String tag = content[length - 2];
            String msgId = URLDecoder.decode(content[length - 1], "UTF-8");
            UISelectAccount uiSelectAccount = (UISelectAccount)((UINavigationContainer)this.getChild(UINavigationContainer.class)).getChild(UISelectAccount.class);
            uiSelectAccount.setSelectedValue(account);
            UIMessageArea uiMessageArea = (UIMessageArea)this.getChild(UIMessageArea.class);
            uiMessageArea.init(account);
            MessageFilter filter = new MessageFilter("Folder");
            if (!Utils.isEmptyField((String)folder) && !folder.equals("_")) {
                UIFolderContainer uiFolderContainer = (UIFolderContainer)this.findFirstComponentOfType(UIFolderContainer.class);
                uiFolderContainer.setSelectedFolder(folder);
                filter.setFolder(new String[]{folder});
            } else if (!Utils.isEmptyField((String)tag) && !tag.equals("_")) {
                UITagContainer uiTagContainer = (UITagContainer)this.findFirstComponentOfType(UITagContainer.class);
                uiTagContainer.setSelectedTagId(tag);
                filter.setTag(new String[]{tag});
            }
            UIMessageList uiMessageList = (UIMessageList)this.findFirstComponentOfType(UIMessageList.class);
            boolean isFound = false;
            MailService mailService = MailUtils.getMailService();
            filter.setAccountId(account);
            MessagePageList currentPageList = mailService.getMessagePageList(username, filter);
            uiMessageList.setMessagePageList(currentPageList);
            int page = 1;
            while ((long)page <= currentPageList.getAvailablePage()) {
                List messList = currentPageList.getPage((long)page, MailUtils.getCurrentUser());
                for (Message message : messList) {
                    if (!message.getId().equals(msgId)) continue;
                    uiMessageList.updateList((long)page);
                    message.setUnread(false);
                    uiMessageList.messageList_.put(msgId, message);
                    uiMessageList.setSelectedMessageId(msgId);
                    UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)uiMessageList.getChildById(msgId);
                    if (uiCheckbox != null) {
                        uiCheckbox.setChecked(true);
                    }
                    ArrayList<Message> showedMessages = new ArrayList<Message>();
                    showedMessages.add(message);
                    mailService.toggleMessageProperty(username, account, showedMessages, folder, Utils.EXO_ISUNREAD, false);
                    UIMessagePreview uiMessagePreview = (UIMessagePreview)this.findFirstComponentOfType(UIMessagePreview.class);
                    message = MailUtils.getMailService().loadTotalMessage(MailUtils.getCurrentUser(), account, message);
                    uiMessagePreview.setMessage(message);
                    uiMessagePreview.setShowedMessages(showedMessages);
                    isFound = true;
                }
                if (isFound) break;
                ++page;
            }
            context.addUIComponentToUpdateByAjax((UIComponent)this);
        }
        catch (PathNotFoundException ex) {
            return;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in method processRender", (Throwable)ex);
            }
        }
        finally {
            super.processRender(app, context);
        }
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        context.setAttribute(DataCache.class, (Object)this.dataCache);
        this.dataCache.clearCache();
        super.processDecode(context);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.setAttribute(DataCache.class, (Object)this.dataCache);
        this.dataCache.clearCache();
        super.processRender(context);
    }

    public void processAction(WebuiRequestContext context) throws Exception {
        context.setAttribute(DataCache.class, (Object)this.dataCache);
        this.dataCache.clearCache();
        super.processAction(context);
    }

    public String getAccountId() {
        return this.dataCache.getSelectedAccountId();
    }

    public String getCurrentUser() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public long getPeriodCheckAuto() throws Exception {
        Long period = this.getMailSetting().getPeriodCheckAuto() * 60L * 1000L;
        return period;
    }

    public MailSetting getMailSetting() throws Exception {
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        return mailSrv.getMailSetting(this.getCurrentUser());
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.cancelPopupAction();
    }

    public String getRemoteUser() throws Exception {
        return CalendarUtils.getCurrentUser();
    }

    public String getUserToken() throws Exception {
        ContinuationService continuation = (ContinuationService)this.getApplicationComponent(ContinuationService.class);
        try {
            return continuation.getUserToken(this.getRemoteUser());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getRestContextName() {
        return PortalContainer.getInstance().getRestContextName();
    }

    protected String getCometdContextName() {
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
        return bayeux == null ? "cometd" : bayeux.getCometdContextName();
    }
}

