/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UISelectAccount;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCache {
    private Hashtable<String, Hashtable<String, Account>> delegatedAccountCache = new Hashtable();
    private Hashtable<String, Boolean> isAlreadyGotAllDelegatedAccount = new Hashtable();
    private Hashtable<String, Hashtable<String, Account>> accountCache = new Hashtable();
    private Hashtable<String, Boolean> isAlreadyGotAllAccount = new Hashtable();
    private Hashtable<String, Hashtable<String, Folder>> folderCache = new Hashtable();
    private Hashtable<String, List<Folder>> allFolderCache = new Hashtable();
    private Hashtable<String, Boolean> isAlreadyGotAllFolder = new Hashtable();
    private Hashtable<String, List<Folder>> subFolderCache = new Hashtable();
    private String selectedAccountId;
    private UIMailPortlet mailPortlet;

    public void setMailPortlet(UIMailPortlet mailPortlet) {
        this.mailPortlet = mailPortlet;
    }

    public void clearAccountCache() {
        this.delegatedAccountCache.clear();
        this.isAlreadyGotAllDelegatedAccount.clear();
        this.accountCache.clear();
        this.isAlreadyGotAllAccount.clear();
        this.selectedAccountId = null;
    }

    public void clearFolderCache() {
        this.folderCache.clear();
        this.allFolderCache.clear();
        this.isAlreadyGotAllFolder.clear();
        this.subFolderCache.clear();
    }

    public void clearCache() {
        this.delegatedAccountCache.clear();
        this.isAlreadyGotAllDelegatedAccount.clear();
        this.accountCache.clear();
        this.isAlreadyGotAllAccount.clear();
        this.folderCache.clear();
        this.allFolderCache.clear();
        this.isAlreadyGotAllFolder.clear();
        this.subFolderCache.clear();
        this.selectedAccountId = null;
    }

    public String getSelectedAccountId() {
        if (this.selectedAccountId == null) {
            this.selectedAccountId = ((UISelectAccount)this.mailPortlet.findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
        }
        return this.selectedAccountId;
    }

    public Account getDelegatedAccount(String username, String accountId) throws Exception {
        Account account;
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)accountId)) {
            return null;
        }
        Hashtable<String, Account> delegatedAccountMaps = (Hashtable<String, Account>)this.delegatedAccountCache.get(username);
        if (delegatedAccountMaps == null) {
            delegatedAccountMaps = new Hashtable<String, Account>();
            this.delegatedAccountCache.put(username, delegatedAccountMaps);
        }
        if ((account = (Account)delegatedAccountMaps.get(accountId)) == null && (account = MailUtils.getMailService().getDelegatedAccount(username, accountId)) != null) {
            delegatedAccountMaps.put(accountId, account);
        }
        return account;
    }

    public List<Account> getDelegatedAccounts(String userId) throws Exception {
        if (StringUtils.isEmpty((String)userId)) {
            return new ArrayList<Account>();
        }
        ArrayList<Account> delegatedAccounts = null;
        Boolean isGotAllDelegatedAccounts = (Boolean)this.isAlreadyGotAllDelegatedAccount.get(userId);
        if (isGotAllDelegatedAccounts == null) {
            delegatedAccounts = MailUtils.getMailService().getDelegatedAccounts(userId);
            Hashtable<String, Account> delegatedAccountMaps = (Hashtable<String, Account>)this.delegatedAccountCache.get(userId);
            if (delegatedAccountMaps == null) {
                delegatedAccountMaps = new Hashtable<String, Account>();
                this.delegatedAccountCache.put(userId, delegatedAccountMaps);
            }
            for (Account account : delegatedAccounts) {
                delegatedAccountMaps.put(account.getId(), account);
            }
            this.isAlreadyGotAllDelegatedAccount.put(userId, Boolean.TRUE);
        } else {
            Hashtable delegatedAccountMaps = (Hashtable)this.delegatedAccountCache.get(userId);
            delegatedAccounts = new ArrayList<Account>();
            delegatedAccounts.addAll(delegatedAccountMaps.values());
        }
        return delegatedAccounts;
    }

    public Account getAccountById(String username, String accountId) throws Exception {
        Account account;
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)accountId)) {
            return null;
        }
        Hashtable<String, Account> accountMaps = (Hashtable<String, Account>)this.accountCache.get(username);
        if (accountMaps == null) {
            accountMaps = new Hashtable<String, Account>();
            this.accountCache.put(username, accountMaps);
        }
        if ((account = (Account)accountMaps.get(accountId)) == null && (account = MailUtils.getMailService().getAccountById(username, accountId)) != null) {
            accountMaps.put(accountId, account);
        }
        return account;
    }

    public List<Account> getAccounts(String username) throws Exception {
        if (StringUtils.isEmpty((String)username)) {
            return null;
        }
        ArrayList<Account> accounts = null;
        Boolean isGotAllAccounts = (Boolean)this.isAlreadyGotAllAccount.get(username);
        if (isGotAllAccounts == null) {
            accounts = MailUtils.getMailService().getAccounts(username);
            Hashtable<String, Account> accountMaps = (Hashtable<String, Account>)this.accountCache.get(username);
            if (accountMaps == null) {
                accountMaps = new Hashtable<String, Account>();
                this.accountCache.put(username, accountMaps);
            }
            for (Account account : accounts) {
                accountMaps.put(account.getId(), account);
            }
            this.isAlreadyGotAllAccount.put(username, Boolean.TRUE);
        } else {
            Hashtable accountMaps = (Hashtable)this.accountCache.get(username);
            accounts = new ArrayList<Account>();
            accounts.addAll(accountMaps.values());
        }
        return accounts;
    }

    public Folder getFolderById(String username, String accountId, String folderId) throws Exception {
        Folder folder;
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)accountId) || StringUtils.isEmpty((String)folderId)) {
            return null;
        }
        String cacheKey = username + "_" + accountId;
        Hashtable<String, Folder> folderMaps = (Hashtable<String, Folder>)this.folderCache.get(cacheKey);
        if (folderMaps == null) {
            folderMaps = new Hashtable<String, Folder>();
            this.folderCache.put(cacheKey, folderMaps);
        }
        if ((folder = (Folder)folderMaps.get(folderId)) == null && (folder = MailUtils.getMailService().getFolderById(username, accountId, folderId)) != null) {
            folderMaps.put(folderId, folder);
        }
        return folder;
    }

    public List<Folder> getFolders(String username, String accountId) throws Exception {
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)accountId)) {
            return new ArrayList<Folder>();
        }
        String cacheKey = username + "_" + accountId;
        ArrayList<Folder> folders = null;
        Boolean isGotAllFolder = (Boolean)this.isAlreadyGotAllFolder.get(cacheKey);
        if (isGotAllFolder == null) {
            folders = MailUtils.getMailService().getFolders(username, accountId);
            Hashtable<String, Folder> folderMaps = (Hashtable<String, Folder>)this.folderCache.get(cacheKey);
            if (folderMaps == null) {
                folderMaps = new Hashtable<String, Folder>();
                this.folderCache.put(cacheKey, folderMaps);
            }
            for (Folder folder : folders) {
                folderMaps.put(folder.getId(), folder);
            }
            ArrayList<Folder> allFolders = (ArrayList<Folder>)this.allFolderCache.get(cacheKey);
            if (allFolders == null) {
                allFolders = new ArrayList<Folder>();
                this.allFolderCache.put(cacheKey, allFolders);
            }
            allFolders.clear();
            allFolders.addAll(folders);
            this.isAlreadyGotAllFolder.put(cacheKey, Boolean.TRUE);
        } else {
            List allFolders = (List)this.allFolderCache.get(cacheKey);
            folders = new ArrayList<Folder>();
            folders.addAll(allFolders);
        }
        return folders;
    }

    public List<Folder> getFolders(String username, String accountId, boolean isPersonal) throws Exception {
        List folders = this.getFolders(username, accountId);
        ArrayList<Folder> resultList = new ArrayList<Folder>();
        for (Folder folder : folders) {
            if (folder.isPersonalFolder() != isPersonal) continue;
            resultList.add(folder);
        }
        return resultList;
    }

    public List<Folder> getSubFolders(String userName, String accountId, String parentPath) throws Exception {
        if (parentPath == null) {
            return new ArrayList<Folder>();
        }
        String key = userName + "_" + accountId + "_" + parentPath;
        List subFolders = (List)this.subFolderCache.get(key);
        if (subFolders == null && (subFolders = MailUtils.getMailService().getSubFolders(userName, accountId, parentPath)) != null) {
            this.subFolderCache.put(key, subFolders);
        }
        return subFolders;
    }
}

