/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.mail.DataCache;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/UISelectAccount.gtmpl", events={@EventConfig(listeners={AddAccountActionListener.class}), @EventConfig(listeners={EditAccountActionListener.class}), @EventConfig(listeners={DeleteAccountActionListener.class}), @EventConfig(listeners={SelectAccountActionListener.class})})
public class UISelectAccount
extends UIForm {
    private static final Log log = ExoLogger.getExoLogger(UISelectAccount.class);
    public static final String FIELD_SELECT = "accSelect";
    public static String accountRefreshed = null;

    public UISelectAccount() throws Exception {
        UIFormSelectBox uiSelect = new UIFormSelectBox(FIELD_SELECT, FIELD_SELECT, this.getValues());
        uiSelect.setOnChange("SelectAccount");
        this.addChild((UIComponent)uiSelect);
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    private List<SelectItemOption<String>> getValues() throws Exception {
        DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
        MailService mailSvr = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        List accountList = new ArrayList();
        if (dataCache != null) {
            accountList = dataCache.getAccounts(username);
            accountList.addAll(dataCache.getDelegatedAccounts(username));
        } else {
            accountList = mailSvr.getAccounts(username);
            accountList.addAll(mailSvr.getDelegatedAccounts(username));
        }
        String defaultAcc = mailSvr.getMailSetting(username).getDefaultAccount();
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (Account acc : accountList) {
            SelectItemOption option = new SelectItemOption(acc.getLabel(), (Object)acc.getId());
            if (defaultAcc != null && acc.getId().equals(defaultAcc)) {
                option = new SelectItemOption(acc.getLabel() + " (" + this.getLabel("default") + ")", (Object)acc.getId());
                option.setSelected(true);
                accountRefreshed = acc.getId();
            }
            if (MailUtils.isDelegatedAccount((Account)acc, (String)username)) {
                option = new SelectItemOption(acc.getLabel() + " (" + this.getLabel("delegated") + ")", (Object)acc.getId());
                accountRefreshed = acc.getId();
            }
            options.add((SelectItemOption<String>)option);
        }
        return options;
    }

    public void updateAccount() throws Exception {
        this.getUIFormSelectBox(FIELD_SELECT).setOptions(this.getValues());
    }

    public String getSelectedValue() {
        String id = (String)((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).getValue();
        UIMailPortlet mailPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        if (mailPortlet == null) {
            return id;
        }
        DataCache dataCache = mailPortlet.getDataCache();
        try {
            String username = MailUtils.getCurrentUser();
            if (!MailUtils.isFieldEmpty((String)id) && dataCache.getAccountById(username, id) != null) {
                return id;
            }
            if (dataCache.getDelegatedAccount(username, id) != null) {
                return id;
            }
            if (!(MailUtils.isFieldEmpty((String)accountRefreshed) || dataCache.getAccountById(username, accountRefreshed) == null && dataCache.getDelegatedAccount(username, accountRefreshed) == null)) {
                return accountRefreshed;
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in getSelectedValue method", (Throwable)e);
            }
            return accountRefreshed;
        }
        return null;
    }

    public void setSelectedValue(String value) {
        ((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).setValue(value);
    }

    public void refreshItems() throws Exception {
        ((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).getOptions().clear();
        ((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).setOptions(this.getValues());
    }

    public String[] getActions() {
        return new String[]{"AddAccount", "EditAccount", "DeleteAccount"};
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

