/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.List;
import org.exoplatform.cs.common.webui.UIPopupComponent;
import org.exoplatform.mail.DataCache;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.webui.popup.UIEditTagForm;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormColorPicker;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIEditTagForm
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getExoLogger(UIEditTagForm.class);
    public static final String NEW_TAG_NAME = "newTagName";
    public static final String DESCRIPTION = "description";
    public static final String COLOR = "color";
    private String tagId;

    public UIEditTagForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_TAG_NAME, NEW_TAG_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormColorPicker(COLOR, COLOR));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null));
    }

    public String getSelectedColor() {
        return (String)((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).getValue();
    }

    public void setSelectedColor(String value) {
        ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setValue(value);
    }

    public String getTagId() throws Exception {
        return this.tagId;
    }

    public void setTag(String tagId) throws Exception {
        this.tagId = tagId;
        DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
        String accountId = dataCache.getSelectedAccountId();
        String username = MailUtils.getDelegateFrom((String)accountId, (DataCache)dataCache);
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        List tagList = mailSrv.getTags(username, accountId);
        if (tagList.isEmpty()) {
            return;
        }
        for (Tag tag : tagList) {
            if (!tag.getId().equals(tagId)) continue;
            this.getUIStringInput(NEW_TAG_NAME).setValue((Object)tag.getName());
            this.getUIFormTextAreaInput(DESCRIPTION).setValue((Object)tag.getDescription());
            ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setValue(tag.getColor());
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

