/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.List;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.webui.UIFolderContainer;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UINavigationContainer;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.mail.webui.popup.UIMessageFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIMessageFilter.gtmpl", events={@EventConfig(listeners={SelectFilterActionListener.class}), @EventConfig(listeners={AddFilterActionListener.class}), @EventConfig(listeners={EditFilterActionListener.class}), @EventConfig(listeners={DeleteFilterActionListener.class}, confirm="UIMessageFilter.msg.confirm-remove-filter"), @EventConfig(listeners={CloseActionListener.class})})
public class UIMessageFilter
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getExoLogger(UIMessageFilter.class);
    public static final String CONDITION_CONTAIN = "contains".intern();
    public static final String CONDITION_NOT_CONTAIN = "doesn't contain".intern();
    public static final String CONDITION_IS = "is".intern();
    public static final String CONDITION_NOT_IS = "isn't".intern();
    public static final String CONDITION_END_WITH = "ends with".intern();
    public static final String CONDITION_START_WITH = "starts with".intern();
    private String selectedFilterId;
    private String accountId_;

    public void init(String accountId) throws Exception {
        this.accountId_ = accountId;
        List filterList = this.getFilters();
        if (filterList != null && filterList.size() > 0) {
            this.setSelectedFilterId(((MessageFilter)filterList.get(0)).getId());
        }
    }

    public String getSelectedFilterId() {
        return this.selectedFilterId;
    }

    public void setSelectedFilterId(String filterId) {
        this.selectedFilterId = filterId;
    }

    public MessageFilter getSelectedFilter() throws Exception {
        String username = MailUtils.getCurrentUser();
        String accountId = ((UISelectAccount)((UINavigationContainer)((UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class)).getChild(UINavigationContainer.class)).getChild(UISelectAccount.class)).getSelectedValue();
        MailService mailSrv = MailUtils.getMailService();
        if (this.getSelectedFilterId() != null) {
            return mailSrv.getFilterById(username, accountId, this.getSelectedFilterId());
        }
        return null;
    }

    public List<MessageFilter> getFilters() throws Exception {
        String username = MailUtils.getCurrentUser();
        MailService mailSrv = MailUtils.getMailService();
        return mailSrv.getFilters(username, this.accountId_);
    }

    public Folder getFolder() throws Exception {
        UIMailPortlet mailPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        UIFolderContainer folderContainer = (UIFolderContainer)mailPortlet.findFirstComponentOfType(UIFolderContainer.class);
        return folderContainer.getFolderById(this.getSelectedFilter().getApplyFolder());
    }

    public Tag getTag() throws Exception {
        String username = MailUtils.getCurrentUser();
        String accountId = ((UISelectAccount)((UINavigationContainer)((UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class)).getChild(UINavigationContainer.class)).getChild(UISelectAccount.class)).getSelectedValue();
        MailService mailSrv = MailUtils.getMailService();
        return mailSrv.getTag(username, accountId, this.getSelectedFilter().getApplyTag());
    }

    public String getCondition(int i) throws Exception {
        switch (i) {
            case 0: {
                return CONDITION_CONTAIN;
            }
            case 1: {
                return CONDITION_NOT_CONTAIN;
            }
            case 2: {
                return CONDITION_IS;
            }
            case 3: {
                return CONDITION_NOT_CONTAIN;
            }
            case 4: {
                return CONDITION_START_WITH;
            }
            case 5: {
                return CONDITION_END_WITH;
            }
        }
        return CONDITION_CONTAIN;
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

