/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.rest.RESTOrganizationServiceAbstractImpl;
import org.exoplatform.services.organization.rest.xml.CountXMLEntity;
import org.exoplatform.services.organization.rest.xml.GroupListXMLEntity;
import org.exoplatform.services.organization.rest.xml.GroupXMLEntity;
import org.exoplatform.services.organization.rest.xml.UserListXMLEntity;
import org.exoplatform.services.organization.rest.xml.UserXMLEntity;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.SerializableTransformer;

@URITemplate(value="/organization/xml/")
public class RESTOrganizationServiceXMLImpl
extends RESTOrganizationServiceAbstractImpl
implements ResourceContainer {
    protected static final String XML_CONTENT_TYPE = "text/xml";

    public RESTOrganizationServiceXMLImpl(OrganizationService organizationService) {
        super(organizationService);
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/find-all/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response findUsers(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate) {
        try {
            Query query = new Query();
            query.setUserName(username);
            query.setFirstName(firstname);
            query.setLastName(lastname);
            query.setEmail(email);
            if (fromLoginDate != null) {
                try {
                    query.setFromLoginDate(DateFormat.getDateTimeInstance().parse(fromLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            if (toLoginDate != null) {
                try {
                    query.setToLoginDate(DateFormat.getDateTimeInstance().parse(toLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            ArrayList<User> list = new ArrayList<User>();
            PageList pageList = this.userHandler.findUsers(query);
            int pages = pageList.getAvailablePage();
            for (int i = 1; i <= pages; ++i) {
                list.addAll(pageList.getPage(i));
            }
            return Response.Builder.ok((Object)new UserListXMLEntity(list, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/find-all/{from}/{num}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response findUsersRange(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate, @URIParam(value="from") Integer from, @URIParam(value="num") Integer numResult) {
        try {
            Query query = new Query();
            query.setUserName(username);
            query.setFirstName(firstname);
            query.setLastName(lastname);
            query.setEmail(email);
            if (fromLoginDate != null) {
                try {
                    query.setFromLoginDate(DateFormat.getDateTimeInstance().parse(fromLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            if (toLoginDate != null) {
                try {
                    query.setToLoginDate(DateFormat.getDateTimeInstance().parse(toLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            ArrayList<User> list = new ArrayList();
            PageList pageList = this.userHandler.findUsers(query);
            pageList.setPageSize(numResult.intValue());
            int page = from / numResult + 1;
            list = pageList.getPage(page);
            return Response.Builder.ok((Object)new UserListXMLEntity(list, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/view-range/{from}/{num}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getUsersRange(@ContextParam(value="baseURI") String baseURI, @URIParam(value="from") Integer from, @URIParam(value="num") Integer numResult) {
        try {
            ArrayList<User> list = new ArrayList();
            PageList pageList = this.userHandler.getUserPageList(numResult.intValue());
            int page = from / numResult + 1;
            list = pageList.getPage(page);
            return Response.Builder.ok((Object)new UserListXMLEntity(list, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/count/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getUsersCount() {
        try {
            int number = this.userHandler.getUserPageList(20).getAvailable();
            return Response.Builder.ok((Object)new CountXMLEntity(number, "users"), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/info/{username}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getUser(@URIParam(value="username") String username) {
        try {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User '" + username + "' not found.").build();
            }
            return Response.Builder.ok((Object)new UserXMLEntity(user), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/info/{groupId}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroup(@ContextParam(value="baseURI") String baseURI, @URIParam(value="groupId") String groupId) {
        try {
            groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                return Response.Builder.withStatus((int)404).errorMessage("Group '" + groupId + "' not found.").build();
            }
            ArrayList<User> members = new ArrayList<User>();
            PageList pageList = this.userHandler.findUsersByGroup(groupId);
            int pages = pageList.getAvailablePage();
            for (int i = 1; i <= pages; ++i) {
                members.addAll(pageList.getPage(i));
            }
            return Response.Builder.ok((Object)new GroupXMLEntity(group, members, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/view-all/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroups(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="parentId") String parentId) {
        try {
            Collection groups = null;
            if (parentId != null && parentId.length() > 0) {
                Group parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId);
                if (parent == null) {
                    return Response.Builder.withStatus((int)404).errorMessage("Parent '" + parentId + "' not found.").build();
                }
                groups = this.groupHandler.findGroups(parent);
            } else {
                groups = this.groupHandler.findGroups(null);
            }
            return Response.Builder.ok((Object)new GroupListXMLEntity(groups, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/count/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroupsCount() {
        try {
            int number = this.groupHandler.getAllGroups().size();
            return Response.Builder.ok((Object)new CountXMLEntity(number, "groups"), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/groups-for-user/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroupsOfUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username) {
        try {
            if (this.userHandler.findUserByName(username) == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User '" + username + "' not found.").build();
            }
            Collection groups = this.groupHandler.findGroupsOfUser(username);
            return Response.Builder.ok((Object)new GroupListXMLEntity(groups, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/view-from-to/{from}/{to}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroupsRange(@ContextParam(value="baseURI") String baseURI, @URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount, @QueryParam(value="parentId") String parentId) {
        try {
            Collection groups = null;
            if (parentId != null && parentId.length() > 0) {
                Group parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId);
                if (parent == null) {
                    return Response.Builder.withStatus((int)404).errorMessage("Parent '" + parentId + "' not found.").build();
                }
                groups = this.groupHandler.findGroups(parent);
            } else {
                groups = this.groupHandler.findGroups(null);
            }
            Integer amount_ = amount;
            if (amount > groups.size()) {
                amount_ = groups.size();
            }
            return Response.Builder.ok((Object)new GroupListXMLEntity(new ArrayList(groups).subList(offset, amount_), baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }
}

