/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupListXMLEntity
implements StreamingOutput {
    private static final Log log = ExoLogger.getExoLogger(GroupListXMLEntity.class);
    private final Collection<Group> groupList_;
    private final String baseURI_;

    public GroupListXMLEntity(Collection<Group> groupList, String baseURI) {
        this.groupList_ = groupList;
        this.baseURI_ = baseURI;
    }

    public void write(OutputStream _out) throws IOException {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter xsw = outputFactory.createXMLStreamWriter(_out);
            xsw.writeStartDocument();
            xsw.writeStartElement("groups");
            xsw.writeDefaultNamespace("http://exoplatform.org/organization/rest");
            xsw.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
            for (Group g : this.groupList_) {
                xsw.writeStartElement("group");
                xsw.writeAttribute("http://www.w3.org/1999/xlink", "href", this.baseURI_ + "/organization/group/" + "?output=xml&groupId=" + g.getId().replaceFirst("/", "") + "&command=info");
                xsw.writeAttribute("groupId", g.getId());
                xsw.writeCharacters(g.getGroupName());
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in method write", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }
}

