/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.impl.ContactEventListener;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.ext.impl.ContactDataInitialize;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

public class ContactSpaceActivityPublisher
extends ContactEventListener {
    private Log LOG = ExoLogger.getLogger(ContactSpaceActivityPublisher.class);

    public void saveContact(String username, Contact contact) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            String addrBookId = contact.getAddressBook()[0];
            if (addrBookId == null || addrBookId.indexOf(ContactDataInitialize.ADDRESSBOOK_ID_PREFIX) < 0) {
                return;
            }
            String msg = "A new contact has been added : " + contact.getFullName();
            String body = "add new contact ...";
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            String spaceId = addrBookId.split(ContactDataInitialize.ADDRESSBOOK_ID_PREFIX)[1];
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
            activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Can not record Activity for space when contact added " + e.getMessage()));
        }
    }

    public void updateContact(String username, Contact contact) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            String addrBookId = contact.getAddressBook()[0];
            if (addrBookId == null || addrBookId.indexOf(ContactDataInitialize.ADDRESSBOOK_ID_PREFIX) < 0) {
                return;
            }
            String msg = "The following contact has been updated: " + contact.getFullName();
            String body = "update contact...";
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            String spaceId = addrBookId.split(ContactDataInitialize.ADDRESSBOOK_ID_PREFIX)[1];
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
            activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Can not record Activity for space when contact updated " + e.getMessage()));
        }
    }
}

