/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl.xmlschema;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeGroupDefinition;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSNotationDeclaration;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSComplexTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModelGroup;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSNamedMap;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSNamespaceItem;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSNamespaceItemList;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSObjectList;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSParticle;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSStringList;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXSModel
implements XSModel,
Cloneable {
    private static final Logger log = Logger.getLogger(JBossXSModel.class);
    private AnonymousMapper anonymousMapper = new AnonymousMapper();
    private boolean qualifiedElements = false;
    private NamespaceRegistry namespaceRegistry = new NamespaceRegistry();
    protected XSNamespaceItemList nslist = null;
    protected HashMap<String, JBossXSNamespaceItem> nsimap = new HashMap();

    public JBossXSModel clone() throws CloneNotSupportedException {
        return (JBossXSModel)super.clone();
    }

    public StringList getNamespaces() {
        return new JBossXSStringList(this.nsimap.keySet());
    }

    public XSNamespaceItemList getNamespaceItems() {
        this.nslist = new JBossXSNamespaceItemList(this.nsimap.values());
        JBossXSNamespaceItem nsxsd = new JBossXSNamespaceItem("http://www.w3.org/2001/XMLSchema", this.namespaceRegistry, this.qualifiedElements);
        ((JBossXSNamespaceItemList)this.nslist).addItem(nsxsd);
        return this.nslist;
    }

    public XSNamedMap getComponents(short objectType) {
        JBossXSNamedMap map = new JBossXSNamedMap();
        JBossXSStringList sl = (JBossXSStringList)this.getNamespaces();
        int len = sl != null ? sl.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            String ns = sl.item(i);
            JBossXSNamespaceItem ni = this.nsimap.get(ns);
            JBossXSNamedMap nm = null;
            if (ni == null) continue;
            nm = (JBossXSNamedMap)ni.getComponents(objectType);
            map.addItems(nm.toList());
        }
        return map;
    }

    public XSNamedMap getComponentsByNamespace(short objectType, String namespace) {
        JBossXSNamedMap map = new JBossXSNamedMap();
        JBossXSNamespaceItem ni = this.nsimap.get(namespace);
        if (ni == null) {
            return map;
        }
        return ni.getComponents(objectType);
    }

    public XSObjectList getAnnotations() {
        ArrayList lst = new ArrayList();
        JBossXSObjectList objlist = new JBossXSObjectList(lst);
        Set<String> keyset = this.nsimap.keySet();
        for (String ns : keyset) {
            XSNamespaceItem xs = this.nsimap.get(ns);
            objlist.addObjects(xs.getAnnotations());
        }
        return objlist;
    }

    public XSElementDeclaration getElementDeclaration(String name, String namespace) {
        if (name == null) {
            return null;
        }
        if (name.startsWith(">") || name.endsWith("]")) {
            return this.anonymousMapper.getElementDeclaration(name, namespace);
        }
        JBossXSNamespaceItem ni = this.nsimap.get(namespace);
        if (ni == null) {
            return null;
        }
        return ni.getElementDeclaration(name);
    }

    public XSAttributeDeclaration getAttributeDeclaration(String name, String namespace) {
        JBossXSNamespaceItem ni = this.nsimap.get(namespace);
        if (ni == null) {
            return null;
        }
        return ni.getAttributeDeclaration(name);
    }

    public XSTypeDefinition getTypeDefinition(String name, String namespace) {
        if (name == null) {
            return null;
        }
        if (name.startsWith(">") || name.endsWith("]")) {
            return this.anonymousMapper.getTypeDefinition(name, namespace);
        }
        JBossXSNamespaceItem ni = this.nsimap.get(namespace);
        if (ni == null) {
            return null;
        }
        return ni.getTypeDefinition(name);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String name, String namespace) {
        return null;
    }

    public XSModelGroupDefinition getModelGroupDefinition(String name, String namespace) {
        return null;
    }

    public XSNotationDeclaration getNotationDeclaration(String name, String namespace) {
        return null;
    }

    public void addXSAnnotation(XSAnnotation xa) {
        String ns = xa.getNamespace();
        if (ns == null && this.nsimap.keySet().size() == 1) {
            ns = this.nsimap.keySet().iterator().next();
        }
        if (ns != null) {
            this.createNamespaceItemIfNotExistent(ns);
            JBossXSNamespaceItem jbnm = this.nsimap.get(ns);
            jbnm.addXSAnnotation(xa);
        } else {
            log.trace((Object)"Cannot assign XSAnnotation to null namespace");
        }
    }

    public void addXSAttributeDeclaration(XSAttributeDeclaration attr) {
        String ns = attr.getNamespace();
        JBossXSNamespaceItem jbnm = this.createNamespaceItemIfNotExistent(ns);
        jbnm.addXSAttributeDeclaration(attr);
    }

    public void addXSTypeDefinition(XSTypeDefinition xst) {
        String ns = xst.getNamespace();
        if (ns == null) {
            throw new WSException("Illegal namespace:null");
        }
        JBossXSNamespaceItem jbnm = this.createNamespaceItemIfNotExistent(ns);
        jbnm.addXSTypeDefinition(xst);
        this.anonymousMapper.rebuild();
    }

    public void addXSComplexTypeDefinition(XSTypeDefinition xst) {
        this.addXSTypeDefinition(xst);
        this.anonymousMapper.rebuild();
    }

    public void addXSElementDeclaration(XSElementDeclaration xsel) {
        String ns = xsel.getNamespace();
        JBossXSNamespaceItem jbnm = this.createNamespaceItemIfNotExistent(ns);
        jbnm.addXSElementDeclaration(xsel);
        this.anonymousMapper.rebuild();
    }

    public void addSchemaLocation(String nsURI, URL locationURL) {
        JBossXSNamespaceItem ni = this.createNamespaceItemIfNotExistent(nsURI);
        ni.addDocumentLocation(locationURL.toExternalForm());
    }

    public void addXSNamespaceItem(XSNamespaceItem xsitem) {
        ((JBossXSNamespaceItemList)this.nslist).addItem(xsitem);
        this.anonymousMapper.rebuild();
    }

    public void setXSNamespaceItemList(XSNamespaceItemList list) {
        this.nslist = list;
    }

    public void merge(JBossXSModel xsm) {
        JBossXSNamespaceItemList jxsm = (JBossXSNamespaceItemList)xsm.getNamespaceItems();
        int len = jxsm.getLength();
        for (int i = 0; i < len; ++i) {
            JBossXSNamespaceItem ni = (JBossXSNamespaceItem)jxsm.item(i);
            String sns = ni.getSchemaNamespace();
            JBossXSNamespaceItem mynsi = this.nsimap.get(sns);
            if (mynsi != null) {
                mynsi.merge(ni);
                continue;
            }
            this.nsimap.put(sns, ni);
            ni.setNamespaceRegistry(this.namespaceRegistry);
        }
        NamespaceRegistry xsmRegistry = xsm.getNamespaceRegistry();
        Iterator iter = xsmRegistry.getRegisteredPrefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String ns = xsmRegistry.getNamespaceURI(prefix);
            this.namespaceRegistry.registerURI(ns, prefix);
        }
        this.anonymousMapper.rebuild();
    }

    public void removeXSTypeDefinition(XSTypeDefinition xst) {
        String ns = xst.getNamespace();
        JBossXSNamespaceItem ni = this.nsimap.get(ns);
        ni.removeXSTypeDefinition(xst);
        this.anonymousMapper.rebuild();
    }

    public JBossXSNamespaceItem getNamespaceItem(String nsuri) {
        return this.nsimap.get(nsuri);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.serialize().getBytes());
    }

    public String serialize() {
        StringBuilder sb = this.serializeNamespaceItems();
        sb.insert(0, "<root>");
        sb.append("</root>");
        String xsModelString = sb.toString();
        if (xsModelString.length() > 0) {
            try {
                Element root = DOMUtils.parse((String)xsModelString);
                xsModelString = this.getChildNodesSerialized(root);
            }
            catch (IOException e) {
                log.error((Object)("Cannot parse xsModelString: " + xsModelString), (Throwable)e);
            }
        }
        return xsModelString;
    }

    public Map<String, XSTypeDefinition> getAnonymousTypes() {
        return this.anonymousMapper.getTypes();
    }

    public Map<String, XSElementDeclaration> getAnonymousElements() {
        return this.anonymousMapper.getElements();
    }

    public boolean isQualifiedElements() {
        return this.qualifiedElements;
    }

    public void setQualifiedElements(boolean qualifiedElements) {
        this.qualifiedElements = qualifiedElements;
        for (JBossXSNamespaceItem item : this.nsimap.values()) {
            item.setQualifiedElements(qualifiedElements);
        }
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public void eagerInitialize() {
        this.anonymousMapper.build();
    }

    private String registerNamespace(String ns) {
        String prefix = this.namespaceRegistry.getPrefix(ns);
        if (prefix != null) {
            return prefix;
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(ns)) {
            prefix = "xml";
        }
        return this.namespaceRegistry.registerURI(ns, prefix);
    }

    private JBossXSNamespaceItem createNamespaceItemIfNotExistent(String ns) {
        if (ns == null) {
            throw new IllegalArgumentException("Illegal null argument:ns");
        }
        JBossXSNamespaceItem jbnm = this.nsimap.get(ns);
        if (jbnm == null) {
            jbnm = new JBossXSNamespaceItem(ns, this.namespaceRegistry, this.qualifiedElements);
            this.nsimap.put(ns, jbnm);
            this.registerNamespace(ns);
        }
        return jbnm;
    }

    private StringBuilder serializeNamespaceItems() {
        StringBuilder sb = new StringBuilder();
        Collection<JBossXSNamespaceItem> col = this.nsimap.values();
        for (JBossXSNamespaceItem i : col) {
            String nameS = i.getSchemaNamespace();
            if ("http://www.w3.org/2001/XMLSchema".equals(nameS) || "http://schemas.xmlsoap.org/soap/encoding/".equals(nameS)) continue;
            sb.append(i.toString());
        }
        return sb;
    }

    private String getChildNodesSerialized(Element root) {
        StringBuilder sb = new StringBuilder();
        Iterator iter = DOMUtils.getChildElements((Node)root);
        while (iter != null && iter.hasNext()) {
            Node n = (Node)iter.next();
            sb.append(DOMWriter.printNode((Node)n, (boolean)true));
            sb.append("\n");
        }
        return sb.toString();
    }

    public XSObjectList getSubstitutionGroup(XSElementDeclaration arg0) {
        throw new NotImplementedException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnonymousMapper
    implements Serializable {
        private static final long serialVersionUID = 5572350092914194023L;
        private HashMap<String, XSTypeDefinition> anonymousTypeMap;
        private HashMap<String, XSElementDeclaration> anonymousElementMap;
        private HashSet<XSComplexTypeDefinition> processed = new HashSet();

        private AnonymousMapper() {
        }

        public void rebuild() {
            if (this.anonymousTypeMap != null) {
                this.build();
            }
        }

        public void build() {
            int i;
            JBossXSModel model = JBossXSModel.this;
            this.anonymousTypeMap = new HashMap();
            this.anonymousElementMap = new HashMap();
            this.processed.clear();
            XSNamedMap namedMap = model.getComponents((short)3);
            for (i = 0; i < namedMap.getLength(); ++i) {
                XSTypeDefinition type = (XSTypeDefinition)namedMap.item(i);
                if (type.getTypeCategory() != 15) continue;
                this.analyzeComplexType((XSComplexTypeDefinition)type, null, type.getNamespace());
            }
            namedMap = model.getComponents((short)2);
            for (i = 0; i < namedMap.getLength(); ++i) {
                XSElementDeclaration element = (XSElementDeclaration)namedMap.item(i);
                this.analyzeElement(element, null, element.getNamespace(), null, null);
            }
            this.processed.clear();
        }

        private void analyzeElement(XSElementDeclaration element, String parentName, String namespace, Integer minOccurs, Integer maxOccurs) {
            XSTypeDefinition type;
            String name = element.getName();
            if (element.getScope() != 1) {
                name = parentName + ">" + name;
                this.anonymousElementMap.put(namespace + ":" + name, element);
            }
            if (maxOccurs != null && maxOccurs > 1) {
                String key = namespace + ":" + name + "[" + minOccurs + "," + maxOccurs + "]";
                this.anonymousTypeMap.put(key, (XSTypeDefinition)this.createArrayWrapperComplexType(element, name, namespace, minOccurs, maxOccurs));
                if (minOccurs == 1) {
                    key = namespace + ":" + name + "[" + "," + maxOccurs + "]";
                    this.anonymousTypeMap.put(key, (XSTypeDefinition)this.createArrayWrapperComplexType(element, name, namespace, minOccurs, maxOccurs));
                }
            }
            if ((type = element.getTypeDefinition()).getTypeCategory() == 15) {
                this.analyzeComplexType((XSComplexTypeDefinition)type, name, namespace);
            }
            if (type.getTypeCategory() == 16) {
                this.analyzeSimpleType((XSSimpleTypeDefinition)type, name, namespace);
            }
        }

        private XSComplexTypeDefinition createArrayWrapperComplexType(XSElementDeclaration element, String name, String namespace, Integer minOccurs, Integer maxOccurs) {
            JBossXSComplexTypeDefinition definition = new JBossXSComplexTypeDefinition(name, namespace);
            definition.setAnonymous(true);
            JBossXSModelGroup group = new JBossXSModelGroup();
            group.setCompositor((short)1);
            ArrayList<JBossXSParticle> particles = new ArrayList<JBossXSParticle>(1);
            JBossXSParticle particle = new JBossXSParticle();
            particle.setMaxOccurs(maxOccurs);
            particle.setMinOccurs(minOccurs);
            particle.setTerm((XSTerm)element);
            particles.add(particle);
            group.setParticles(particles);
            particle = new JBossXSParticle();
            particle.setTerm((XSTerm)group);
            definition.setParticle(particle);
            return definition;
        }

        private String analyzeType(XSTypeDefinition type, String parentName, String namespace) {
            String name = type.getAnonymous() ? ">" + parentName : type.getName();
            if (type.getAnonymous()) {
                this.anonymousTypeMap.put(namespace + ":" + name, type);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registered as anon type: {" + namespace + ":" + name + "} -> " + type));
                }
            }
            return name;
        }

        private void analyzeSimpleType(XSSimpleTypeDefinition simpleType, String parentName, String namespace) {
            this.analyzeType((XSTypeDefinition)simpleType, parentName, namespace);
        }

        private void analyzeComplexType(XSComplexTypeDefinition complexType, String parentName, String namespace) {
            if (this.processed.contains(complexType)) {
                return;
            }
            this.processed.add(complexType);
            String name = this.analyzeType((XSTypeDefinition)complexType, parentName, namespace);
            this.analyzeParticle(complexType.getParticle(), name, namespace);
        }

        private void analyzeParticle(XSParticle particle, String parentName, String namespace) {
            if (particle == null) {
                return;
            }
            XSTerm term = particle.getTerm();
            if (term == null) {
                return;
            }
            switch (term.getType()) {
                case 7: {
                    XSModelGroup group = (XSModelGroup)term;
                    XSObjectList list = group.getParticles();
                    for (int i = 0; i < list.getLength(); ++i) {
                        this.analyzeParticle((XSParticle)list.item(i), parentName, namespace);
                    }
                    break;
                }
                case 2: {
                    XSElementDeclaration decl = (XSElementDeclaration)term;
                    this.analyzeElement(decl, parentName, namespace, new Integer(particle.getMinOccurs()), new Integer(particle.getMaxOccurs()));
                }
            }
        }

        public XSTypeDefinition getTypeDefinition(String name, String namespace) {
            if (this.anonymousTypeMap == null) {
                this.build();
            }
            return this.anonymousTypeMap.get(namespace + ":" + name);
        }

        public XSElementDeclaration getElementDeclaration(String name, String namespace) {
            if (this.anonymousElementMap == null) {
                this.build();
            }
            return this.anonymousElementMap.get(namespace + ":" + name);
        }

        public Map<String, XSElementDeclaration> getElements() {
            if (this.anonymousElementMap == null) {
                this.build();
            }
            return this.anonymousElementMap;
        }

        public Map<String, XSTypeDefinition> getTypes() {
            if (this.anonymousTypeMap == null) {
                this.build();
            }
            return this.anonymousTypeMap;
        }
    }
}

